/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.nrg.plexiViewer.lite.ui.GenericIdentifier;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.utils.LiteFileUtils;
import org.nrg.xdat.bean.XnatAbstractresourceBean;
import org.nrg.xdat.bean.XnatDicomseriesBean;
import org.nrg.xdat.bean.XnatImageassessordataBean;
import org.nrg.xdat.bean.XnatImageresourceBean;
import org.nrg.xdat.bean.XnatImageresourceseriesBean;
import org.nrg.xdat.bean.XnatImagescandataBean;
import org.nrg.xdat.bean.XnatImagesessiondataBean;
import org.nrg.xdat.bean.XnatMrscandataBean;
import org.nrg.xdat.bean.XnatReconstructedimagedataBean;
import org.nrg.xdat.bean.XnatResourceBean;
import org.nrg.xdat.bean.XnatResourcecatalogBean;

public class UserInterfaceContents
implements Serializable {
    String sessionId;
    XnatImagesessiondataBean imageSession;
    private static final String RAW_TEXT = "RAW";
    private static final String RECONSTRUCTIONS_TEXT = "RECONSTRUCTIONS";
    private static final String ASSESSORS_TEXT = "ASSESSORS";
    private static final String RESOURCES_TEXT = "RESOURCES";
    private static final String defaultImageViewerClassName = "org.nrg.plexiViewer.lite.viewer.MR.MRImage";
    private static final String defaultLoResConverter = "org.nrg.plexiViewer.converter.DefaultConverter";
    private static final String defaultThumbnailConverter = "org.nrg.plexiViewer.converter.CNLThumbnailConverter";
    private Hashtable orientations;
    private String sessionLabel;

    public UserInterfaceContents(String sessionId) {
        this.sessionId = sessionId;
        this.orientations = new Hashtable();
        this.populateSelf(sessionId);
    }

    public UserInterfaceContents(String sessionId, XnatImagesessiondataBean imageSession) {
        this.sessionId = sessionId;
        this.imageSession = imageSession;
        this.orientations = new Hashtable();
    }

    public String getViewerClassName() {
        return defaultImageViewerClassName;
    }

    public String getConverterClassName() {
        return defaultLoResConverter;
    }

    public void populateSelf(String sessionId) {
        String suffix = HTTPDetails.getSuffix("PopulateServlet");
        URL populateServlet = null;
        try {
            suffix = suffix + "?sessionId=" + sessionId;
            populateServlet = HTTPDetails.getURL(HTTPDetails.getHost(), suffix);
            URLConnection servletConnection = populateServlet.openConnection();
            servletConnection.setUseCaches(false);
            InputStream is = servletConnection.getInputStream();
            ObjectInputStream inputStreamFromServlet = new ObjectInputStream(is);
            this.imageSession = (XnatImagesessiondataBean)inputStreamFromServlet.readObject();
            this.sessionLabel = this.imageSession.getLabel();
            inputStreamFromServlet.close();
            is.close();
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("UserInterfaceContents threw this exception");
            System.out.println(e);
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getSessionLabel() {
        return this.sessionLabel;
    }

    public void setSessionLabel(String sessionLabel) {
        this.sessionLabel = sessionLabel;
    }

    public Vector getValuesForData() {
        Vector<String> rtn = new Vector<String>();
        if (this.imageSession.getScans_scan() != null && this.imageSession.getScans_scan().size() > 0) {
            rtn.add(RAW_TEXT);
        }
        if (this.imageSession.getReconstructions_reconstructedimage() != null && this.imageSession.getReconstructions_reconstructedimage().size() > 0) {
            rtn.add(RECONSTRUCTIONS_TEXT);
        }
        if (this.imageSession.getAssessors_assessor() != null && this.imageSession.getAssessors_assessor().size() > 0) {
            rtn.add(ASSESSORS_TEXT);
        }
        return rtn;
    }

    public String getProject() {
        return this.imageSession.getProject();
    }

    public Vector getFileList(String dataStr, String typeStr) {
        Vector<GenericIdentifier> rtn;
        block10: {
            List assessors;
            block11: {
                block9: {
                    rtn = new Vector<GenericIdentifier>();
                    if (!RAW_TEXT.equals(dataStr)) break block9;
                    List scans = this.imageSession.getScans_scan();
                    if (scans.size() <= 0) break block10;
                    for (int i = 0; i < scans.size(); ++i) {
                        List files;
                        XnatImagescandataBean scan = (XnatImagescandataBean)scans.get(i);
                        if (!scan.getType().equals(typeStr) || (files = scan.getFile()) == null) continue;
                        for (int j = 0; j < files.size(); ++j) {
                            String display;
                            XnatAbstractresourceBean file = (XnatAbstractresourceBean)files.get(j);
                            if (!this.isImage(file) || (display = this.getStringToDisplay(file)).equalsIgnoreCase("SNAPSHOTS") || file.getLabel() != null && file.getLabel().equalsIgnoreCase("SECONDARY")) continue;
                            Vector ori = this.getOrientations(file, scan);
                            this.orientations.put(file, ori);
                            GenericIdentifier gid = new GenericIdentifier(scan.getId() + " - " + display, file, true);
                            rtn.add(gid);
                        }
                    }
                    break block10;
                }
                if (!RECONSTRUCTIONS_TEXT.equals(dataStr)) break block11;
                List recons = this.imageSession.getReconstructions_reconstructedimage();
                if (recons.size() <= 0) break block10;
                for (int i = 0; i < recons.size(); ++i) {
                    List files;
                    XnatReconstructedimagedataBean recon = (XnatReconstructedimagedataBean)recons.get(i);
                    if (!recon.getType().equals(typeStr) || (files = recon.getOut_file()) == null || files.size() <= 0) continue;
                    Hashtable uniqueContent = this.populateUniques(files);
                    for (int j = 0; j < files.size(); ++j) {
                        XnatAbstractresourceBean file = (XnatAbstractresourceBean)files.get(j);
                        if (!this.isImage(file)) continue;
                        String display = this.getStringToDisplay(file);
                        if (((Hashtable)uniqueContent.get(display)).size() > 1) {
                            display = display + " - " + LiteFileUtils.getFileName(file);
                        }
                        Vector ori = this.getOrientation(file);
                        this.orientations.put(file, ori);
                        GenericIdentifier gid = new GenericIdentifier(display, file, true);
                        rtn.add(gid);
                    }
                }
                break block10;
            }
            if (ASSESSORS_TEXT.equals(dataStr) && (assessors = this.imageSession.getAssessors_assessor()).size() > 0) {
                for (int i = 0; i < assessors.size(); ++i) {
                    List files;
                    XnatImageassessordataBean assessor = (XnatImageassessordataBean)assessors.get(i);
                    if (!assessor.getLabel().equals(typeStr) || (files = assessor.getOut_file()) == null || files.size() <= 0) continue;
                    Hashtable uniqueContent = this.populateUniques(files);
                    for (int j = 0; j < files.size(); ++j) {
                        XnatAbstractresourceBean file = (XnatAbstractresourceBean)files.get(j);
                        if (!this.isImage(file)) continue;
                        String display = this.getStringToDisplay(file);
                        if (((Hashtable)uniqueContent.get(display)).size() > 1) {
                            display = display + " - " + LiteFileUtils.getFileName(file);
                        }
                        Vector ori = this.getOrientation(file);
                        this.orientations.put(file, ori);
                        GenericIdentifier gid = new GenericIdentifier(display, file, true);
                        rtn.add(gid);
                    }
                }
            }
        }
        return rtn;
    }

    private Vector getOrientations(XnatAbstractresourceBean abs, XnatImagescandataBean scan) {
        XnatMrscandataBean mrScan;
        Vector ori = new Vector();
        ori = scan instanceof XnatMrscandataBean ? (this.isScanIsotropic((mrScan = (XnatMrscandataBean)scan).getParameters_voxelres_x(), mrScan.getParameters_voxelres_y(), mrScan.getParameters_voxelres_z()) ? this.getAcquiredOrientation() : this.getAcquiredOrientation(mrScan.getParameters_orientation())) : this.getAcquiredOrientation(null);
        return ori;
    }

    private Hashtable populateUniques(List files) {
        Hashtable<String, Hashtable> rtn = new Hashtable<String, Hashtable>();
        for (int j = 0; j < files.size(); ++j) {
            Hashtable indices;
            XnatAbstractresourceBean file = (XnatAbstractresourceBean)files.get(j);
            String display = this.getStringToDisplay(file);
            if (rtn.containsKey(display)) {
                indices = (Hashtable)rtn.get(display);
                indices.put(new Integer(j), "1");
                rtn.put(display, indices);
                continue;
            }
            indices = new Hashtable();
            indices.put(new Integer(j), "1");
            rtn.put(display, indices);
        }
        return rtn;
    }

    private boolean isImage(XnatAbstractresourceBean file) {
        boolean rtn = false;
        if (file instanceof XnatImageresourceBean || file instanceof XnatImageresourceseriesBean || file instanceof XnatDicomseriesBean || file instanceof XnatResourcecatalogBean) {
            rtn = true;
        }
        return rtn;
    }

    private String getStringToDisplay(XnatAbstractresourceBean file) {
        String rtn = file.getLabel();
        if (rtn != null) {
            return rtn;
        }
        if (file instanceof XnatResourceBean) {
            XnatResourceBean resource = (XnatResourceBean)file;
            rtn = resource.getContent();
        } else if (file instanceof XnatImageresourceBean) {
            XnatImageresourceBean resource = (XnatImageresourceBean)file;
            rtn = resource.getContent();
        } else if (file instanceof XnatImageresourceseriesBean) {
            XnatImageresourceseriesBean resource = (XnatImageresourceseriesBean)file;
            rtn = resource.getContent();
        } else if (file instanceof XnatDicomseriesBean) {
            XnatDicomseriesBean resource = (XnatDicomseriesBean)file;
            rtn = resource.getContent();
        } else if (file instanceof XnatResourcecatalogBean) {
            XnatResourcecatalogBean resource = (XnatResourcecatalogBean)file;
            rtn = resource.getContent();
        }
        return rtn;
    }

    public Vector getOrientations(XnatAbstractresourceBean file) {
        return (Vector)this.orientations.get(file);
    }

    private Vector getOrientation(XnatAbstractresourceBean file) {
        Vector ori = new Vector();
        if (file == null) {
            return ori;
        }
        if (file instanceof XnatImageresourceBean) {
            Double z;
            Double y;
            XnatImageresourceBean resource = (XnatImageresourceBean)file;
            Double x = resource.getVoxelres_x();
            ori = this.isScanIsotropic(x, y = resource.getVoxelres_y(), z = resource.getVoxelres_z()) ? this.getAcquiredOrientation() : this.getAcquiredOrientation(resource.getOrientation());
        } else if (file instanceof XnatImageresourceseriesBean) {
            Double z;
            Double y;
            XnatImageresourceseriesBean resource = (XnatImageresourceseriesBean)file;
            Double x = resource.getVoxelres_x();
            ori = this.isScanIsotropic(x, y = resource.getVoxelres_y(), z = resource.getVoxelres_z()) ? this.getAcquiredOrientation() : this.getAcquiredOrientation(resource.getOrientation());
        } else if (file instanceof XnatDicomseriesBean) {
            Double z;
            Double y;
            XnatDicomseriesBean resource = (XnatDicomseriesBean)file;
            Double x = resource.getVoxelres_x();
            ori = this.isScanIsotropic(x, y = resource.getVoxelres_y(), z = resource.getVoxelres_z()) ? this.getAcquiredOrientation() : this.getAcquiredOrientation(resource.getOrientation());
        } else if (file instanceof XnatResourcecatalogBean) {
            ori = this.getAcquiredOrientation(null);
        }
        return ori;
    }

    private boolean isScanIsotropic(Double d_voxel_x, Double d_voxel_y, Double d_voxel_z) {
        boolean rtn = false;
        if (d_voxel_x == null || d_voxel_y == null || d_voxel_z == null) {
            return rtn;
        }
        double threshold = 0.5;
        double voxel_x = d_voxel_x;
        double voxel_y = d_voxel_y;
        double voxel_z = d_voxel_z;
        if (Math.abs(voxel_x - voxel_y) < threshold && Math.abs(voxel_x - voxel_z) < threshold) {
            rtn = true;
        } else if (Math.abs(voxel_x - voxel_y) < threshold && Math.abs(voxel_y - voxel_z) < threshold) {
            rtn = true;
        } else if (Math.abs(voxel_x - voxel_z) < threshold && Math.abs(voxel_z - voxel_y) < threshold) {
            rtn = true;
        }
        return rtn;
    }

    private Vector getAcquiredOrientation(String ori) {
        String tra = "Transverse     ";
        String sag = "Sagittal       ";
        String cor = "Coronal        ";
        String acquired = "As Acquired    ";
        if (ori == null) {
            Vector<String> orientation = new Vector<String>();
            orientation.add(acquired);
            return orientation;
        }
        Vector<String> orientation = new Vector<String>();
        if (ori.toUpperCase().startsWith("TRA")) {
            orientation.add(tra);
        } else if (ori.toUpperCase().startsWith("SAG")) {
            orientation.add(sag);
        } else if (ori.toUpperCase().startsWith("COR")) {
            orientation.add(cor);
        } else {
            orientation.add(acquired);
        }
        return orientation;
    }

    private Vector getAcquiredOrientation() {
        String tra = "Transverse     ";
        String sag = "Sagittal       ";
        String cor = "Coronal        ";
        Vector<String> orientation = new Vector<String>();
        orientation.add(tra);
        orientation.add(sag);
        orientation.add(cor);
        return orientation;
    }

    public Vector getTypeValues(String data) {
        Vector<String> rtn;
        block5: {
            block7: {
                block6: {
                    rtn = new Vector<String>();
                    if (data == null) break block5;
                    if (!data.equals(RAW_TEXT)) break block6;
                    List scans = this.imageSession.getScans_scan();
                    Hashtable<String, String> uniqueScanTypes = new Hashtable<String, String>();
                    if (scans.size() <= 0) break block5;
                    for (int i = 0; i < scans.size(); ++i) {
                        XnatImagescandataBean scan = (XnatImagescandataBean)scans.get(i);
                        if (uniqueScanTypes.containsKey(scan.getType())) continue;
                        uniqueScanTypes.put(scan.getType(), "1");
                        rtn.add(scan.getType());
                    }
                    break block5;
                }
                if (!data.equals(RECONSTRUCTIONS_TEXT)) break block7;
                List recons = this.imageSession.getReconstructions_reconstructedimage();
                Hashtable<String, String> uniqueReconTypes = new Hashtable<String, String>();
                if (recons.size() <= 0) break block5;
                for (int i = 0; i < recons.size(); ++i) {
                    XnatReconstructedimagedataBean recon = (XnatReconstructedimagedataBean)recons.get(i);
                    if (uniqueReconTypes.containsKey(recon.getType())) continue;
                    uniqueReconTypes.put(recon.getType(), "1");
                    rtn.add(recon.getType());
                }
                break block5;
            }
            if (data.equals(ASSESSORS_TEXT)) {
                List assessors = this.imageSession.getAssessors_assessor();
                Hashtable<String, String> uniqueAssessorTypes = new Hashtable<String, String>();
                if (assessors.size() > 0) {
                    for (int i = 0; i < assessors.size(); ++i) {
                        XnatImageassessordataBean assessor = (XnatImageassessordataBean)assessors.get(i);
                        if (uniqueAssessorTypes.containsKey(assessor.getLabel())) continue;
                        uniqueAssessorTypes.put(assessor.getId(), "1");
                        rtn.add(assessor.getLabel());
                    }
                }
            }
        }
        return rtn;
    }
}

