/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite;

import java.io.Serializable;
import java.util.Vector;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.xdat.bean.XnatAbstractresourceBean;
import org.nrg.xdat.bean.XnatResourceBean;

public class UserSelection
implements Serializable,
Cloneable {
    boolean hasFile = false;
    boolean hasXnatFile = false;
    PlexiImageFile file = null;
    boolean hasScanNo = false;
    String scanNo;
    String orientation;
    boolean radiologic = false;
    String dataType;
    String display;
    String imageViewerClass;
    String sessionId;
    String exptId;
    String windowTitle;
    String project;
    String loResType = null;
    int hiResLayerNum = -1;
    float scaleFactor = 1.0f;
    boolean overwrite = false;
    Vector allFiles = new Vector();
    Vector hiResLayerNos = new Vector();
    String sessionLabel;
    XnatAbstractresourceBean xnatFile;

    public XnatAbstractresourceBean getXnatFile() {
        return this.xnatFile;
    }

    public void setXnatFile(XnatAbstractresourceBean xnatFile) {
        this.xnatFile = xnatFile;
        this.hasXnatFile = true;
    }

    public PlexiImageFile getFile() {
        return this.file;
    }

    public boolean hasFile() {
        return this.hasFile;
    }

    public boolean hasXnatFile() {
        return this.hasXnatFile;
    }

    public boolean hasScanNo() {
        return this.hasScanNo;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public boolean isRadiologic() {
        return this.radiologic;
    }

    public String getScanNo() {
        return this.scanNo;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setFile(PlexiImageFile gd) {
        this.file = gd;
        this.hasFile = true;
    }

    public void setOrientation(String string) {
        this.orientation = string;
    }

    public void setRadiologic(boolean b) {
        this.radiologic = b;
    }

    public void setScanNo(String string) {
        this.scanNo = string;
        this.hasScanNo = true;
    }

    public void setDataType(String string) {
        this.dataType = string;
    }

    public boolean isIdentical(UserSelection other) {
        return this.toString().equals(other.toString());
    }

    public boolean equals(Object b) {
        boolean rtn = false;
        if (b == null) {
            return false;
        }
        UserSelection bb = (UserSelection)b;
        rtn = this.isIdentical(bb);
        return rtn;
    }

    public String toString() {
        String rtn = "User Selected::\n";
        rtn = rtn + "Session Id: " + this.sessionId;
        rtn = rtn + "First Project: " + this.project;
        rtn = rtn + " Data : " + this.getDataType();
        String fileStr = "";
        if (this.hasFile && this.file != null) {
            fileStr = this.file.toString();
        }
        if (this.hasXnatFile && this.xnatFile != null) {
            fileStr = this.xnatFile.toString();
        }
        rtn = rtn + " File : " + fileStr;
        rtn = rtn + " Orientation: " + this.getOrientation();
        rtn = rtn + " Radiologic: " + this.isRadiologic();
        rtn = rtn + " Display: " + this.getDisplay();
        return rtn;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String string) {
        this.display = string;
    }

    public String getImageViewerClass() {
        return this.imageViewerClass;
    }

    public void setImageViewerClass(String string) {
        this.imageViewerClass = string;
    }

    public Object clone() {
        try {
            int i;
            UserSelection deepClone = (UserSelection)super.clone();
            if (this.allFiles == null) {
                deepClone.setAllFiles(null);
            } else {
                Vector<Object> cloneFiles = new Vector<Object>();
                for (i = 0; i < this.allFiles.size(); ++i) {
                    cloneFiles.addElement(((PlexiImageFile)this.allFiles.elementAt(i)).clone());
                }
                deepClone.setAllFiles(cloneFiles);
            }
            if (this.hiResLayerNos == null) {
                deepClone.setHiResLayerNos(null);
            } else {
                Vector<Integer> hiResNos = new Vector<Integer>();
                for (i = 0; i < this.hiResLayerNos.size(); ++i) {
                    hiResNos.addElement(new Integer((Integer)this.hiResLayerNos.elementAt(i)));
                }
                deepClone.setHiResLayerNos(hiResNos);
            }
            if (this.getFile() != null) {
                deepClone.setFile((PlexiImageFile)this.getFile().clone());
            }
            if (this.getXnatFile() != null) {
                deepClone.setXnatFile(this.getXnatFile());
            }
            return deepClone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getWindowTitle() {
        String rtn = "";
        if (this.windowTitle == null) {
            this.windowTitle = this.getSessionLabel() + ":" + this.getDataType() + this.getFilename();
        }
        rtn = this.windowTitle;
        return rtn;
    }

    public String getFormattedWindowTitle() {
        String rtn = this.getWindowTitle();
        rtn = rtn.replaceAll(":", "_");
        rtn = rtn.replaceAll(" ", "");
        return rtn;
    }

    private String getFilename() {
        XnatResourceBean rsc;
        String uri;
        int i;
        String rtn = this.getDataType();
        if (this.hasFile) {
            if (this.file.getName() != null) {
                rtn = rtn + ":" + this.file.getName();
            } else if (this.file.getURIAsString() != null) {
                String str = this.file.getURIAsString();
                int i2 = str.lastIndexOf("/");
                if (i2 != -1) {
                    try {
                        str = str.substring(i2 + 1);
                    }
                    catch (IndexOutOfBoundsException ioe) {
                        // empty catch block
                    }
                    rtn = rtn + ":" + str;
                }
            } else if (this.file.getResourceCatalogPath() != null) {
                rtn = rtn + ":" + this.file.getResourceCatalogPath();
            }
        } else if (this.hasXnatFile && this.xnatFile instanceof XnatResourceBean && (i = (uri = (rsc = (XnatResourceBean)this.xnatFile).getUri()).lastIndexOf("/")) != -1) {
            try {
                uri = uri.substring(i + 1);
            }
            catch (IndexOutOfBoundsException ioe) {
                // empty catch block
            }
            rtn = rtn + ":" + uri;
        }
        return rtn;
    }

    public void setWindowTitle(String string) {
        this.windowTitle = string;
    }

    public String getProject() {
        return this.project;
    }

    public void setProject(String string) {
        this.project = string;
    }

    public String getLoResType() {
        return this.loResType;
    }

    public void setLoResType(String string) {
        this.loResType = string;
    }

    public int getHiResLayerNum() {
        return this.hiResLayerNum;
    }

    public void setHiResLayerNum(int i) {
        this.hiResLayerNum = i;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(float f) {
        this.scaleFactor = f;
    }

    public boolean canOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public Vector getAllFiles() {
        return this.allFiles;
    }

    public void setAllFiles(Vector vector) {
        this.allFiles = vector;
    }

    public String getExptId() {
        return this.exptId;
    }

    public void setExptId(String string) {
        this.exptId = string;
    }

    public Vector getHiResLayerNos() {
        return this.hiResLayerNos;
    }

    public void setHiResLayerNos(Vector vector) {
        this.hiResLayerNos = vector;
    }

    public String getSessionLabel() {
        return this.sessionLabel;
    }

    public void setSessionLabel(String sessionLabel) {
        this.sessionLabel = sessionLabel;
    }
}

