/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.display;

import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.display.PlexiNativeCoordinates;
import org.nrg.plexiViewer.lite.display.Point3d;
import org.nrg.plexiViewer.lite.xml.Layout;

public class PlexiCoordinates {
    MontageDisplay mDisplay;
    int radiologic;
    String view;
    Point3d bBoxStart = new Point3d();
    Point3d bboxDim;
    Point3d imageDim;
    Point3d origin;
    int scale;
    int voxelSize;
    int montageIncrement;
    int nMontageColumns;
    Point3d talPos;
    float montageScale;
    boolean nativeSpace;

    public PlexiCoordinates(int imgX, int imgY, int imgZ, MontageDisplay mDisplay, String view, boolean radiologic, int nColumns) {
        Layout l = mDisplay.getLayout();
        this.mDisplay = mDisplay;
        this.bboxDim = l.getName().equalsIgnoreCase("TAL_111") ? new Point3d(176.0f, 208.0f, 176.0f) : (l.getName().equalsIgnoreCase("TAL_222") ? new Point3d(128.0f, 128.0f, 75.0f) : (l.getName().equalsIgnoreCase("TAL_333") ? new Point3d(48.0f, 64.0f, 48.0f) : new Point3d(imgX, imgY, imgZ)));
        this.imageDim = new Point3d(imgX, imgY, imgZ);
        this.origin = l.getOrigin();
        this.scale = 1;
        this.montageIncrement = mDisplay.getSliceSpacing();
        this.montageScale = mDisplay.getScale();
        this.voxelSize = l.getVoxelSize();
        this.radiologic = radiologic ? -1 : 1;
        this.view = view;
        this.nMontageColumns = nColumns;
        this.talPos = new Point3d();
        this.nativeSpace = l.getName().equalsIgnoreCase("native");
    }

    public void setTalFromStack(int winX, int winY, int slice) {
        winX /= this.scale;
        winY /= this.scale;
        if (this.nativeSpace) {
            this.talPos.x = winX;
            this.talPos.y = winY;
            this.talPos.z = slice;
        } else if (this.view.equalsIgnoreCase("TRANSVERSE")) {
            this.talPos.x = (float)this.radiologic * ((float)winX - this.origin.x) * (float)this.voxelSize;
            this.talPos.y = (this.origin.y - (float)winY) * (float)this.voxelSize;
            this.talPos.z = ((float)slice - this.origin.z) * (float)this.voxelSize;
        } else if (this.view.equalsIgnoreCase("CORONAL")) {
            this.talPos.x = (float)this.radiologic * ((float)winX - this.origin.x) * (float)this.voxelSize;
            this.talPos.y = (this.bboxDim.z - this.origin.z - (float)winY) * (float)this.voxelSize;
            this.talPos.z = (this.origin.y - (float)slice) * (float)this.voxelSize;
        } else if (this.view.equalsIgnoreCase("SAGITTAL")) {
            this.talPos.x = (this.origin.y - (float)winX) * (float)this.voxelSize;
            this.talPos.y = (this.bboxDim.z - this.origin.z - (float)winY) * (float)this.voxelSize;
            this.talPos.z = ((float)slice - this.origin.x) * (float)this.voxelSize;
        }
    }

    public void setTalFromMontage(int winX, int winY) {
        int x = 0;
        int y = 0;
        int z = 0;
        int sliceNum = 0;
        winX /= this.scale;
        winY /= this.scale;
        int montageStartSlice = this.mDisplay.getStartSlice();
        if (this.nativeSpace) {
            float rowHeight = this.montageScale * this.bboxDim.y;
            float colWidth = this.montageScale * this.bboxDim.x;
            int row = (int)Math.floor((float)winY / rowHeight);
            int col = (int)Math.ceil((float)winX / colWidth);
            int mSliceNum = montageStartSlice + (row * this.nMontageColumns + col - 1) * this.montageIncrement;
            this.talPos.z = mSliceNum;
            this.talPos.x = (float)winX - (float)(col - 1) * colWidth;
            this.talPos.y = (float)winY - (float)row * rowHeight;
            this.talPos.x /= this.montageScale;
            this.talPos.y /= this.montageScale;
        } else if (this.view.equalsIgnoreCase("TRANSVERSE")) {
            sliceNum = (int)Math.floor((float)winY / (this.montageScale * this.bboxDim.y)) * this.nMontageColumns + (int)Math.ceil((float)winX / (this.montageScale * this.bboxDim.x));
            int bboxDimXY = (int)(this.bboxDim.x * this.montageScale);
            this.talPos.z = ((float)(montageStartSlice + this.montageIncrement * (sliceNum - 1)) - this.origin.z) * (float)this.voxelSize;
            x = winX % bboxDimXY;
            this.talPos.x = (float)this.radiologic * ((float)((int)((float)x / this.montageScale)) - this.origin.x) * (float)this.voxelSize;
            bboxDimXY = (int)(this.bboxDim.y * this.montageScale);
            y = winY % bboxDimXY;
            this.talPos.y = (this.origin.y - (float)((int)((float)y / this.montageScale))) * (float)this.voxelSize;
        } else if (this.view.equalsIgnoreCase("CORONAL")) {
            sliceNum = (int)Math.floor((float)winY / (this.montageScale * this.bboxDim.z)) * this.nMontageColumns + (int)Math.ceil((float)winX / (this.montageScale * this.bboxDim.x));
            this.talPos.z = (this.origin.y - (float)(montageStartSlice + this.montageIncrement * (sliceNum - 1))) * (float)this.voxelSize;
            int bboxDimXY = (int)(this.bboxDim.x * this.montageScale);
            x = winX % bboxDimXY;
            this.talPos.x = (float)this.radiologic * ((float)((int)((float)x / this.montageScale)) - this.origin.x) * (float)this.voxelSize;
            bboxDimXY = (int)(this.bboxDim.z * this.montageScale);
            z = winY % bboxDimXY;
            this.talPos.y = -((float)((int)((float)z / this.montageScale)) + (this.origin.z - this.bboxDim.z)) * (float)this.voxelSize;
        } else if (this.view.equalsIgnoreCase("SAGITTAL")) {
            sliceNum = (int)Math.floor((float)winY / (this.montageScale * this.bboxDim.z)) * this.nMontageColumns + (int)Math.ceil((float)winX / (this.bboxDim.y * this.montageScale));
            this.talPos.z = ((float)(montageStartSlice + this.montageIncrement * (sliceNum - 1)) - this.origin.x) * (float)this.voxelSize;
            int bboxDimXY = (int)(this.bboxDim.y * this.montageScale);
            y = winX % bboxDimXY;
            this.talPos.x = (this.origin.y - (float)y / this.montageScale) * (float)this.voxelSize;
            bboxDimXY = (int)(this.bboxDim.z * this.montageScale);
            z = winY % bboxDimXY;
            this.talPos.y = (this.bboxDim.z - this.origin.z - (float)((int)((float)z / this.montageScale))) * (float)this.voxelSize;
        }
    }

    public void setTalFromSlice(int slice) {
        if (this.nativeSpace) {
            this.talPos.z = slice;
        } else if (this.view.equalsIgnoreCase("TRANSVERSE")) {
            this.talPos.z = ((float)slice - this.origin.z) * (float)this.voxelSize;
        } else if (this.view.equalsIgnoreCase("CORONAL")) {
            this.talPos.z = (this.origin.y - (float)slice) * (float)this.voxelSize;
        } else if (this.view.equalsIgnoreCase("SAGITTAL")) {
            this.talPos.z = ((float)slice - this.origin.x) * (float)this.voxelSize;
        }
    }

    public Point3d getPosWindow(String display, String fromView, boolean fromRadiologic) {
        int x = 0;
        int y = 0;
        int z = 0;
        int montageStartSlice = this.mDisplay.getStartSlice();
        if (display.equalsIgnoreCase("STACK")) {
            if (this.nativeSpace) {
                Point3d rtn = PlexiNativeCoordinates.getNativeCoordinates(this.talPos, fromView, this.view, this.radiologic == -1, this.imageDim, fromRadiologic, this.scale);
                return rtn;
            }
            Point3d rtn = PlexiNativeCoordinates.getTalCoordinates(this.talPos, fromView, this.view, this.radiologic, this.bboxDim, this.imageDim, this.origin, this.voxelSize, this.scale, fromRadiologic);
            return rtn;
        }
        if (display.equalsIgnoreCase("MONTAGE")) {
            int nBox = 0;
            if (this.nativeSpace) {
                nBox = (int)(((float)montageStartSlice - this.talPos.z) / (float)Math.abs(this.montageIncrement));
                int nRow = nBox / this.nMontageColumns;
                int nColumn = nBox - nRow * this.nMontageColumns - 1;
                System.out.println("Reverse Comp BOX: " + nBox + "\t Row " + nRow + "\t Col " + nColumn);
                x = (int)((float)nColumn * this.bboxDim.x) + (int)(this.talPos.x / (float)this.voxelSize);
                y = (int)((float)nRow * this.bboxDim.y) + (int)(this.talPos.y / (float)this.voxelSize);
                z = (int)this.talPos.z;
                return PlexiNativeCoordinates.getNativeCoordinates(x, y, z, fromView, this.view, this.radiologic == -1, this.imageDim, fromRadiologic, this.scale);
            }
            if (this.view.equalsIgnoreCase("TRANSVERSE")) {
                nBox = (int)(((float)montageStartSlice - this.talPos.z / (float)this.voxelSize - this.origin.z) / (float)Math.abs(this.montageIncrement));
                int nRow = nBox / this.nMontageColumns;
                int nColumn = nBox - nRow * this.nMontageColumns;
                x = (int)((float)nColumn * this.bboxDim.x + (float)((int)(this.origin.x + this.talPos.x / (float)this.voxelSize)));
                y = (int)((float)nRow * this.bboxDim.y + (float)((int)(this.origin.y - this.talPos.y / (float)this.voxelSize)));
            } else if (this.view.equalsIgnoreCase("CORONAL")) {
                nBox = (int)(-((float)montageStartSlice + this.talPos.z / (float)this.voxelSize - this.origin.y) / (float)Math.abs(this.montageIncrement));
                int nRow = nBox / this.nMontageColumns;
                int nColumn = nBox - nRow * this.nMontageColumns;
                x = (int)((float)nColumn * this.bboxDim.x + (float)((int)(this.origin.x + this.talPos.x / (float)this.voxelSize)));
                y = (int)((float)nRow * this.bboxDim.z - (float)((int)(this.talPos.y / (float)this.voxelSize + this.origin.z - this.bboxDim.z)));
            } else if (this.view.equalsIgnoreCase("SAGITTAL")) {
                nBox = (int)((this.talPos.z / (float)this.voxelSize - (float)montageStartSlice + this.origin.x) / (float)Math.abs(this.montageIncrement));
                int nRow = nBox / this.nMontageColumns;
                int nColumn = nBox - nRow * this.nMontageColumns;
                x = (int)((float)nColumn * this.bboxDim.y + (float)((int)(this.origin.y - this.talPos.x / (float)this.voxelSize)));
                y = (int)((float)nRow * this.bboxDim.z - (float)((int)(this.talPos.y / (float)this.voxelSize + this.origin.z - this.bboxDim.z)));
            }
            z = nBox;
        }
        Point3d p = new Point3d(x * this.scale, y * this.scale, z);
        return p;
    }

    public Point3d getPosTal() {
        return this.talPos;
    }

    public void setTalFromTal(Point3d p) {
        this.talPos.set(p);
    }

    public void setTalFromTal(int x, int y, int z) {
        this.talPos.set(x, y, z);
    }

    public void setBboxDim(Point3d point3d) {
        this.bboxDim = point3d;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int i) {
        this.scale = i;
    }
}

