/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackProcessor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.nrg.plexiViewer.lite.gui.ContrastPlot;
import org.nrg.plexiViewer.lite.gui.TrimmedLabel;

public class PlexiAdjusterWindow
extends Frame
implements AdjustmentListener,
WindowListener,
Runnable {
    static final int AUTO_THRESHOLD = 5000;
    static final String[] channelLabels = new String[]{"Red", "Green", "Blue", "Cyan", "Magenta", "Yellow", "RGB"};
    static final int[] channelConstants = new int[]{4, 2, 1, 3, 5, 6, 7};
    ContrastPlot plot = new ContrastPlot();
    Thread thread = null;
    private static PlexiAdjusterWindow adjuster = null;
    public boolean instance;
    int minSliderValue = -1;
    int maxSliderValue = -1;
    int brightnessValue = -1;
    int contrastValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doSet;
    boolean doApplyLut;
    boolean doThreshold;
    boolean doUpdate;
    Panel panel;
    Panel tPanel;
    Button autoB;
    Button resetB;
    Button setB;
    Button applyB;
    Button threshB;
    Button updateB;
    int previousImageID;
    int previousType;
    Object previousSnapshot;
    ImageJ ij;
    double min;
    double max;
    double previousMin;
    double previousMax;
    double defaultMin;
    double defaultMax;
    int contrast;
    int brightness;
    boolean RGBImage;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Scrollbar contrastSlider;
    Scrollbar brightnessSlider;
    Label minLabel;
    Label maxLabel;
    Label windowLabel;
    Label levelLabel;
    boolean done;
    int autoThreshold;
    GridBagLayout gridbag;
    GridBagConstraints c;
    int y = 0;
    boolean windowLevel;
    boolean balance;
    Font monoFont = new Font("Monospaced", 0, 12);
    Font sanFont = new Font("SansSerif", 0, 12);
    int channels = 7;
    Choice choice;
    ImagePlus imp;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int SET = 2;
    static final int APPLY = 3;
    static final int THRESHOLD = 4;
    static final int MIN = 5;
    static final int MAX = 6;
    static final int BRIGHTNESS = 7;
    static final int CONTRAST = 8;
    static final int UPDATE = 9;

    public PlexiAdjusterWindow() {
        super("B&C");
        this.addWindowListener(this);
        this.instance = false;
    }

    public static PlexiAdjusterWindow GetInstance() {
        if (adjuster == null) {
            adjuster = new PlexiAdjusterWindow();
        }
        return adjuster;
    }

    public void display() {
        if (WindowManager.getCurrentWindow() != null) {
            this.imp = WindowManager.getCurrentWindow().getImagePlus();
            if (!this.instance) {
                this.init();
                this.instance = true;
            } else {
                this.setVisible(true);
            }
            this.initRest();
        } else {
            System.out.println("XNATAdjuster::There is no image to display");
        }
    }

    private void init() {
        this.windowLevel = false;
        this.balance = false;
        this.ij = IJ.getInstance();
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(this.gridbag);
        this.c.gridx = 0;
        this.y = 0;
        this.c.gridy = this.y++;
        this.c.fill = 1;
        this.c.anchor = 10;
        this.c.insets = new Insets(10, 10, 0, 10);
        this.gridbag.setConstraints(this.plot, this.c);
        this.add(this.plot);
        if (!this.windowLevel) {
            this.panel = new Panel();
            this.c.gridy = this.y++;
            this.c.insets = new Insets(0, 10, 0, 10);
            this.gridbag.setConstraints(this.panel, this.c);
            this.panel.setLayout(new BorderLayout());
            this.minLabel = new Label("      ", 0);
            this.minLabel.setFont(this.monoFont);
            this.panel.add("West", this.minLabel);
            this.maxLabel = new Label("      ", 2);
            this.maxLabel.setFont(this.monoFont);
            this.panel.add("East", this.maxLabel);
            this.add(this.panel);
        }
        if (!this.windowLevel) {
            this.minSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.minSlider, this.c);
            this.add(this.minSlider);
            this.minSlider.addAdjustmentListener(this);
            this.minSlider.setUnitIncrement(1);
            this.addLabel("Minimum", null);
        }
        if (!this.windowLevel) {
            this.maxSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.maxSlider, this.c);
            this.add(this.maxSlider);
            this.maxSlider.addAdjustmentListener(this);
            this.maxSlider.setUnitIncrement(1);
            this.addLabel("Maximum", null);
        }
        this.brightnessSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
        this.c.gridy = this.y++;
        this.c.insets = new Insets(this.windowLevel ? 12 : 2, 10, 0, 10);
        this.gridbag.setConstraints(this.brightnessSlider, this.c);
        this.add(this.brightnessSlider);
        this.brightnessSlider.addAdjustmentListener(this);
        this.brightnessSlider.setUnitIncrement(1);
        if (this.windowLevel) {
            this.levelLabel = new TrimmedLabel("        ");
            this.addLabel("Level: ", this.levelLabel);
        } else {
            this.addLabel("Brightness", null);
        }
        if (!this.balance) {
            this.contrastSlider = new Scrollbar(0, this.sliderRange / 2, 1, 0, this.sliderRange);
            this.c.gridy = this.y++;
            this.c.insets = new Insets(2, 10, 0, 10);
            this.gridbag.setConstraints(this.contrastSlider, this.c);
            this.add(this.contrastSlider);
            this.contrastSlider.addAdjustmentListener(this);
            this.contrastSlider.setUnitIncrement(1);
            if (this.windowLevel) {
                this.windowLabel = new TrimmedLabel("        ");
                this.addLabel("Window: ", this.windowLabel);
            } else {
                this.addLabel("Contrast", null);
            }
        }
        this.pack();
        GUI.center((Window)this);
        this.show();
    }

    void initRest() {
        if (this.done) {
            this.done = false;
        }
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "ContrastAdjuster");
            this.thread.start();
        }
        this.setup();
    }

    void addLabel(String text, Label label2) {
        this.panel = new Panel();
        this.c.gridy = this.y++;
        this.c.insets = new Insets(0, 10, 0, 0);
        this.gridbag.setConstraints(this.panel, this.c);
        this.panel.setLayout(new FlowLayout(label2 == null ? 1 : 0, 0, 0));
        TrimmedLabel label = new TrimmedLabel(text);
        label.setFont(this.sanFont);
        this.panel.add(label);
        if (label2 != null) {
            label2.setFont(this.monoFont);
            label2.setAlignment(0);
            this.panel.add(label2);
        }
        this.add(this.panel);
    }

    void setup() {
        if (this.imp != null) {
            ImageProcessor ip = this.imp.getProcessor();
            this.setup(this.imp);
            this.updatePlot();
            this.updateLabels(this.imp, ip);
            this.imp.updateAndDraw();
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minSliderValue = this.minSlider.getValue();
        } else if (e.getSource() == this.maxSlider) {
            this.maxSliderValue = this.maxSlider.getValue();
        } else if (e.getSource() == this.contrastSlider) {
            this.contrastValue = this.contrastSlider.getValue();
        } else {
            this.brightnessValue = this.brightnessSlider.getValue();
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        boolean snapshotChanged;
        ImageProcessor ip = imp.getProcessor();
        int type = imp.getType();
        this.RGBImage = type == 4;
        boolean bl = snapshotChanged = this.RGBImage && this.previousSnapshot != null && ((ColorProcessor)ip).getSnapshotPixels() != this.previousSnapshot;
        if (imp.getID() != this.previousImageID || snapshotChanged || type != this.previousType) {
            this.setupNewImage(imp, ip);
        }
        this.previousImageID = imp.getID();
        this.previousType = type;
        return ip;
    }

    void setupNewImage(ImagePlus imp, ImageProcessor ip) {
        this.previousMin = this.min;
        this.previousMax = this.max;
        if (this.RGBImage) {
            ip.snapshot();
            this.previousSnapshot = ((ColorProcessor)ip).getSnapshotPixels();
        } else {
            this.previousSnapshot = null;
        }
        double min2 = ip.getMin();
        double max2 = ip.getMax();
        if (imp.getType() == 4) {
            min2 = 0.0;
            max2 = 255.0;
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.setMinAndMax(ip, min2, max2);
        this.min = ip.getMin();
        this.max = ip.getMax();
        if (IJ.debugMode) {
            IJ.log((String)("min: " + this.min));
            IJ.log((String)("max: " + this.max));
            IJ.log((String)("defaultMin: " + this.defaultMin));
            IJ.log((String)("defaultMax: " + this.defaultMax));
        }
        this.plot.defaultMin = this.defaultMin;
        this.plot.defaultMax = this.defaultMax;
        this.plot.histogram = null;
        this.updateScrollBars(null);
        if (!this.doReset) {
            this.plotHistogram(imp);
        }
        this.autoThreshold = 0;
    }

    void setMinAndMax(ImageProcessor ip, double min, double max) {
        if (this.channels != 7 && ip instanceof ColorProcessor) {
            ((ColorProcessor)ip).setMinAndMax(min, max, this.channels);
        } else {
            ip.setMinAndMax(min, max);
        }
    }

    void updatePlot() {
        this.plot.min = this.min;
        this.plot.max = this.max;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        int digits;
        boolean realValue;
        double min = ip.getMin();
        double max = ip.getMax();
        int type = imp.getType();
        Calibration cal = imp.getCalibration();
        boolean bl = realValue = type == 2;
        if (cal.calibrated()) {
            min = cal.getCValue((int)min);
            max = cal.getCValue((int)max);
            if (type != 1) {
                realValue = true;
            }
        }
        int n = digits = realValue ? 2 : 0;
        if (this.windowLevel) {
            double window = max - min;
            double level = min + window / 2.0;
            this.windowLabel.setText(IJ.d2s((double)window, (int)digits));
            this.levelLabel.setText(IJ.d2s((double)level, (int)digits));
        } else {
            this.minLabel.setText(IJ.d2s((double)min, (int)digits));
            this.maxLabel.setText(IJ.d2s((double)max, (int)digits));
        }
    }

    void updateScrollBars(Scrollbar sb) {
        if (sb == null || sb != this.contrastSlider) {
            double mid = this.sliderRange / 2;
            double c = (this.defaultMax - this.defaultMin) / (this.max - this.min) * mid;
            if (c > mid) {
                c = (double)this.sliderRange - (this.max - this.min) / (this.defaultMax - this.defaultMin) * mid;
            }
            this.contrast = (int)c;
            if (this.contrastSlider != null) {
                this.contrastSlider.setValue(this.contrast);
            }
        }
        if (sb == null || sb != this.brightnessSlider) {
            double level = this.min + (this.max - this.min) / 2.0;
            double normalizedLevel = 1.0 - (level - this.defaultMin) / (this.defaultMax - this.defaultMin);
            this.brightness = (int)(normalizedLevel * (double)this.sliderRange);
            this.brightnessSlider.setValue(this.brightness);
        }
        if (this.minSlider != null && (sb == null || sb != this.minSlider)) {
            this.minSlider.setValue(this.scaleDown(this.min));
        }
        if (this.maxSlider != null && (sb == null || sb != this.maxSlider)) {
            this.maxSlider.setValue(this.scaleDown(this.max));
        }
    }

    int scaleDown(double v) {
        if (v < this.defaultMin) {
            v = this.defaultMin;
        }
        if (v > this.defaultMax) {
            v = this.defaultMax;
        }
        return (int)((v - this.defaultMin) * 255.0 / (this.defaultMax - this.defaultMin));
    }

    void adjustMin(ImagePlus imp, ImageProcessor ip, double minvalue) {
        this.min = this.defaultMin + minvalue * (this.defaultMax - this.defaultMin) / 255.0;
        if (this.max > this.defaultMax) {
            this.max = this.defaultMax;
        }
        if (this.min > this.max) {
            this.max = this.min;
        }
        this.setMinAndMax(ip, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        this.updateScrollBars(this.minSlider);
    }

    void adjustMax(ImagePlus imp, ImageProcessor ip, double maxvalue) {
        this.max = this.defaultMin + maxvalue * (this.defaultMax - this.defaultMin) / 255.0;
        if (this.min < 0.0) {
            this.min = 0.0;
        }
        if (this.max < this.min) {
            this.min = this.max;
        }
        this.setMinAndMax(ip, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        this.updateScrollBars(this.maxSlider);
    }

    void adjustBrightness(ImagePlus imp, ImageProcessor ip, double bvalue) {
        double center = this.defaultMin + (this.defaultMax - this.defaultMin) * (((double)this.sliderRange - bvalue) / (double)this.sliderRange);
        double width = this.max - this.min;
        this.min = center - width / 2.0;
        this.max = center + width / 2.0;
        this.setMinAndMax(ip, this.min, this.max);
        if (this.min == this.max) {
            this.setThreshold(ip);
        }
        this.updateScrollBars(this.brightnessSlider);
    }

    void adjustContrast(ImagePlus imp, ImageProcessor ip, int cvalue) {
        double center = this.min + (this.max - this.min) / 2.0;
        double range = this.defaultMax - this.defaultMin;
        double mid = this.sliderRange / 2;
        double slope = (double)cvalue <= mid ? (double)cvalue / mid : mid / (double)(this.sliderRange - cvalue);
        if (slope > 0.0) {
            this.min = center - 0.5 * range / slope;
            this.max = center + 0.5 * range / slope;
        }
        this.setMinAndMax(ip, this.min, this.max);
        this.updateScrollBars(this.contrastSlider);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
            this.plot.defaultMin = this.defaultMin;
            this.plot.defaultMax = this.defaultMax;
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(ip, this.min, this.max);
        this.updateScrollBars(null);
        this.plotHistogram(imp);
        this.autoThreshold = 0;
    }

    void update(ImagePlus imp, ImageProcessor ip) {
        if (this.previousMin == 0.0 && this.previousMax == 0.0 || imp.getType() != this.previousType) {
            IJ.beep();
        } else {
            this.min = this.previousMin;
            this.max = this.previousMax;
            this.setMinAndMax(ip, this.min, this.max);
            this.updateScrollBars(null);
            this.plotHistogram(imp);
        }
    }

    void plotHistogram(ImagePlus imp) {
        ImageStatistics stats;
        if (this.balance && (this.channels == 4 || this.channels == 2 || this.channels == 1) && imp.getType() == 4) {
            int w = imp.getWidth();
            int h = imp.getHeight();
            byte[] r = new byte[w * h];
            byte[] g = new byte[w * h];
            byte[] b = new byte[w * h];
            ((ColorProcessor)imp.getProcessor()).getRGB(r, g, b);
            byte[] pixels = null;
            if (this.channels == 4) {
                pixels = r;
            } else if (this.channels == 2) {
                pixels = g;
            } else if (this.channels == 1) {
                pixels = b;
            }
            ByteProcessor ip = new ByteProcessor(w, h, pixels, null);
            stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)0, (Calibration)imp.getCalibration());
        } else {
            stats = imp.getStatistics();
        }
        this.plot.setHistogram(stats);
    }

    void apply(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            imp.unlock();
        }
        if (!imp.lock()) {
            return;
        }
        if (imp.getType() == 4) {
            if (imp.getStackSize() > 1) {
                this.applyRGBStack(imp);
            } else {
                ip.snapshot();
                this.reset(imp, ip);
                imp.changes = true;
            }
            imp.unlock();
            return;
        }
        if (imp.getType() != 0) {
            IJ.beep();
            IJ.showStatus((String)"Apply requires an 8-bit grayscale image or an RGB stack");
            imp.unlock();
            return;
        }
        int[] table = new int[256];
        int min = (int)ip.getMin();
        int max = (int)ip.getMax();
        for (int i = 0; i < 256; ++i) {
            table[i] = i <= min ? 0 : (i >= max ? 255 : (int)((double)(i - min) / (double)(max - min) * 255.0));
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            YesNoCancelDialog d = new YesNoCancelDialog((Frame)this, "Entire Stack?", "Apply LUT to all " + stack.getSize() + " slices in the stack?");
            if (d.cancelPressed()) {
                imp.unlock();
                return;
            }
            if (d.yesPressed()) {
                new StackProcessor(stack, ip).applyTable(table);
            } else {
                ip.applyTable(table);
            }
        } else {
            ip.applyTable(table);
        }
        this.reset(imp, ip);
        imp.changes = true;
        imp.unlock();
    }

    void applyRGBStack(ImagePlus imp) {
        int current = imp.getCurrentSlice();
        int n = imp.getStackSize();
        if (!IJ.showMessageWithCancel((String)"Update Entire Stack?", (String)("Apply brightness and contrast settings\nto all " + n + " slices in the stack?\n \n" + "NOTE: There is no Undo for this operation."))) {
            return;
        }
        for (int i = 1; i <= n; ++i) {
            if (i == current) continue;
            imp.setSlice(i);
            ImageProcessor ip = imp.getProcessor();
            this.setMinAndMax(ip, this.min, this.max);
            IJ.showProgress((double)((double)i / (double)n));
        }
        imp.setSlice(current);
        imp.changes = true;
    }

    void threshold(ImagePlus imp, ImageProcessor ip) {
        int threshold = (int)((this.defaultMax - this.defaultMin) / 2.0);
        this.min = threshold;
        this.max = threshold;
        this.setMinAndMax(ip, this.min, this.max);
        this.setThreshold(ip);
        this.updateScrollBars(null);
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(this.max, 255.0, 2);
        } else {
            ip.setThreshold(0.0, this.max, 2);
        }
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            boolean bl = found = histogram[++i] > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            boolean bl = found = histogram[--i] > threshold;
        } while (!found && i > 0);
        int hmax = i;
        if (hmax >= hmin) {
            imp.killRoi();
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            if (this.min == this.max) {
                this.min = stats.min;
                this.max = stats.max;
            }
        } else {
            this.reset(imp, ip);
            return;
        }
        this.setMinAndMax(ip, this.min, this.max);
        this.updateScrollBars(null);
    }

    void setMinAndMax(ImagePlus imp, ImageProcessor ip) {
        this.min = ip.getMin();
        this.max = ip.getMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        GenericDialog gd = new GenericDialog("Set Min and Max");
        gd.addNumericField("Minimum Displayed Value: ", minValue, digits);
        gd.addNumericField("Maximum Displayed Value: ", maxValue, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        minValue = gd.getNextNumber();
        maxValue = gd.getNextNumber();
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(ip, this.min, this.max);
            this.updateScrollBars(null);
        }
    }

    void setWindowLevel(ImagePlus imp, ImageProcessor ip) {
        this.min = ip.getMin();
        this.max = ip.getMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        double windowValue = maxValue - minValue;
        double levelValue = minValue + windowValue / 2.0;
        GenericDialog gd = new GenericDialog("Set W&L");
        gd.addNumericField("Window Center (Level): ", levelValue, digits);
        gd.addNumericField("Window Width: ", windowValue, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        levelValue = gd.getNextNumber();
        windowValue = gd.getNextNumber();
        minValue = levelValue - windowValue / 2.0;
        maxValue = levelValue + windowValue / 2.0;
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(ip, minValue, maxValue);
            this.updateScrollBars(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.done) {
            PlexiAdjusterWindow plexiAdjusterWindow = this;
            synchronized (plexiAdjusterWindow) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int minvalue = this.minSliderValue;
        int maxvalue = this.maxSliderValue;
        int bvalue = this.brightnessValue;
        int cvalue = this.contrastValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doSet) {
            action = 2;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doThreshold) {
            action = 4;
        } else if (this.doUpdate) {
            action = 9;
        } else if (this.minSliderValue >= 0) {
            action = 5;
        } else if (this.maxSliderValue >= 0) {
            action = 6;
        } else if (this.brightnessValue >= 0) {
            action = 7;
        } else if (this.contrastValue >= 0) {
            action = 8;
        } else {
            return;
        }
        this.contrastValue = -1;
        this.brightnessValue = -1;
        this.maxSliderValue = -1;
        this.minSliderValue = -1;
        this.doUpdate = false;
        this.doThreshold = false;
        this.doApplyLut = false;
        this.doSet = false;
        this.doAutoAdjust = false;
        this.doReset = false;
        if (this.imp == null) {
            IJ.beep();
            IJ.showStatus((String)"No image");
            return;
        }
        ImageProcessor ip = action != 9 ? this.setup(this.imp) : this.imp.getProcessor();
        if (this.RGBImage && !this.imp.lock()) {
            this.imp = null;
            return;
        }
        switch (action) {
            case 0: {
                this.reset(this.imp, ip);
                break;
            }
            case 1: {
                this.autoAdjust(this.imp, ip);
                break;
            }
            case 2: {
                if (this.windowLevel) {
                    this.setWindowLevel(this.imp, ip);
                    break;
                }
                this.setMinAndMax(this.imp, ip);
                break;
            }
            case 3: {
                this.apply(this.imp, ip);
                break;
            }
            case 4: {
                this.threshold(this.imp, ip);
                break;
            }
            case 9: {
                this.update(this.imp, ip);
                break;
            }
            case 5: {
                this.adjustMin(this.imp, ip, minvalue);
                break;
            }
            case 6: {
                this.adjustMax(this.imp, ip, maxvalue);
                break;
            }
            case 7: {
                this.adjustBrightness(this.imp, ip, bvalue);
                break;
            }
            case 8: {
                this.adjustContrast(this.imp, ip, cvalue);
            }
        }
        this.updatePlot();
        this.updateLabels(this.imp, ip);
        this.imp.updateAndDraw();
        if (this.RGBImage) {
            this.imp.unlock();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.done = true;
        PlexiAdjusterWindow plexiAdjusterWindow = this;
        synchronized (plexiAdjusterWindow) {
            this.notify();
        }
        this.thread = null;
        adjuster = null;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.instance = false;
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (WindowManager.getCurrentWindow() != null) {
            this.imp = WindowManager.getCurrentWindow().getImagePlus();
        }
        this.setup();
    }
}

