/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import java.awt.FileDialog;
import java.awt.Frame;

public class PlexiSaveDialog {
    private String dir;
    private String name;
    private String title;
    private String extension;

    public PlexiSaveDialog(String title, String defaultName, String extension) {
        this.title = title;
        this.extension = extension;
        defaultName = this.addExtension(defaultName, extension);
        this.save(title, null, defaultName);
    }

    String addExtension(String name, String extension) {
        if (name != null && extension != null) {
            int dotIndex = name.lastIndexOf(".");
            name = dotIndex >= 0 ? name.substring(0, dotIndex) + extension : name + extension;
        }
        return name;
    }

    void save(String title, String defaultDir, String defaultName) {
        Frame parent = new Frame();
        FileDialog fd = new FileDialog(parent, title, 1);
        if (defaultName != null) {
            fd.setFile(defaultName);
        }
        if (defaultDir != null) {
            fd.setDirectory(defaultDir);
        }
        fd.show();
        this.name = this.addExtension(fd.getFile(), this.extension);
        this.dir = fd.getDirectory();
        if (this.name == null) {
            System.out.println("File Name is null ");
        }
        fd.dispose();
        parent.dispose();
    }

    public String getDirectory() {
        return this.dir;
    }

    public String getFileName() {
        return this.name;
    }
}

