/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import org.nrg.plexiViewer.lite.gui.PlexiTextPanel;

public class PlexiTextWindow
extends Frame
implements ActionListener,
FocusListener {
    private PlexiTextPanel textPanel;

    public PlexiTextWindow(String title, String data, int width, int height) {
        this(title, "", data, width, height);
    }

    public PlexiTextWindow(String title, String headings, String data, int width, int height) {
        super(title);
        this.enableEvents(64L);
        this.textPanel = new PlexiTextPanel(title);
        this.textPanel.setTitle(title);
        this.add("Center", this.textPanel);
        this.textPanel.setColumnHeadings(headings);
        this.textPanel.append(data);
        this.addFocusListener(this);
        this.addMenuBar();
        this.setSize(width, height);
        this.show();
    }

    void addMenuBar() {
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        MenuItem m1 = new MenuItem("Save As...");
        m.add(m1);
        m.addActionListener(this);
        mb.add(m);
        this.setMenuBar(mb);
    }

    public void append(String text) {
        this.textPanel.append(text);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.textPanel.setFont(font);
    }

    public PlexiTextPanel getTextPanel() {
        return this.textPanel;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        this.textPanel.doCommand(cmd);
    }

    @Override
    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        int id = e.getID();
        if (id == 201) {
            this.close();
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
        this.textPanel.flush();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

