/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class ProgressBar
extends Canvas {
    private int canvasWidth;
    private int canvasHeight;
    private int x;
    private int y;
    private int width;
    private int height;
    private double percent;
    private long startTime;
    private int count;
    private boolean showBar;
    private boolean negativeProgress;
    private static boolean autoHide;
    private Color barColor = new Color(0, 102, 102);
    private Color fillColor = Color.white;
    private Color backgroundColor = Color.white;
    private Color frameBrighter = this.backgroundColor.brighter();
    private Color frameDarker = this.backgroundColor.darker();

    public ProgressBar(int canvasWidth, int canvasHeight) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.x = 3;
        this.y = 5;
        this.width = canvasWidth - 8;
        this.height = canvasHeight - 7;
        this.showBar = false;
        this.negativeProgress = false;
        this.count = 0;
        this.percent = 0.0;
    }

    void fill3DRect(Graphics g, int x, int y, int width, int height) {
        try {
            g.setColor(this.fillColor);
            g.fillRect(x + 1, y + 1, width - 2, height - 2);
            g.setColor(this.frameDarker);
            g.drawLine(x, y, x, y + height);
            g.drawLine(x + 1, y, x + width - 1, y);
            g.setColor(this.frameBrighter);
            g.drawLine(x + 1, y + height, x + width, y + height);
            g.drawLine(x + width, y, x + width, y + height - 1);
        }
        catch (NullPointerException ne) {
            // empty catch block
        }
    }

    public void show(int currentValue, int finalValue) {
        if (currentValue >= finalValue) {
            this.showBar = false;
        } else {
            this.percent = Math.min((double)(currentValue + 1) / (double)finalValue, 1.0);
            this.showBar = true;
        }
        this.update(this.getGraphics());
    }

    public void show(double percent) {
        long time2;
        ++this.count;
        if (this.count == 1) {
            this.startTime = System.currentTimeMillis();
            this.showBar = false;
        } else if (this.count == 2 && (time2 = System.currentTimeMillis()) - this.startTime >= 0L) {
            this.showBar = true;
        }
        this.negativeProgress = percent < this.percent;
        this.percent = percent;
        if (percent >= 1.0) {
            this.count = 0;
            percent = 0.0;
            this.showBar = false;
            this.update(this.getGraphics());
        } else if (this.showBar) {
            this.update(this.getGraphics());
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this.showBar) {
            this.fill3DRect(g, this.x - 1, this.y - 1, this.width + 1, this.height + 1);
            this.drawBar(g);
        } else if (g != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
    }

    void drawBar(Graphics g) {
        if (this.percent < 0.0) {
            this.percent = 0.0;
        }
        int barEnd = (int)((double)this.width * this.percent);
        if (this.negativeProgress) {
            g.setColor(this.fillColor);
            g.fillRect(barEnd + 2, this.y, this.width - barEnd, this.height);
        } else {
            g.setColor(this.barColor);
            g.fillRect(this.x, this.y, barEnd, this.height);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.canvasWidth, this.canvasHeight);
    }

    public void hideBar() {
        this.showBar = false;
    }
}

