/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import org.nrg.plexiViewer.lite.gui.DoubleBuffer;

public class StatusPanel
extends DoubleBuffer
implements Runnable {
    String status;
    Color bgColor;
    Font f = new Font("Dialog", 0, 10);
    int w;
    int h;
    boolean doUpdate = true;
    private Thread DotThread;
    private int length = 2;
    private int squareStartAt;
    private int currentSquareIndex;
    private int currX;
    private int currY;
    private int gap = 5;
    private int totalSquares = 4;
    private boolean doDraw = true;
    private Color cgColor;
    Dimension FrameDimension;
    boolean suspended;

    public StatusPanel(int width, int height) {
        this.w = width;
        this.h = height;
        this.setSize(width, height);
        this.bgColor = Color.white;
        this.setBackground(this.bgColor);
        this.status = "";
        this.currentSquareIndex = 0;
        this.cgColor = Color.black;
        this.suspended = false;
    }

    public void reset() {
        this.status = "";
        this.doUpdate = true;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.w, this.h);
    }

    public void setStatus(String msg) {
        if (this.doUpdate) {
            this.status = msg;
            this.start();
            this.update(this.getGraphics());
        }
    }

    public void stop() {
        this.status = "";
        this.doDraw = false;
        this.DotThread = null;
        this.doUpdate = false;
        this.update(this.getGraphics());
    }

    @Override
    public void run() {
        Thread myThread = Thread.currentThread();
        this.currY = this.getSize().height / 2 - this.length;
        while (this.DotThread == myThread && this.doDraw) {
            Graphics g = this.getGraphics();
            if (this.status != null && !this.status.equals("")) {
                if (g == null) continue;
                g.setFont(this.f);
                FontMetrics metrics = g.getFontMetrics();
                if (metrics == null) continue;
                this.squareStartAt = metrics.stringWidth(this.status) + 2;
                this.update(this.getGraphics());
                ++this.currentSquareIndex;
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                this.currentSquareIndex %= this.totalSquares;
                continue;
            }
            if (!this.status.equals("")) continue;
            this.update(this.getGraphics());
        }
    }

    public synchronized void start() {
        if (this.doUpdate && this.DotThread == null) {
            this.DotThread = new Thread(this);
            this.doDraw = true;
            this.DotThread.start();
        }
    }

    @Override
    public void paintBuffer(Graphics g) {
        if (!this.doUpdate || !this.doDraw || this.status.equals("")) {
            this.clearSquares();
        } else {
            g.setColor(this.cgColor);
            g.setFont(this.f);
            g.drawString(this.status, 0, this.getSize().height / 2);
            this.drawSquare(g);
        }
    }

    public void drawSquare(Graphics cg) {
        Color c = cg.getColor();
        for (int i = 0; i < this.currentSquareIndex; ++i) {
            int xCenter = this.squareStartAt + i * this.gap;
            cg.setColor(this.cgColor);
            cg.fillRect(xCenter, this.currY, this.length, this.length);
        }
        cg.setColor(c);
    }

    public void clearSquares() {
        Graphics cg = this.getGraphics();
        if (cg != null) {
            Color c = cg.getColor();
            cg.setColor(this.bgColor);
            for (int i = 0; i < this.currentSquareIndex; ++i) {
                int xCenter = this.squareStartAt + i * this.gap;
                cg.fillRect(xCenter, this.currY, this.length, this.length);
            }
            cg.setColor(c);
        }
    }

    public void drawSquare(Graphics cg, int xCenter, int yCenter, boolean fill) {
        if (fill) {
            cg.fillRect(xCenter, yCenter, this.length, this.length);
        } else {
            cg.drawRect(xCenter, yCenter, this.length, this.length);
        }
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        StatusPanel s = new StatusPanel(100, 200);
        s.setStatus("Mohana");
        f.add(s);
        f.show();
    }
}

