/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.image;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import org.nrg.plexiViewer.lite.image.MedianCube;

public class PlexiMedianCut {
    static final int MAXCOLORS = 256;
    static final int HSIZE = 32768;
    private int[] hist;
    private int[] histPtr;
    private MedianCube[] cubeList;
    private int[] pixels32;
    private int width;
    private int height;
    private IndexColorModel cm;

    public PlexiMedianCut(int[] pixels, int width, int height) {
        this.pixels32 = pixels;
        this.width = width;
        this.height = height;
        this.hist = new int[32768];
        for (int i = 0; i < width * height; ++i) {
            int color16;
            int n = color16 = this.rgb(this.pixels32[i]);
            this.hist[n] = this.hist[n] + 1;
        }
    }

    int getColorCount() {
        int count = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= 0) continue;
            ++count;
        }
        return count;
    }

    Color getModalColor() {
        int max = 0;
        int c = 0;
        for (int i = 0; i < 32768; ++i) {
            if (this.hist[i] <= max) continue;
            max = this.hist[i];
            c = i;
        }
        return new Color(this.red(c), this.green(c), this.blue(c));
    }

    private final int rgb(int c) {
        int r = (c & 0xF80000) >> 19;
        int g = (c & 0xF800) >> 6;
        int b = (c & 0xF8) << 7;
        return b | g | r;
    }

    private final int red(int x) {
        return (x & 0x1F) << 3;
    }

    private final int green(int x) {
        return x >> 2 & 0xF8;
    }

    private final int blue(int x) {
        return x >> 7 & 0xF8;
    }

    public Image convert(int maxcubes) {
        int i;
        int longdim = 0;
        this.cubeList = new MedianCube[256];
        this.histPtr = new int[32768];
        int ncubes = 0;
        MedianCube cube = new MedianCube();
        int color = 0;
        for (i = 0; i <= Short.MAX_VALUE; ++i) {
            if (this.hist[i] == 0) continue;
            this.histPtr[color++] = i;
            cube.count += this.hist[i];
        }
        cube.lower = 0;
        cube.upper = color - 1;
        cube.level = 0;
        this.Shrink(cube);
        this.cubeList[ncubes++] = cube;
        while (ncubes < maxcubes) {
            int level = 255;
            int splitpos = -1;
            for (int k = 0; k <= ncubes - 1; ++k) {
                if (this.cubeList[k].lower == this.cubeList[k].upper || this.cubeList[k].level >= level) continue;
                level = this.cubeList[k].level;
                splitpos = k;
            }
            if (splitpos == -1) break;
            cube = this.cubeList[splitpos];
            int lr = cube.rmax - cube.rmin;
            int lg = cube.gmax - cube.gmin;
            int lb = cube.bmax - cube.bmin;
            if (lr >= lg && lr >= lb) {
                longdim = 0;
            }
            if (lg >= lr && lg >= lb) {
                longdim = 1;
            }
            if (lb >= lr && lb >= lg) {
                longdim = 2;
            }
            this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
            this.quickSort(this.histPtr, cube.lower, cube.upper);
            this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
            int count = 0;
            for (i = cube.lower; i <= cube.upper - 1 && count < cube.count / 2; count += this.hist[color], ++i) {
                color = this.histPtr[i];
            }
            int median = i;
            MedianCube cubeA = new MedianCube();
            cubeA.lower = cube.lower;
            cubeA.upper = median - 1;
            cubeA.count = count;
            cubeA.level = cube.level + 1;
            this.Shrink(cubeA);
            this.cubeList[splitpos] = cubeA;
            MedianCube cubeB = new MedianCube();
            cubeB.lower = median;
            cubeB.upper = cube.upper;
            cubeB.count = cube.count - count;
            cubeB.level = cube.level + 1;
            this.Shrink(cubeB);
            this.cubeList[ncubes++] = cubeB;
        }
        this.makeInverseMap(this.hist, ncubes);
        return this.makeImage();
    }

    void Shrink(MedianCube cube) {
        int rmin = 255;
        int rmax = 0;
        int gmin = 255;
        int gmax = 0;
        int bmin = 255;
        int bmax = 0;
        for (int i = cube.lower; i <= cube.upper; ++i) {
            int color = this.histPtr[i];
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            if (r > rmax) {
                rmax = r;
            }
            if (r < rmin) {
                rmin = r;
            }
            if (g > gmax) {
                gmax = g;
            }
            if (g < gmin) {
                gmin = g;
            }
            if (b > bmax) {
                bmax = b;
            }
            if (b >= bmin) continue;
            bmin = b;
        }
        cube.rmin = rmin;
        cube.rmax = rmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
        cube.gmin = gmin;
        cube.gmax = gmax;
    }

    void makeInverseMap(int[] hist, int ncubes) {
        int color;
        int i;
        MedianCube cube;
        int k;
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        for (k = 0; k <= ncubes - 1; ++k) {
            int b;
            int g;
            int r;
            cube = this.cubeList[k];
            float bsum = 0.0f;
            float gsum = 0.0f;
            float rsum = 0.0f;
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.histPtr[i];
                r = this.red(color);
                rsum += (float)(r * hist[color]);
                g = this.green(color);
                gsum += (float)(g * hist[color]);
                b = this.blue(color);
                bsum += (float)(b * hist[color]);
            }
            r = (int)(rsum / (float)cube.count);
            g = (int)(gsum / (float)cube.count);
            b = (int)(bsum / (float)cube.count);
            if (r == 248 && g == 248 && b == 248) {
                b = 255;
                g = 255;
                r = 255;
            }
            rLUT[k] = (byte)(r & 0xFF);
            gLUT[k] = (byte)(g & 0xFF);
            bLUT[k] = (byte)(b & 0xFF);
        }
        this.cm = new IndexColorModel(8, ncubes, rLUT, gLUT, bLUT);
        for (k = 0; k <= ncubes - 1; ++k) {
            cube = this.cubeList[k];
            for (i = cube.lower; i <= cube.upper; ++i) {
                color = this.histPtr[i];
                hist[color] = k;
            }
        }
    }

    void makeInverseTable(int[] hist, int ncubes, byte[] rLUT, byte[] gLUT, byte[] bLUT) {
        int index = 0;
        for (int i = 0; i < 32768; ++i) {
            if (hist[i] <= 0) continue;
            int color = i;
            int r = this.red(color);
            int g = this.green(color);
            int b = this.blue(color);
            int dmin = 999999999;
            for (int j = 0; j < ncubes; ++j) {
                int dr = (rLUT[j] & 0xFF) - r;
                int dg = (gLUT[j] & 0xFF) - g;
                int db = (bLUT[j] & 0xFF) - b;
                int d = dr * dr + dg * dg + db * db;
                if (d == 0) {
                    index = j;
                    break;
                }
                if (d >= dmin) continue;
                dmin = d;
                index = j;
            }
            hist[color] = index;
        }
    }

    void reorderColors(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    a[i] = r << 10 | c >> 5;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 5 & 0x1F;
                    int b = c >> 10;
                    a[i] = g << 10 | b << 5 | r;
                }
                break;
            }
        }
    }

    void restoreColorOrder(int[] a, int lo, int hi, int longDim) {
        switch (longDim) {
            case 0: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c >> 10;
                    a[i] = (c & 0x3FF) << 5 | r;
                }
                break;
            }
            case 1: {
                for (int i = lo; i <= hi; ++i) {
                    int c = a[i];
                    int r = c & 0x1F;
                    int g = c >> 10;
                    int b = c >> 5 & 0x1F;
                    a[i] = b << 10 | g << 5 | r;
                }
                break;
            }
        }
    }

    void quickSort(int[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            int mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo] < mid) {
                    ++lo;
                }
                while (hi > lo0 && a[hi] > mid) {
                    --hi;
                }
                if (lo > hi) continue;
                int t = a[lo];
                a[lo] = a[hi];
                a[hi] = t;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                this.quickSort(a, lo0, hi);
            }
            if (lo < hi0) {
                this.quickSort(a, lo, hi0);
            }
        }
    }

    Image makeImage() {
        byte[] pixels8 = new byte[this.width * this.height];
        for (int i = 0; i < this.width * this.height; ++i) {
            int color16 = this.rgb(this.pixels32[i]);
            pixels8[i] = (byte)(this.hist[color16] & 0xFF);
        }
        Image img8 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (ColorModel)this.cm, pixels8, 0, this.width));
        return img8;
    }
}

