/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.io;

import ij.ImagePlus;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.nrg.plexiViewer.ij.GifEncoder;
import org.nrg.plexiViewer.lite.gui.PlexiSaveDialog;

public class PlexiFileSaver {
    private static String defaultDirectory = null;
    private String name;
    private String directory;
    private Image image;

    public PlexiFileSaver(Image img) {
        this.image = img;
    }

    public PlexiFileSaver() {
    }

    public void setImageFileName(String n) {
        this.name = n;
    }

    String getPath(String type, String extension) {
        PlexiSaveDialog sd = new PlexiSaveDialog("Save as " + type, this.name, extension);
        this.name = sd.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = sd.getDirectory();
        String path = this.directory + this.name;
        return path;
    }

    public boolean saveImageAsGif() {
        String path = this.getPath("GIF", ".gif");
        if (path == null) {
            return false;
        }
        if (this.image == null) {
            return false;
        }
        return this.saveImageAsGif(path);
    }

    public void saveAsJpeg(ImagePlus imp, String path, int quality) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        try {
            FileOutputStream f = new FileOutputStream(path);
            Graphics2D g = bi.createGraphics();
            g.drawImage(imp.getImage(), 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)bi, "jpg", f);
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean saveAsGif() {
        String path = this.getPath("GIF", ".gif");
        if (path == null) {
            return false;
        }
        return this.saveImageAsGif(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveImageAsGif(String path) {
        OutputStream output = null;
        boolean rtn = false;
        try {
            output = new BufferedOutputStream(new FileOutputStream(path));
            GifEncoder gifE = new GifEncoder(this.image);
            gifE.write(output);
            rtn = true;
        }
        catch (IOException e) {
            this.showErrorMessage(e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return rtn;
    }

    public boolean writeImageAsGif(String path, OutputStream output) {
        try {
            GifEncoder gifE = new GifEncoder(this.image);
            gifE.write(output);
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    void showErrorMessage(IOException e) {
        System.out.println("An error occured writing the file.\n \n" + e);
    }
}

