/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.tunneler;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;

public class ImageDimLoader {
    private URL dataURL;
    UserSelection options;
    private String host;
    private URLConnection servletConnection;
    private boolean windowShowing;
    boolean error = false;
    PlexiImageFile pf;
    MontageDisplay m;

    public ImageDimLoader(UserSelection u, String host) {
        this.options = u;
        this.host = host;
    }

    private void openConnection() {
        String suffix = HTTPDetails.getSuffix("ImageLoaderServlet");
        try {
            this.dataURL = new URL(HTTPDetails.getProtocol(), HTTPDetails.getHost(), HTTPDetails.getPort(), suffix);
            this.servletConnection = this.dataURL.openConnection();
            this.servletConnection.setDoInput(true);
            this.servletConnection.setDoOutput(true);
            this.servletConnection.setUseCaches(false);
            this.servletConnection.setDefaultUseCaches(false);
            this.servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(this.servletConnection.getOutputStream());
            outStreamToServlet.writeObject(this.options);
            outStreamToServlet.flush();
            outStreamToServlet.close();
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void load() {
        try {
            this.getImageFileName();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void getImageFileName() throws IOException {
        this.openConnection();
        InputStream is = this.servletConnection.getInputStream();
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            this.m = (MontageDisplay)in.readObject();
            this.pf = (PlexiImageFile)in.readObject();
            if (this.pf == null) {
                this.error = true;
            }
            this.options.setFile(this.pf);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = true;
        }
        in.close();
        is.close();
    }

    public boolean isError() {
        return this.error;
    }

    public UserSelection getUserSelection() {
        return this.options;
    }

    public void setError(boolean b) {
        this.error = b;
    }

    public MontageDisplay getMontageDisplay() {
        return this.m;
    }

    public PlexiImageFile getPlexiImageFile() {
        return this.pf;
    }
}

