/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.tunneler;

import ij.ImagePlus;
import ij.ImageStack;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.ui.LoadStatus;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.utils.LoadErrorDialog;

public class ImageVecTunneler
implements Runnable {
    private boolean success = false;
    private boolean isDone = false;
    private URL dataURL;
    private String host;
    PlexiImageViewerI image;
    Vector imageVector;
    private URLConnection servletConnection;
    private int index;
    private UserSelection opt;

    public ImageVecTunneler(PlexiImageViewerI image, String host) {
        this.image = image;
        this.host = host;
    }

    private void openConnection(UserSelection opt) {
        String suffix = HTTPDetails.getSuffix("ImageDistributorServlet");
        try {
            this.dataURL = HTTPDetails.getURL(this.host, suffix);
            this.servletConnection = this.dataURL.openConnection();
            this.servletConnection.setDoInput(true);
            this.servletConnection.setDoOutput(true);
            this.servletConnection.setUseCaches(false);
            this.servletConnection.setDefaultUseCaches(false);
            this.servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(this.servletConnection.getOutputStream());
            outStreamToServlet.writeObject(opt);
            outStreamToServlet.flush();
            outStreamToServlet.close();
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
            this.isDone = true;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.isDone = true;
        }
    }

    public void load(UserSelection opt, int loc) {
        this.index = loc;
        this.opt = opt;
        Thread queryRetriever = new Thread(this);
        queryRetriever.start();
    }

    @Override
    public void run() {
        try {
            this.retrieveImage();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public boolean isDone() {
        return this.isDone;
    }

    public boolean isSuccess() {
        return this.success;
    }

    private void retrieveImage() throws IOException {
        this.openConnection(this.opt);
        InputStream is = this.servletConnection.getInputStream();
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            this.image.setMessage("Loading image:", "Receiving data...");
            LoadStatus status = (LoadStatus)in.readObject();
            if (!status.isSuccess()) {
                this.image.setMessage("Loading image:", "Error");
                PlexiImageFile pf = new PlexiImageFile();
                pf.setDimX(200);
                pf.setDimY(200);
                pf.setDimZ(0);
                this.image.setWindowDimensions(pf);
                LoadErrorDialog led = new LoadErrorDialog((Frame)this.image.getImagePlus().getWindow(), status.getMessage(), false);
                led.show();
                return;
            }
            int nSlices = status.getCount();
            int width = status.getDimensions().width;
            int height = status.getDimensions().height;
            if (this.image.getWindowDimensions().width == -1 || this.image.getWindowDimensions().height == -1) {
                this.image.setWindowDimensions(width, height, nSlices);
            }
            this.image.setMessage("Loading image:", "Connected to server...");
            ImageStack stack = new ImageStack(width, height);
            MontageDisplay display = (MontageDisplay)in.readObject();
            if (this.image.getLayout() == null) {
                this.image.setMontageDisplay(display);
            }
            for (int i = 0; i < nSlices; ++i) {
                Object pixels = in.readObject();
                stack.addSlice("", pixels);
            }
            this.image.setImage(this.index, new ImagePlus("", stack));
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        this.image.setMessage("Loading image:", "Complete");
        in.close();
        is.close();
    }
}

