/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.tunneler;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Frame;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.utils.LoadErrorDialog;

public class MontageImageLoader {
    private URL dataURL;
    PlexiImageViewerI image;
    private String host;
    private URLConnection servletConnection;
    private boolean windowShowing;
    Boolean getImage;
    PlexiImageFile pf;
    MontageDisplay m;
    boolean error;

    public MontageImageLoader(PlexiImageViewerI image, boolean getImage) {
        this.image = image;
        this.host = HTTPDetails.host;
        this.getImage = new Boolean(getImage);
    }

    public MontageImageLoader(PlexiImageViewerI image) {
        this.image = image;
        this.host = HTTPDetails.host;
        this.getImage = new Boolean(true);
    }

    private void openConnection() {
        String suffix = HTTPDetails.getSuffix("MontageImageLoaderServlet");
        try {
            this.dataURL = new URL(HTTPDetails.getProtocol(), HTTPDetails.getHost(), HTTPDetails.getPort(), suffix);
            this.servletConnection = this.dataURL.openConnection();
            this.servletConnection.setDoInput(true);
            this.servletConnection.setDoOutput(true);
            this.servletConnection.setUseCaches(false);
            this.servletConnection.setDefaultUseCaches(false);
            this.servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(this.servletConnection.getOutputStream());
            outStreamToServlet.writeObject(this.image.getUserSelection());
            outStreamToServlet.flush();
            outStreamToServlet.writeObject(this.getImage);
            outStreamToServlet.close();
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void load() {
        try {
            this.getImageFileName();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void getImageFileName() throws IOException {
        this.openConnection();
        InputStream is = this.servletConnection.getInputStream();
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            this.image.setMessage("Fetching Image Dimensions", "Please wait");
            this.m = (MontageDisplay)in.readObject();
            this.pf = (PlexiImageFile)in.readObject();
            if (this.pf == null) {
                Vector<String> msg = new Vector<String>();
                msg.add("Image not available");
                LoadErrorDialog led = new LoadErrorDialog((Frame)this.image.getImagePlus().getWindow(), msg, false);
                led.show();
            }
            this.image.setMontageDisplay(this.m);
            this.image.setWindowDimensions(this.pf);
            System.out.println("Montage Loader:: " + this.pf.getDimX() + " " + this.pf.getDimY() + " " + this.pf.getDimZ());
            if (this.getImage.booleanValue()) {
                ImageStack stack = new ImageStack(this.pf.getDimX(), this.pf.getDimY());
                ImagePlus mrip = this.image.getImagePlus();
                for (int i = 0; i < this.pf.getDimZ(); ++i) {
                    Object pixels = in.readObject();
                    stack.addSlice("", pixels);
                    if (i == 0) {
                        mrip.setStack("", stack);
                    }
                    if (this.image == null) continue;
                    this.image.setMessage("Loading image:", " ");
                }
                ImageProcessor ip = mrip.getProcessor();
                double min = ip.getMin();
                double max = ip.getMax();
                if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
                    ip.resetMinAndMax();
                }
                ip.setMinAndMax(min, max);
                mrip.getProcessor().resetMinAndMax();
                mrip.updateAndDraw();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Vector<String> msg = new Vector<String>();
            msg.add("Error! Please contact nrgtech@npg.wust.edu");
            LoadErrorDialog led = new LoadErrorDialog((Frame)this.image.getImagePlus().getWindow(), msg, false);
            led.show();
        }
        in.close();
        is.close();
    }
}

