/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.tunneler;

import ij.ImageStack;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.ui.LoadStatus;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;

public class NoMsgImageTunneler
implements Runnable {
    private URL dataURL;
    private String host;
    private URLConnection servletConnection;
    private boolean windowShowing;
    Thread queryRetriever;
    PlexiImageViewerI image;
    UserSelection userSelection;
    int index;

    public NoMsgImageTunneler(PlexiImageViewerI i) {
        this.image = i;
        this.host = HTTPDetails.getHost();
        this.windowShowing = false;
        this.userSelection = null;
    }

    private void openConnection() {
        String suffix = HTTPDetails.getSuffix("ImageDistributorServlet");
        try {
            this.dataURL = new URL(HTTPDetails.getProtocol(), HTTPDetails.getHost(), HTTPDetails.getPort(), suffix);
            this.servletConnection = this.dataURL.openConnection();
            this.servletConnection.setDoInput(true);
            this.servletConnection.setDoOutput(true);
            this.servletConnection.setUseCaches(false);
            this.servletConnection.setDefaultUseCaches(false);
            this.servletConnection.setRequestProperty("Content-Type", "application/octet-stream");
            ObjectOutputStream outStreamToServlet = new ObjectOutputStream(this.servletConnection.getOutputStream());
            outStreamToServlet.writeObject(this.userSelection);
            outStreamToServlet.flush();
            outStreamToServlet.close();
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void load(UserSelection u, int i) {
        this.index = i;
        this.userSelection = u;
        this.queryRetriever = new Thread((Runnable)this, "NoMsgImageTunneler");
        this.queryRetriever.start();
    }

    @Override
    public void run() {
        try {
            this.retrieveImage();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (OutOfMemoryError ome) {
            this.image.handleOutOfMemoryError();
        }
    }

    private void retrieveImage() throws IOException {
        this.openConnection();
        InputStream is = this.servletConnection.getInputStream();
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            LoadStatus status = (LoadStatus)in.readObject();
            if (!status.isSuccess()) {
                PlexiImageFile pf = new PlexiImageFile();
                pf.setDimX(200);
                pf.setDimY(200);
                pf.setDimZ(0);
                return;
            }
            int nSlices = status.getCount();
            int width = status.getDimensions().width;
            int height = status.getDimensions().height;
            ImageStack stack = new ImageStack(width, height);
            MontageDisplay display = (MontageDisplay)in.readObject();
            for (int i = 0; i < nSlices; ++i) {
                Object pixels = in.readObject();
                stack.addSlice("", pixels);
            }
            this.image.setImage(this.index, stack);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        catch (OutOfMemoryError ome) {
            this.image.handleOutOfMemoryError();
        }
        in.close();
        is.close();
    }
}

