/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.ui;

import ij.IJ;
import ij.ImageJ;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.nrg.plexiViewer.lite.UserInterfaceContents;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.gui.PlexiMessagePanel;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.ui.ChoiceWithObjects;
import org.nrg.plexiViewer.lite.ui.GenericIdentifier;
import org.nrg.plexiViewer.lite.utils.BrowserVersionInfo;
import org.nrg.plexiViewer.lite.utils.PlexiSubscriberClientProxy;
import org.nrg.xdat.bean.XnatAbstractresourceBean;

public class PlexiControlPanel
extends Panel
implements ItemListener {
    UserInterfaceContents contents;
    PlexiManager plexiManager;
    boolean chooseScanNo;
    private String startDisplayWith;
    private String startDataWith;
    int count = 0;
    long totalMemory;
    long freeMemory;
    Color background = Color.white;
    Color farbackground = Color.white;
    Color foreground = Color.black;
    private Panel optionsPanel;
    private PlexiMessagePanel msgPanel;
    private Panel uiPanel;
    private Label scanNoORFilelabel;
    private Choice typeChoice;
    private ChoiceWithObjects fileChoice;
    private Choice viewChoice;
    private Choice dataChoice;
    private Choice displayChoice;
    private Checkbox radCheckbox;
    private Button goButton;
    private boolean scanNoDisplayStatus = false;
    private boolean hasUIPanel = false;
    private boolean disableAll = false;

    public PlexiControlPanel(UserInterfaceContents c, AppletContext appletContext) {
        this.contents = c;
        this.chooseScanNo = false;
        this.startDisplayWith = null;
        this.plexiManager = new PlexiManager(appletContext);
        this.initComponents();
    }

    public void initComponents() {
        try {
            ImageJ ij = IJ.getInstance();
            if (ij == null || !ij.quitting()) {
                new ImageJ(PlexiManager.getApplet(), 1).exitWhenQuitting(false);
                ij = IJ.getInstance();
                ij.setVisible(false);
            }
        }
        catch (Exception e) {
            System.out.println("ImageJ Init threw and exception ");
        }
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(Color.white);
        this.optionsPanel = new Panel();
        this.typeChoice = new Choice();
        this.viewChoice = new Choice();
        this.fileChoice = new ChoiceWithObjects();
        this.dataChoice = new Choice();
        this.dataChoice.addItemListener(this);
        this.displayChoice = new Choice();
        this.radCheckbox = new Checkbox();
        this.goButton = new Button();
        this.optionsPanel.setLayout(new GridBagLayout());
        this.optionsPanel.setFont(new Font("Dialog", 0, 11));
        this.optionsPanel.setBackground(this.background);
        this.optionsPanel.setForeground(this.foreground);
        Label label = new Label();
        label.setFont(new Font("Dialog", 0, 11));
        label.setBackground(this.background);
        label.setForeground(this.foreground);
        label.setText("Data  ");
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        this.optionsPanel.add((Component)label, gbc2);
        this.dataChoice.setFont(new Font("Dialog", 0, 11));
        this.dataChoice.setBackground(this.background);
        this.dataChoice.setForeground(this.foreground);
        Vector dataChoicesVector = this.contents.getValuesForData();
        if (dataChoicesVector.size() != 0) {
            Enumeration e = dataChoicesVector.elements();
            while (e.hasMoreElements()) {
                this.dataChoice.add((String)e.nextElement());
            }
        } else {
            this.dataChoice.add("No images");
            this.disableAll = true;
        }
        GridBagConstraints dataGbc = new GridBagConstraints();
        dataGbc.gridx = 1;
        dataGbc.gridy = 0;
        dataGbc.anchor = 17;
        dataGbc.insets = new Insets(0, 0, 0, 0);
        dataGbc.weightx = 0.9;
        dataGbc.weighty = 0.9;
        dataGbc.fill = 2;
        this.dataChoice.addItemListener(this);
        this.optionsPanel.add((Component)this.dataChoice, dataGbc);
        label = new Label();
        label.setFont(new Font("Dialog", 0, 11));
        label.setBackground(this.background);
        label.setForeground(this.foreground);
        label.setText("Type");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 1;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        this.optionsPanel.add((Component)label, gbc2);
        this.typeChoice.setFont(new Font("Dialog", 0, 11));
        this.typeChoice.setBackground(this.background);
        this.typeChoice.setForeground(this.foreground);
        this.typeChoice.addItemListener(this);
        GridBagConstraints typeGbc = new GridBagConstraints();
        typeGbc.gridx = 1;
        typeGbc.gridy = 1;
        typeGbc.anchor = 17;
        typeGbc.insets = new Insets(0, 0, 0, 0);
        typeGbc.weightx = 0.9;
        typeGbc.weighty = 0.9;
        typeGbc.fill = 2;
        this.optionsPanel.add((Component)this.typeChoice, typeGbc);
        label = new Label();
        this.scanNoORFilelabel = new Label();
        this.scanNoORFilelabel.setFont(new Font("Dialog", 0, 11));
        this.scanNoORFilelabel.setBackground(this.background);
        this.scanNoORFilelabel.setForeground(this.foreground);
        this.scanNoORFilelabel.setText("Image");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 2;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        this.optionsPanel.add((Component)this.scanNoORFilelabel, gbc2);
        this.fileChoice.setFont(new Font("Dialog", 0, 11));
        this.fileChoice.setBackground(this.background);
        this.fileChoice.setForeground(this.foreground);
        GridBagConstraints scanNoGbc = new GridBagConstraints();
        scanNoGbc.gridx = 1;
        scanNoGbc.gridy = 2;
        scanNoGbc.anchor = 17;
        scanNoGbc.insets = new Insets(0, 0, 0, 0);
        scanNoGbc.weightx = 0.9;
        scanNoGbc.weighty = 0.9;
        scanNoGbc.fill = 2;
        this.fileChoice.addItemListener(this);
        this.optionsPanel.add((Component)this.fileChoice, scanNoGbc);
        label = new Label();
        label.setFont(new Font("Dialog", 0, 11));
        label.setBackground(this.background);
        label.setForeground(this.foreground);
        label.setText("View  ");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 4;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        this.optionsPanel.add((Component)label, gbc2);
        this.viewChoice.setFont(new Font("Dialog", 0, 11));
        this.viewChoice.setBackground(this.background);
        this.viewChoice.setForeground(this.foreground);
        GridBagConstraints viewGbc = new GridBagConstraints();
        viewGbc.gridx = 1;
        viewGbc.gridy = 4;
        viewGbc.anchor = 17;
        viewGbc.insets = new Insets(0, 0, 0, 0);
        viewGbc.weightx = 0.9;
        viewGbc.weighty = 0.9;
        viewGbc.fill = 2;
        this.viewChoice.addItemListener(this);
        this.optionsPanel.add((Component)this.viewChoice, viewGbc);
        label = new Label();
        label.setFont(new Font("Dialog", 0, 11));
        label.setBackground(this.background);
        label.setForeground(this.foreground);
        label.setText("Display");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 5;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        this.optionsPanel.add((Component)label, gbc2);
        this.displayChoice.setFont(new Font("Dialog", 0, 11));
        this.displayChoice.setBackground(this.background);
        this.displayChoice.setForeground(this.foreground);
        this.displayChoice.add("Stack          ");
        this.displayChoice.add("Montage        ");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 1;
        gbc2.gridy = 5;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        gbc2.fill = 2;
        this.displayChoice.addItemListener(this);
        this.optionsPanel.add((Component)this.displayChoice, gbc2);
        this.radCheckbox.setState(false);
        this.radCheckbox.setBackground(this.background);
        this.radCheckbox.setFont(new Font("Dialog", 0, 11));
        this.radCheckbox.setForeground(this.foreground);
        this.radCheckbox.setLabel("radiologic");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 6;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        this.optionsPanel.add((Component)this.radCheckbox, gbc2);
        this.goButton.setFont(new Font("Dialog", 0, 11));
        this.goButton.setLabel("     GO     ");
        this.goButton.setForeground(this.foreground);
        this.goButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PlexiControlPanel.this.goButtonClicked(evt);
            }
        });
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 1;
        gbc2.gridy = 6;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(3, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        gbc2.fill = 2;
        this.optionsPanel.add((Component)this.goButton, gbc2);
        this.msgPanel = new PlexiMessagePanel(210, 30);
        this.msgPanel.setMessage("");
        gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 7;
        gbc2.anchor = 17;
        gbc2.insets = new Insets(0, 0, 0, 0);
        gbc2.weightx = 0.9;
        gbc2.weighty = 0.9;
        gbc2.gridwidth = 2;
        gbc2.fill = 2;
        this.optionsPanel.add((Component)this.msgPanel, gbc2);
        this.add((Component)this.optionsPanel, "North");
        this.initChoices();
    }

    void initFiles(Vector files) {
        this.fileChoice.removeAll();
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            this.fileChoice.add((GenericIdentifier)e.nextElement());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.msgPanel.setMessage("");
        this.disableImageView(false);
        if (e.getSource() == this.typeChoice) {
            if (e.getStateChange() == 1) {
                this.setFileChoice();
                this.fileChoice.setEnabled(true);
            }
        } else if (e.getSource() == this.dataChoice) {
            if (e.getStateChange() == 1) {
                String item = (String)e.getItem();
                item = item.trim();
                this.setTypeChoice(item);
                this.setFileChoice();
            }
        } else if (e.getSource() == this.fileChoice && e.getStateChange() == 1) {
            GenericIdentifier item = (GenericIdentifier)this.fileChoice.getSelectedObject();
            this.setOrientationChoice((XnatAbstractresourceBean)item.getValue());
            this.viewChoice.setEnabled(true);
        }
    }

    private void setVisibility() {
    }

    private void setFileChoice() {
        String typeStr = this.typeChoice.getSelectedItem();
        String dataStr = this.dataChoice.getSelectedItem();
        Vector files = this.contents.getFileList(dataStr, typeStr);
        if (files.size() > 0) {
            this.initFiles(files);
            GenericIdentifier item = (GenericIdentifier)this.fileChoice.getSelectedObject();
            this.setOrientationChoice((XnatAbstractresourceBean)item.getValue());
        } else {
            this.fileChoice.removeAll();
            this.viewChoice.removeAll();
            this.fileChoice.add("No Images available");
            this.disableImageView(true);
        }
    }

    private void disableImageView(boolean notviewable) {
        this.goButton.setEnabled(!notviewable);
    }

    private void setOrientationChoice(XnatAbstractresourceBean file) {
        this.viewChoice.removeAll();
        Vector ori = this.contents.getOrientations(file);
        if (ori != null && ori.size() > 0) {
            for (int i = 0; i < ori.size(); ++i) {
                this.viewChoice.add((String)ori.elementAt(i));
            }
        }
        this.viewChoice.setEnabled(true);
    }

    private void goButtonClicked(MouseEvent evt) {
        BrowserVersionInfo bInfo = new BrowserVersionInfo();
        this.msgPanel.clear();
        long startTime = System.currentTimeMillis();
        Runtime.getRuntime().runFinalization();
        this.totalMemory = Runtime.getRuntime().totalMemory();
        Runtime.getRuntime().gc();
        this.freeMemory = Runtime.getRuntime().freeMemory();
        int freeMemPct = (int)((float)this.freeMemory / (float)this.totalMemory * 100.0f);
        System.out.println("Memory Free:: " + freeMemPct + "%");
        if (freeMemPct < 25) {
            this.msgPanel.setMessage("Low on Memory....Please close some image windows");
            System.out.println("Running low on memory......Please close some image windows");
            return;
        }
        Cursor c = this.getCursor();
        this.setCursor(new Cursor(3));
        int scanIndex = this.typeChoice.getSelectedIndex();
        int dataIndex = this.dataChoice.getSelectedIndex();
        String orientation = this.viewChoice.getSelectedItem().trim().toLowerCase();
        XnatAbstractresourceBean file = null;
        if ((GenericIdentifier)this.fileChoice.getSelectedObject() != null) {
            file = (XnatAbstractresourceBean)((GenericIdentifier)this.fileChoice.getSelectedObject()).getValue();
        }
        String display = this.displayChoice.getSelectedItem().trim();
        boolean radiologic = this.radCheckbox.getState();
        UserSelection uselected = new UserSelection();
        uselected.setDataType(this.dataChoice.getSelectedItem());
        uselected.setDisplay(display);
        uselected.setOrientation(orientation.toLowerCase());
        uselected.setRadiologic(radiologic);
        uselected.setSessionLabel(this.contents.getSessionLabel());
        uselected.setSessionId(this.contents.getSessionId());
        uselected.setProject(this.contents.getProject());
        uselected.setWindowTitle(this.contents.getSessionLabel() + ":" + this.typeChoice.getSelectedItem() + ":" + this.dataChoice.getSelectedItem() + ":" + this.fileChoice.getSelectedItem() + ":" + orientation.substring(0, 1).toUpperCase() + orientation.substring(1));
        uselected.setImageViewerClass(this.contents.getViewerClassName());
        uselected.setXnatFile(file);
        PlexiSubscriberClientProxy statusProxy = new PlexiSubscriberClientProxy(this.msgPanel, uselected.toString());
        statusProxy.start();
        int found = this.plexiManager.show(this.msgPanel, (UserSelection)uselected.clone());
        this.setCursor(c);
        statusProxy.finish();
        if (found == 1) {
            this.msgPanel.setMessage("");
        }
        this.msgPanel.resetMessages();
        long endTime = System.currentTimeMillis();
        System.out.println("Total Time " + (endTime - startTime) / 1000L + " s");
    }

    public void initChoices() {
        String item = "";
        if (this.disableAll) {
            this.setVisibility();
        } else if (this.dataChoice.getItemCount() != 0) {
            item = this.dataChoice.getItem(0);
            item = item.trim();
            this.setTypeChoice(item);
            this.setFileChoice();
        }
    }

    private void setTypeChoice(String dataChoiceStr) {
        this.typeChoice.removeAll();
        Vector values = this.contents.getTypeValues(dataChoiceStr);
        Enumeration e = values.elements();
        while (e.hasMoreElements()) {
            this.typeChoice.add((String)e.nextElement());
        }
    }

    public String getStartDisplayWith() {
        return this.startDisplayWith;
    }

    public void setStartDisplayWith(String string) {
        this.startDisplayWith = string;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 220);
    }
}

