/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.ui;

import ij.IJ;
import ij.ImageJ;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.CheckboxMenuItem;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.PixelGrabber;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.gui.PlexiAdjusterWindow;
import org.nrg.plexiViewer.lite.gui.PlexiFileInfo;
import org.nrg.plexiViewer.lite.gui.PlexiPrinter;
import org.nrg.plexiViewer.lite.image.PlexiMedianCut;
import org.nrg.plexiViewer.lite.io.PlexiFileSaver;
import org.nrg.plexiViewer.lite.manager.PlexiManager;

public class PlexiMenuBar {
    private ImageWindow parentListener;
    private UserSelection uselection;
    private String host;
    private boolean showCrossHair;
    private CheckboxMenuItem showCrossHairMI;
    private CheckboxMenuItem rulerMI;
    private CheckboxMenuItem markRightMI;
    private CheckboxMenuItem enablePlexiInteractiveKeys;
    private MenuBar mb;
    ItemListener repaintCanvasItemListener;
    ItemListener enablePlexiInteractiveKeysItemListener;
    ActionListener infoActionListener;
    ActionListener adjustBCActionListener;
    ActionListener printActionListener;
    ActionListener saveActionListener;
    ActionListener ijActionListener;
    private static boolean imageJShowing = false;

    public PlexiMenuBar(ImageWindow parent, String host, UserSelection u) {
        this.parentListener = parent;
        this.uselection = u;
        this.host = host;
        this.mb = new MenuBar();
        this.init();
    }

    public PlexiMenuBar(Frame f) {
    }

    public void clear() {
        Menu m = this.mb.getMenu(0);
        m.getItem(0).removeActionListener(this.infoActionListener);
        m.getItem(1).removeActionListener(this.printActionListener);
        m.getItem(2).removeActionListener(this.saveActionListener);
        m = this.mb.getMenu(1);
        m.getItem(0).removeActionListener(this.ijActionListener);
        m.getItem(1).removeActionListener(this.adjustBCActionListener);
    }

    public MenuBar getMenuBar() {
        return this.mb;
    }

    void init() {
        this.repaintCanvasItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (PlexiMenuBar.this.parentListener != null) {
                    PlexiMenuBar.this.parentListener.getCanvas().repaint();
                }
            }
        };
        this.enablePlexiInteractiveKeysItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                PlexiManager.controlKeys = !PlexiManager.controlKeys;
            }
        };
        this.infoActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PlexiMenuBar.this.parentListener != null) {
                    PlexiFileInfo info = new PlexiFileInfo(PlexiMenuBar.this.parentListener.getImagePlus(), PlexiMenuBar.this.host, PlexiMenuBar.this.uselection);
                    info.show();
                }
            }
        };
        this.adjustBCActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PlexiMenuBar.this.parentListener != null) {
                    PlexiAdjusterWindow.GetInstance().display();
                }
            }
        };
        this.ijActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!imageJShowing) {
                    ImageJ ij = IJ.getInstance();
                    if (ij == null || !ij.quitting()) {
                        new ImageJ(PlexiManager.getApplet(), 1).exitWhenQuitting(false);
                        imageJShowing = true;
                    } else {
                        ij.setVisible(true);
                        imageJShowing = true;
                    }
                } else {
                    ImageJ ij = IJ.getInstance();
                    if (ij != null) {
                        if (!ij.isShowing()) {
                            ij.setVisible(true);
                        }
                        ij.toFront();
                    }
                }
            }
        };
        this.printActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PlexiMenuBar.this.parentListener != null) {
                    Image fileImage = PlexiMenuBar.this.createImage(PlexiMenuBar.this.parentListener);
                    PlexiPrinter printer = new PlexiPrinter();
                    String title = PlexiMenuBar.this.parentListener.getImagePlus().getTitle();
                    if (PlexiMenuBar.this.uselection.getDisplay().equalsIgnoreCase("Stack")) {
                        title = title + ":Slice " + PlexiMenuBar.this.parentListener.getImagePlus().getCurrentSlice();
                    }
                    printer.print(fileImage, title);
                }
            }
        };
        this.saveActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PlexiMenuBar.this.parentListener != null) {
                    Image fileImage = PlexiMenuBar.this.createImage(PlexiMenuBar.this.parentListener);
                    int width = fileImage.getWidth(null);
                    int height = fileImage.getHeight(null);
                    PixelGrabber pg = new PixelGrabber(fileImage, 0, 0, width, height, false);
                    try {
                        pg.grabPixels();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    int[] pixels = (int[])pg.getPixels();
                    PlexiMedianCut mc = new PlexiMedianCut(pixels, width, height);
                    Image image8 = mc.convert(255);
                    PlexiFileSaver fs = new PlexiFileSaver(image8);
                    String fileName = PlexiMenuBar.this.parentListener.getImagePlus().getTitle();
                    int index = fileName.lastIndexOf(":");
                    fileName = fileName.substring(0, index + 2) + PlexiMenuBar.this.parentListener.getImagePlus().getCurrentSlice();
                    fileName = fileName.replace(':', '_');
                    fileName = fileName.replace(" ", "");
                    fs.setImageFileName(fileName);
                    fs.saveImageAsGif();
                    fileImage.flush();
                    fileImage = null;
                    mc = null;
                    System.gc();
                }
            }
        };
        Menu file = new Menu("File");
        MenuItem info = new MenuItem("Info", new MenuShortcut(73));
        info.addActionListener(this.infoActionListener);
        file.add(info);
        MenuItem print = new MenuItem("Print", new MenuShortcut(80));
        print.addActionListener(this.printActionListener);
        file.add(print);
        MenuItem snapShot = new MenuItem("SnapShot", new MenuShortcut(83));
        snapShot.addActionListener(this.saveActionListener);
        file.add(snapShot);
        Menu view = new Menu("View");
        MenuItem ij = new MenuItem("ImageJ", new MenuShortcut(73));
        ij.addActionListener(this.ijActionListener);
        view.add(ij);
        MenuItem bc = new MenuItem("Brightness/Contrast", new MenuShortcut(66));
        bc.addActionListener(this.adjustBCActionListener);
        view.add(bc);
        view.addSeparator();
        this.showCrossHairMI = new CheckboxMenuItem("CrossHair", true);
        this.showCrossHairMI.addItemListener(this.repaintCanvasItemListener);
        this.showCrossHairMI.setState(true);
        view.add(this.showCrossHairMI);
        this.rulerMI = new CheckboxMenuItem("Ruler", true);
        this.rulerMI.addItemListener(this.repaintCanvasItemListener);
        this.rulerMI.setState(true);
        view.add(this.rulerMI);
        this.markRightMI = new CheckboxMenuItem("R/L Marker", true);
        this.markRightMI.addItemListener(this.repaintCanvasItemListener);
        this.markRightMI.setState(true);
        view.add(this.markRightMI);
        this.enablePlexiInteractiveKeys = new CheckboxMenuItem("ImageJ controls Mouse mvmt", false);
        this.enablePlexiInteractiveKeys.addItemListener(this.enablePlexiInteractiveKeysItemListener);
        this.enablePlexiInteractiveKeys.setState(false);
        view.add(this.enablePlexiInteractiveKeys);
        this.mb.add(file);
        this.mb.add(view);
    }

    public Image createImage(ImageWindow win) {
        win.addNotify();
        ImageCanvas can = win.getCanvas();
        Rectangle srcRect = can.getSrcRect();
        int width = srcRect.width;
        int height = srcRect.height;
        Image fileImage = this.parentListener.createImage((int)((double)width * can.getMagnification()), (int)((double)height * can.getMagnification()));
        Graphics g = fileImage.getGraphics();
        can.paint(g);
        g.dispose();
        return fileImage;
    }

    public boolean showCrossHair() {
        return this.showCrossHairMI.getState();
    }

    public boolean showRuler() {
        return this.rulerMI.getState();
    }

    public boolean markRight() {
        return this.markRightMI.getState();
    }
}

