/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.utils;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.nrg.plexiViewer.lite.utils.IntHashtableEntry;

class IntHashtableEnumerator
implements Enumeration {
    boolean keys;
    int index;
    IntHashtableEntry[] table;
    IntHashtableEntry entry;

    IntHashtableEnumerator(IntHashtableEntry[] table, boolean keys) {
        this.table = table;
        this.keys = keys;
        this.index = table.length;
    }

    @Override
    public boolean hasMoreElements() {
        if (this.entry != null) {
            return true;
        }
        while (this.index-- > 0) {
            this.entry = this.table[this.index];
            if (this.entry == null) continue;
            return true;
        }
        return false;
    }

    public Object nextElement() {
        if (this.entry == null) {
            while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
            }
        }
        if (this.entry != null) {
            IntHashtableEntry e = this.entry;
            this.entry = e.next;
            return this.keys ? new Integer(e.key) : e.value;
        }
        throw new NoSuchElementException("IntHashtableEnumerator");
    }
}

