/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class StringUtils {
    private static DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
    private static int dfDigits = 2;

    public static String cleanUp(String input, String toFind, String toReplace) {
        int indexOfToFind;
        String rtn = input;
        while ((indexOfToFind = rtn.indexOf(toFind)) != -1) {
            rtn = indexOfToFind == 0 ? toReplace + rtn.substring(indexOfToFind + toFind.length(), rtn.length()) : rtn.substring(0, indexOfToFind) + toReplace + rtn.substring(indexOfToFind + toFind.length(), rtn.length());
            if (indexOfToFind != -1) continue;
        }
        return rtn;
    }

    public static String peelSpaces(String inStr) {
        String outStr = "";
        if (inStr == null) {
            return null;
        }
        inStr.trim();
        for (int i = 0; i < inStr.length(); ++i) {
            if (inStr.charAt(i) == ' ') continue;
            outStr = outStr + inStr.charAt(i);
        }
        return outStr;
    }

    public static String d2s(double n, int precision) {
        boolean negative;
        if (n == 3.4028234663852886E38) {
            return "3.4e38";
        }
        boolean bl = negative = n < 0.0;
        if (negative) {
            n = -n;
        }
        double whole = Math.round(n * Math.pow(10.0, precision));
        double rounded = whole / Math.pow(10.0, precision);
        if (negative) {
            rounded = -rounded;
        }
        if (precision != dfDigits) {
            switch (precision) {
                case 0: {
                    df.applyPattern("0");
                    dfDigits = 0;
                    break;
                }
                case 1: {
                    df.applyPattern("0.0");
                    dfDigits = 1;
                    break;
                }
                case 2: {
                    df.applyPattern("0.00");
                    dfDigits = 2;
                    break;
                }
                case 3: {
                    df.applyPattern("0.000");
                    dfDigits = 3;
                    break;
                }
                case 4: {
                    df.applyPattern("0.0000");
                    dfDigits = 4;
                    break;
                }
                case 5: {
                    df.applyPattern("0.00000");
                    dfDigits = 5;
                    break;
                }
                case 6: {
                    df.applyPattern("0.000000");
                    dfDigits = 6;
                    break;
                }
                case 7: {
                    df.applyPattern("0.0000000");
                    dfDigits = 7;
                    break;
                }
                case 8: {
                    df.applyPattern("0.00000000");
                    dfDigits = 8;
                }
            }
        }
        String s = df.format(rounded);
        return s;
    }
}

