/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MR;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.display.PlexiCoordinates;
import org.nrg.plexiViewer.lite.display.Point3d;
import org.nrg.plexiViewer.lite.gui.PlexiMessagePanel;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.tunneler.ImageDimLoader;
import org.nrg.plexiViewer.lite.tunneler.ImageTunneler;
import org.nrg.plexiViewer.lite.tunneler.MontageImageLoader;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.utils.StringUtils;
import org.nrg.plexiViewer.lite.viewer.MR.MRCanvas;
import org.nrg.plexiViewer.lite.viewer.MR.MRMontageWindow;
import org.nrg.plexiViewer.lite.viewer.MR.MRStackWindow;
import org.nrg.plexiViewer.lite.xml.Layout;

public class MRImage
implements KeyListener,
PlexiImageViewerI {
    private ImagePlus ip;
    private ImagePlus baseIp;
    private MRStackWindow stackWin;
    private MontageDisplay mDisplay;
    private MRMontageWindow montageWin;
    private int x;
    private int y;
    private int z;
    private float ipValue;
    private int winWidth;
    private int winHeight;
    private int slices;
    private int nColumns;
    private int nRows;
    private int scaleFactor;
    private boolean selfClose = false;
    private boolean rescaling = false;
    private UserSelection uselection;
    private PlexiCoordinates coords;
    private boolean isInit = false;
    private String pathToHiResFile;
    private PlexiMessagePanel msgPanel;

    public MRImage(UserSelection u) {
        this.uselection = u;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.winWidth = -1;
        this.winHeight = -1;
        this.scaleFactor = 1;
    }

    @Override
    public int open(PlexiMessagePanel msgPanel) {
        int rtn = 1;
        this.msgPanel = msgPanel;
        this.ip = PlexiManager.findImage(this.uselection);
        if (this.ip != null) {
            rtn = 0;
            this.ip.getWindow().toFront();
        } else {
            rtn = this.loadByTunnel();
        }
        return rtn;
    }

    public String setTitle() {
        String title = this.uselection.getWindowTitle();
        if (this.uselection.isRadiologic()) {
            title = title + ":Radiologic";
        }
        return title;
    }

    public void initIP(int width, int height, String title) {
        this.ip = new ImagePlus(title, (ImageProcessor)new ByteProcessor(width, height));
    }

    public int loadByTunnel() {
        int rtn = 1;
        this.uselection.setHiResLayerNum(0);
        if (this.getDisplay().equalsIgnoreCase("Montage")) {
            MontageImageLoader loader = new MontageImageLoader(this);
            loader.load();
        } else {
            ImageDimLoader loader = new ImageDimLoader((UserSelection)this.getUserSelection().clone(), HTTPDetails.getHost());
            loader.load();
            if (loader.isError()) {
                loader = null;
                System.gc();
                Runtime.getRuntime().gc();
                this.msgPanel.setMessage("Image couldnt be found");
                rtn = 0;
            } else {
                this.setMontageDisplay((MontageDisplay)loader.getMontageDisplay().clone());
                this.setWindowDimensions((PlexiImageFile)loader.getPlexiImageFile().clone());
                this.uselection.setFile((PlexiImageFile)loader.getPlexiImageFile().clone());
                loader = null;
                System.gc();
                Runtime.getRuntime().gc();
                this.msgPanel.setMessage("Procuring requested Image");
                ImageTunneler tunnel = new ImageTunneler(this, HTTPDetails.getHost());
                tunnel.load();
            }
        }
        return rtn;
    }

    public void setImageInitialized(boolean val) {
        this.isInit = val;
    }

    @Override
    public void setWaitCursor(boolean wait) {
        if (wait) {
            if (this.ip != null) {
                this.ip.getWindow().setCursor(3);
                this.ip.getWindow().getCanvas().setCursor(new Cursor(3));
            }
        } else if (this.ip != null) {
            this.ip.getWindow().setCursor(0);
            this.ip.getWindow().getCanvas().setCursor(new Cursor(0));
        }
    }

    public void windowClosing() {
        if (this.selfClose) {
            this.selfClose = false;
        } else {
            this.msgPanel.setMessage("");
            PlexiManager.removeImage(this);
        }
    }

    public void setSlice(int sNo) {
        this.ip.setSlice(sNo);
    }

    public void show() {
        if (this.uselection.getDisplay().equalsIgnoreCase("MONTAGE") || this.slices == 1) {
            this.showMontage();
        } else if (this.uselection.getDisplay().equalsIgnoreCase("STACK")) {
            this.showStack();
        }
    }

    private void showStack() {
        if (this.selfClose) {
            this.stackWin.stopThread();
            boolean isRunning = this.stackWin.running || this.stackWin.running2;
            this.stackWin.running2 = false;
            this.stackWin.running = false;
            if (isRunning) {
                IJ.wait((int)500);
            }
            this.stackWin.setVisible(false);
            this.stackWin.dispose();
        }
        this.stackWin = new MRStackWindow(this, new MRCanvas(this));
        this.setMessage("Procuring Image", "Please wait");
        this.listenTo((Component)((Object)this.stackWin));
    }

    private void showMontage() {
        this.montageWin = new MRMontageWindow(this);
        this.listenTo((Component)((Object)this.montageWin));
    }

    public void listenTo(Component c) {
        c.addKeyListener(this);
        c.removeKeyListener((KeyListener)IJ.getInstance());
        if (c instanceof Container) {
            Component[] allComps = ((Container)c).getComponents();
            for (int i = 0; i < allComps.length; ++i) {
                this.listenTo(allComps[i]);
            }
        }
    }

    public String getSubject() {
        return this.uselection.getSessionId();
    }

    public boolean getRadiologic() {
        return this.uselection.isRadiologic();
    }

    @Override
    public ImagePlus getImagePlus() {
        if (this.ip.getTitle() == null || this.ip.getTitle().equals("")) {
            this.ip.setTitle(this.setTitle());
        }
        return this.ip;
    }

    public int getScale() {
        return this.scaleFactor;
    }

    @Override
    public UserSelection getUserSelection() {
        return this.uselection;
    }

    public String getDisplay() {
        return this.uselection.getDisplay();
    }

    public String getRadString() {
        if (this.uselection.isRadiologic()) {
            return "true";
        }
        return "false";
    }

    public void rescale(int s) {
        if (s > 4) {
            return;
        }
        if (this.uselection.getDisplay().equalsIgnoreCase("MONTAGE")) {
            return;
        }
        if (s != this.scaleFactor) {
            this.selfClose = true;
            this.scaleFactor = s;
            this.rescaling = true;
            this.coords.setScale(this.scaleFactor);
            if (this.uselection.getDisplay().equalsIgnoreCase("STACK")) {
                this.showStack();
            }
            this.adjustCoords(this.x, this.y, this.z, this.ipValue, true, this.uselection.getOrientation(), this.uselection.isRadiologic());
            this.rescaling = false;
        }
    }

    public void syncEvent(boolean resetSlice) {
        this.ipValue = this.ip.getProcessor().getPixelValue(this.x, this.y);
        PlexiManager.syncStacks(this.x, this.y, this.z, this.ipValue, resetSlice, this.uselection.getOrientation(), this.uselection.isRadiologic(), this.mDisplay.getLayout().getName(), this.uselection.getProject(), this.uselection.getDataType());
    }

    public void syncEvent(int x, int y, boolean resetSlice) {
        this.setCoords(x, y);
        this.ipValue = this.ip.getProcessor().getPixelValue(x / this.getScale(), y / this.getScale());
        PlexiManager.syncStacks(this.x, this.y, this.z, this.ipValue, resetSlice, this.getOrientation(), this.getRadiologic(), this.mDisplay.getLayout().getName(), this.uselection.getProject(), this.uselection.getDataType());
    }

    public void setCoords(int x, int y) {
        if (this.getDisplay().equalsIgnoreCase("STACK")) {
            this.setStackCoords(x, y);
        } else {
            this.setMontageCoords(x, y);
        }
    }

    private void setCoords(Point3d TalCoords) {
        this.x = (int)TalCoords.getX();
        this.y = (int)TalCoords.getY();
        this.z = (int)TalCoords.getZ();
    }

    private void setMontageCoords(int x, int y) {
        this.coords.setTalFromMontage(x, y);
        this.setCoords(this.coords.getPosTal());
    }

    private void setStackCoords(int x, int y) {
        int currentSlice = this.ip.getCurrentSlice();
        this.coords.setTalFromStack(x, y, currentSlice);
        this.setCoords(this.coords.getPosTal());
    }

    public void setCoordBySlice() {
        int currentSlice = this.ip.getCurrentSlice();
        this.coords.setTalFromSlice(currentSlice);
        this.z = (int)this.coords.getPosTal().getZ();
    }

    @Override
    public void setMessage(String descriptor, String message) {
        if (this.getDisplay().equalsIgnoreCase("STACK") && this.stackWin != null) {
            this.stackWin.setMessage(descriptor, message);
            this.stackWin.message();
            this.stackWin.repaint();
        } else if (this.getDisplay().equalsIgnoreCase("MONTAGE") && this.montageWin != null) {
            this.montageWin.setMessage(descriptor, message);
            this.montageWin.message();
            this.montageWin.repaint();
        }
    }

    public void printCoords() {
        int i;
        String message = "";
        String xs = Integer.toString(this.x);
        String ys = Integer.toString(this.y);
        String zs = Integer.toString(this.z);
        String pixelValue = "" + StringUtils.d2s(this.ipValue, 1);
        for (i = 0; i < 4 - xs.length(); ++i) {
            message = message + " ";
        }
        message = message + xs + ",";
        for (i = 0; i < 4 - ys.length(); ++i) {
            message = message + " ";
        }
        message = message + ys + ",";
        for (i = 0; i < 4 - zs.length(); ++i) {
            message = message + " ";
        }
        message = message + zs + ":";
        for (i = 0; i < 4 - pixelValue.length(); ++i) {
            message = message + " ";
        }
        message = message + pixelValue;
        if (this.mDisplay.getLayout().getName().equalsIgnoreCase("native")) {
            this.setMessage("Coordinates (Native): ", message);
        } else {
            this.setMessage("Coordinates (" + this.mDisplay.getLayout().getName().toUpperCase() + "):", message);
        }
    }

    @Override
    public void adjustCoords(int x, int y, int z, float ipValue, boolean resetSlice, String fromView, boolean fromRadiologic) {
        if (this.getDisplay().equalsIgnoreCase("STACK")) {
            this.coords.setTalFromTal(x, y, z);
            Point3d winPos = this.coords.getPosWindow(this.getDisplay(), fromView, fromRadiologic);
            if (resetSlice) {
                this.stackWin.showSlice((int)winPos.getZ());
            }
            this.setCoords(new Point3d(x, y, z));
            this.ipValue = ipValue;
            this.stackWin.updateCrosshairs((int)winPos.getX(), (int)winPos.getY());
            this.printCoords();
            this.ip.updateAndDraw();
        } else if (this.getDisplay().equalsIgnoreCase("MONTAGE")) {
            this.ipValue = ipValue;
            this.printCoords();
        }
    }

    @Override
    public void adjustRegions(int x, int y, int z, float ipValue, boolean resetSlice, String fromView, boolean fromRadiologic, int region) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (Character.isDigit(keyChar)) {
            this.rescale(Integer.parseInt(String.valueOf(keyChar)));
            int currentSlice = this.ip.getCurrentSlice();
            this.ip.setSlice(currentSlice);
            if (this.stackWin != null) {
                this.stackWin.setSelectorToSlice();
            }
        } else if (keycode == 37) {
            if (this.stackWin != null) {
                int currentSlice = this.ip.getCurrentSlice();
                this.ip.setSlice(currentSlice + 1);
                this.setCoordBySlice();
                this.printCoords();
                this.syncEvent(true);
            }
        } else if (keycode == 39 && this.stackWin != null) {
            int currentSlice = this.ip.getCurrentSlice();
            this.ip.setSlice(currentSlice - 1);
            this.setCoordBySlice();
            this.printCoords();
            this.syncEvent(true);
        }
    }

    public void setSelfClose(boolean b) {
        this.selfClose = b;
    }

    @Override
    public void setMontageDisplay(MontageDisplay md) {
        this.mDisplay = md;
    }

    @Override
    public Layout getLayout() {
        return this.mDisplay.getLayout();
    }

    @Override
    public void setWindowDimensions(PlexiImageFile pf) {
        this.winWidth = pf.getDimX();
        this.winHeight = pf.getDimY();
        this.slices = pf.getDimZ();
        int type = pf.getFileType();
        String title = this.setTitle();
        this.ip = type == 0 || type == 5 || type == 8 ? new ImagePlus(title, (ImageProcessor)new ByteProcessor(this.winWidth, this.winHeight)) : (type == 6 || type == 10 || type == 9 || type == 7 ? new ImagePlus(title, (ImageProcessor)new ColorProcessor(this.winWidth, this.winHeight)) : (type == 1 || type == 2 || type == 13 ? new ImagePlus(title, (ImageProcessor)new ShortProcessor(this.winWidth, this.winHeight)) : new ImagePlus(title, (ImageProcessor)new FloatProcessor(this.winWidth, this.winHeight))));
        this.ip.getProcessor().setColor(Color.black);
        this.ip.getProcessor().fill();
        this.coords = this.getDisplay() != null && this.getDisplay().equalsIgnoreCase("Montage") ? new PlexiCoordinates(this.mDisplay.getOriginalWidth(), this.mDisplay.getOriginalHeight(), this.mDisplay.getOriginalStackSize(), this.mDisplay, this.getOrientation(), this.getRadiologic(), this.mDisplay.getNumberOfColumns()) : new PlexiCoordinates(this.ip.getWidth(), this.ip.getHeight(), this.slices, this.mDisplay, this.getOrientation(), this.getRadiologic(), this.nColumns);
        this.coords.setScale(this.scaleFactor);
        this.uselection.setFile(pf);
        this.show();
    }

    @Override
    public void setWindowDimensions(int w, int h, int s) {
        this.winWidth = w;
        this.winHeight = h;
        this.slices = s;
    }

    public String getOrientation() {
        return this.uselection.getOrientation();
    }

    @Override
    public Rectangle getWindowDimensions() {
        return new Rectangle(this.winWidth, this.winHeight);
    }

    @Override
    public boolean isInitialized() {
        return this.isInit;
    }

    @Override
    public void setImage(int index, ImageStack s) {
    }

    @Override
    public void setImage(int index, ImagePlus s) {
    }

    @Override
    public void updateCrossHair() {
        if (this.getDisplay().equalsIgnoreCase("STACK")) {
            Point3d point = this.coords.getPosWindow(this.getDisplay(), this.getOrientation(), this.getRadiologic());
            this.stackWin.updateCrosshairs((int)point.x, (int)point.y);
        }
    }

    @Override
    public void updateCrossHair(String fromOrientation, int sliceNo) {
        if (this.getDisplay().equalsIgnoreCase("STACK") && !this.getOrientation().equalsIgnoreCase(fromOrientation)) {
            Point3d point = this.coords.getPosWindow(this.getDisplay(), this.getOrientation(), this.getRadiologic());
            int x = (int)point.x;
            int y = (int)point.y;
            if (fromOrientation.equalsIgnoreCase("TRANSVERSE")) {
                y = sliceNo;
            } else if (fromOrientation.equalsIgnoreCase("CORONAL")) {
                if (this.getOrientation().equalsIgnoreCase("TRANSVERSE")) {
                    y = sliceNo;
                } else if (this.getOrientation().equalsIgnoreCase("SAGITTAL")) {
                    x = sliceNo;
                }
            } else if (fromOrientation.equalsIgnoreCase("SAGITTAL")) {
                x = sliceNo;
            }
            this.setCoords(x, y);
            this.stackWin.updateCrosshairs(x, y);
        }
    }

    public int getStackSize() {
        return this.slices;
    }

    public static void main(String[] args) {
        UserSelection u = new UserSelection();
        u.setSessionId("000115_92046");
        u.setDataType("TSE_Processed");
        u.setOrientation("CORONAL");
        u.setDisplay("Stack");
        PlexiImageFile pf = new PlexiImageFile();
        pf.setPath("C:\\Mohana\\Temp\\arc003\\050721_dm1\\PROCESSED\\TSE\\T88_111");
        pf.setName("050721_dm1_tse7_t88_111_fill.4dfp.img");
        u.setFile(pf);
        MRImage mr = new MRImage(u);
    }

    @Override
    public void handleOutOfMemoryError() {
        this.ip.flush();
        this.windowClosing();
        if (this.stackWin != null) {
            this.stackWin.removeKeyListener(this);
            this.stackWin.close();
            this.stackWin.setVisible(false);
            this.stackWin.dispose();
        } else if (this.montageWin != null) {
            this.montageWin.removeKeyListener(this);
            this.montageWin.close();
            this.montageWin.setVisible(false);
            this.montageWin.dispose();
        }
        System.out.println("Out of Memory Encountered");
        this.msgPanel.setMessage("Not enough memory! See Viewer Help to increase memory");
    }

    public String getPathToHiResFile() {
        return this.pathToHiResFile;
    }

    public void setPathToHiResFile(String string) {
        this.pathToHiResFile = string;
    }
}

