/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MR;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Frame;

public class MRMontageMaker {
    private static int columns;
    private static int rows;
    private static int first;
    private static int last;
    private static int inc;
    private static double scale;
    private static boolean label;
    private static boolean borders;
    private static int saveID;

    public ImagePlus makeMontage(ImagePlus imp) {
        if (imp == null || imp.getStackSize() == 1) {
            IJ.error((String)"Stack required");
            return null;
        }
        int nSlices = imp.getStackSize();
        if (columns == 0 || imp.getID() != saveID) {
            rows = columns = (int)Math.sqrt(nSlices);
            int n = nSlices - columns * rows;
            if (n > 0) {
                columns += (int)Math.ceil((double)n / (double)rows);
            }
            scale = 1.0;
            if (imp.getWidth() * columns > 800) {
                scale = 0.5;
            }
            if (imp.getWidth() * columns > 1600) {
                scale = 0.25;
            }
            inc = 1;
            first = 1;
            last = nSlices;
        }
        GenericDialog gd = new GenericDialog("Make Montage", (Frame)IJ.getInstance());
        gd.addNumericField("Columns:", (double)columns, 0);
        gd.addNumericField("Rows:", (double)rows, 0);
        gd.addNumericField("Scale Factor:", scale, 2);
        gd.addNumericField("First Slice:", (double)first, 0);
        gd.addNumericField("Last Slice:", (double)last, 0);
        gd.addNumericField("Increment:", (double)inc, 0);
        gd.addCheckbox("Label Slices", label);
        gd.addCheckbox("Borders", borders);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        columns = (int)gd.getNextNumber();
        rows = (int)gd.getNextNumber();
        scale = gd.getNextNumber();
        first = (int)gd.getNextNumber();
        last = (int)gd.getNextNumber();
        inc = (int)gd.getNextNumber();
        if (first < 1) {
            first = 1;
        }
        if (last > nSlices) {
            last = nSlices;
        }
        if (inc < 1) {
            inc = 1;
        }
        if (gd.invalidNumber()) {
            IJ.error((String)"Invalid number");
            return null;
        }
        label = gd.getNextBoolean();
        borders = gd.getNextBoolean();
        return this.makeMontage(imp, columns, rows, scale, first, last, inc, label, borders);
    }

    public ImagePlus makeMontage(ImagePlus imp, int columns, int rows, double scale, int first, int last, int inc, boolean labels, boolean borders) {
        boolean blackBackground;
        if (imp == null || imp.getStackSize() == 1) {
            IJ.error((String)"Stack required");
            return null;
        }
        int stackWidth = imp.getWidth();
        int stackHeight = imp.getHeight();
        int nSlices = imp.getStackSize();
        int width = (int)((double)stackWidth * scale);
        int height = (int)((double)stackHeight * scale);
        int montageWidth = width * columns;
        int montageHeight = height * rows;
        ImageProcessor montage = imp.getProcessor().createProcessor(montageWidth, montageHeight);
        ImageStatistics is = imp.getStatistics();
        boolean bl = blackBackground = is.mode < 128;
        if (imp.isInvertedLut()) {
            boolean bl2 = blackBackground = !blackBackground;
        }
        if (blackBackground) {
            montage.setColor(Color.black);
            montage.fill();
            montage.setColor(Color.white);
        } else {
            montage.setColor(Color.white);
            montage.fill();
            montage.setColor(Color.black);
        }
        ImageStack stack = imp.getStack();
        int x = 0;
        int y = 0;
        for (int slice = first; slice <= last; slice += inc) {
            ImageProcessor aSlice = stack.getProcessor(slice).resize(width, height);
            montage.insert(aSlice, x, y);
            if (borders) {
                this.drawBorder(montage, x, y, width, height);
            }
            if (labels) {
                this.drawLabel(montage, slice, x, y, width, height);
            }
            if ((x += width) >= montageWidth) {
                x = 0;
                if ((y += height) >= montageHeight) break;
            }
            IJ.showProgress((double)((double)(slice - first) / (double)(last - first)));
        }
        if (borders) {
            this.drawBorder(montage, 0, 0, montageWidth - 1, montageHeight - 1);
        }
        IJ.showProgress((double)1.0);
        return new ImagePlus("Montage", montage);
    }

    void drawBorder(ImageProcessor montage, int x, int y, int width, int height) {
        montage.moveTo(x, y);
        montage.lineTo(x + width, y);
        montage.lineTo(x + width, y + height);
        montage.lineTo(x, y + height);
        montage.lineTo(x, y);
    }

    void drawLabel(ImageProcessor montage, int slice, int x, int y, int width, int height) {
        String s = "" + slice;
        int swidth = montage.getStringWidth(s);
        montage.moveTo(x += width / 2 - swidth / 2, y += height);
        montage.drawString(s);
    }

    static {
        label = false;
        borders = false;
    }
}

