/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MR;

import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.net.URL;
import org.nrg.plexiViewer.lite.ui.PlexiMenuBar;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.viewer.MR.MRCanvas;
import org.nrg.plexiViewer.lite.viewer.MR.MRImage;
import org.nrg.plexiViewer.lite.viewer.MR.MRWindow;
import org.nrg.plexiViewer.lite.viewer.MR.SmallLabel;
import org.nrg.plexiViewer.lite.viewer.MR.ToolPanel;

public class MRMontageWindow
extends ImageWindow
implements MRWindow,
ActionListener {
    private static final int TEXT_GAP = 0;
    private MRImage mrimage;
    private SmallLabel lab;
    private ToolPanel tp;
    private static MRCanvas mrcanvas;
    private String messageStr;
    private String descripStr;
    private PlexiMenuBar pMenuBar;

    public MRMontageWindow(MRImage image) {
        mrcanvas = new MRCanvas(image);
        super(image.getImagePlus(), (ImageCanvas)mrcanvas);
        this.messageStr = "";
        this.descripStr = "";
        this.tp = new ToolPanel(2);
        this.add(this.tp);
        this.mrimage = image;
        this.setBackground(Color.lightGray);
        this.pMenuBar = new PlexiMenuBar(this, HTTPDetails.getHost(), this.mrimage.getUserSelection());
        this.setMenuBar(this.pMenuBar.getMenuBar());
    }

    private void setIcon() {
        URL url = this.getClass().getResource("/brain.gif");
        if (url == null) {
            return;
        }
        Image img = null;
        try {
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img != null) {
            this.setIconImage(img);
        }
    }

    @Override
    public void setMessage(String d, String m) {
        this.descripStr = d;
        this.messageStr = m;
    }

    public MRMontageWindow getWindow() {
        return this;
    }

    @Override
    public void message() {
        if (this.tp != null) {
            this.tp.setMessage(this.descripStr, this.messageStr);
        }
    }

    public void update(Graphics g) {
        this.message();
    }

    public boolean close() {
        super.close();
        this.dispose();
        this.mrimage.getImagePlus().flush();
        this.mrimage.windowClosing();
        return true;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        int TEXT_GAP = 10;
        return new Insets(insets.top - TEXT_GAP, insets.left, insets.bottom, insets.right);
    }

    public void drawInfo(Graphics g) {
    }

    @Override
    public int getCurrentTool() {
        return this.tp.getCurrentSelection();
    }

    public void windowClosing(WindowEvent e) {
        this.pMenuBar.clear();
        this.close();
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        MRMontageWindow win = this;
        win.getCanvas().setMagnification((double)this.mrimage.getScale());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public boolean showCrossHair() {
        boolean rtn = true;
        if (this.pMenuBar != null) {
            rtn = this.pMenuBar.showCrossHair();
        }
        return rtn;
    }

    public boolean showRuler() {
        boolean rtn = true;
        if (this.mrimage.getLayout() == null) {
            rtn = false;
        } else if (!this.mrimage.getLayout().getName().equalsIgnoreCase("native")) {
            if (this.pMenuBar != null) {
                rtn = this.pMenuBar.showRuler();
            }
        } else {
            rtn = false;
        }
        return rtn;
    }

    public boolean markRight() {
        boolean rtn = true;
        if (this.pMenuBar != null) {
            rtn = this.pMenuBar.markRight();
        }
        return rtn;
    }
}

