/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MR;

import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.StackWindow;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.image.ImageProducer;
import java.net.URL;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.ui.PlexiMenuBar;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.viewer.MR.MRCanvas;
import org.nrg.plexiViewer.lite.viewer.MR.MRImage;
import org.nrg.plexiViewer.lite.viewer.MR.MRWindow;
import org.nrg.plexiViewer.lite.viewer.MR.ToolPanel;

public class MRStackWindow
extends StackWindow
implements MRWindow {
    private static final int TEXT_GAP = 0;
    public ToolPanel tp;
    private String messageStr = "";
    private String descripStr = "";
    public MRImage mrimage;
    public MRCanvas mrcanvas;
    private PlexiMenuBar pMenuBar;

    public MRStackWindow(MRImage image, MRCanvas canvas) {
        super(image.getImagePlus(), (ImageCanvas)canvas);
        this.mrcanvas = canvas;
        this.mrimage = image;
        this.addToolPanel();
        this.setscrollbar();
        this.setBackground(Color.lightGray);
        this.pMenuBar = new PlexiMenuBar((ImageWindow)this, HTTPDetails.getHost(), (UserSelection)this.mrimage.getUserSelection().clone());
        this.setMenuBar(this.pMenuBar.getMenuBar());
        this.pack();
        this.mrimage.setImageInitialized(true);
    }

    public void addToolPanel() {
        this.tp = new ToolPanel(1);
        this.add(this.tp);
    }

    private void setscrollbar() {
        int nSlices;
        if (this.mrimage.getImagePlus() != null && (nSlices = this.mrimage.getStackSize()) > 1) {
            this.sliceSelector = new Scrollbar(0, 1, 1, 1, nSlices + 1);
            this.add(this.sliceSelector);
            if (this.ij != null) {
                this.sliceSelector.addKeyListener((KeyListener)this.ij);
            }
            this.sliceSelector.addAdjustmentListener((AdjustmentListener)((Object)this));
            this.sliceSelector.setFocusable(false);
            int blockIncrement = nSlices / 10;
            if (blockIncrement < 1) {
                blockIncrement = 1;
            }
            this.sliceSelector.setUnitIncrement(1);
            this.sliceSelector.setBlockIncrement(blockIncrement);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        super.adjustmentValueChanged(e);
        if (this.mrimage != null) {
            this.mrimage.setCoordBySlice();
            this.mrimage.printCoords();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        MRStackWindow mRStackWindow = this;
        synchronized (mRStackWindow) {
            this.done = true;
            this.notify();
        }
    }

    public void setSelectorToSlice() {
        this.sliceSelector.setValue(this.mrimage.getImagePlus().getCurrentSlice());
    }

    public void updateSliceSelector() {
        if (this.mrimage == null) {
            return;
        }
        super.updateSliceSelector();
        if (this.mrimage != null) {
            this.mrimage.setCoordBySlice();
            this.mrimage.printCoords();
        } else {
            System.out.println("MRStackWindow: mrimage is null");
        }
    }

    private void setIcon() {
        URL url = this.getClass().getResource("/brain.gif");
        if (url == null) {
            return;
        }
        Image img = null;
        try {
            img = this.createImage((ImageProducer)url.getContent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (img != null) {
            this.setIconImage(img);
        }
    }

    @Override
    public void setMessage(String d, String m) {
        this.descripStr = d;
        this.messageStr = m;
    }

    public MRStackWindow getWindow() {
        return this;
    }

    @Override
    public void message() {
        if (this.tp != null) {
            this.tp.setMessage(this.descripStr, this.messageStr);
        }
    }

    public void update(Graphics g) {
        super.update(g);
        this.message();
    }

    public void updateCrosshairs(int x, int y) {
        this.mrcanvas.setCrosshairPosition(x, y);
        this.mrcanvas.repaint();
    }

    public void rescale() {
    }

    public void doRescale(int s) {
    }

    public boolean close() {
        super.close();
        this.mrimage.getImagePlus().flush();
        this.mrimage.windowClosing();
        this.pMenuBar = null;
        return true;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        int TEXT_GAP = 10;
        return new Insets(insets.top - TEXT_GAP, insets.left, insets.bottom, insets.right);
    }

    public void drawInfo(Graphics g) {
    }

    @Override
    public int getCurrentTool() {
        return this.tp.getCurrentSelection();
    }

    public void windowClosing(WindowEvent e) {
        this.pMenuBar.clear();
        this.close();
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        MRStackWindow win = this;
        if (win.getCanvas() != null && this.mrimage != null) {
            win.getCanvas().setMagnification((double)this.mrimage.getScale());
        }
    }

    public boolean showCrossHair() {
        boolean rtn = true;
        if (this.pMenuBar != null) {
            rtn = this.pMenuBar.showCrossHair();
        }
        return rtn;
    }

    public boolean showRuler() {
        boolean rtn = true;
        if (this.mrimage.getLayout() == null) {
            rtn = false;
        } else if (!this.mrimage.getLayout().getName().equalsIgnoreCase("native")) {
            if (this.pMenuBar != null) {
                rtn = this.pMenuBar.showRuler();
            }
        } else {
            rtn = false;
        }
        return rtn;
    }

    public boolean markRight() {
        boolean rtn = true;
        if (this.pMenuBar != null) {
            rtn = this.pMenuBar.markRight();
        }
        return rtn;
    }
}

