/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MiriadLobarSeg;

import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;

public class SegByteProcessor
extends ByteProcessor {
    public SegByteProcessor(int width, int height) {
        super(width, height);
    }

    public SegByteProcessor(Image img) {
        super(img);
    }

    private final double getBetterInterpolatedPixel(double x, double y, byte[] pixels) {
        int xbase = (int)x;
        int ybase = (int)y;
        double xFraction = x - (double)xbase;
        double yFraction = y - (double)ybase;
        int offset = ybase * this.width + xbase;
        int lowerLeft = pixels[offset] & 0xFF;
        int lowerRight = pixels[offset + 1] & 0xFF;
        int upperRight = pixels[offset + this.width + 1] & 0xFF;
        int upperLeft = pixels[offset + this.width] & 0xFF;
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public ImageProcessor resize(int dstWidth, int dstHeight) {
        if (this.roiWidth == dstWidth && this.roiHeight == dstHeight) {
            return this.crop();
        }
        double srcCenterX = (double)this.roiX + (double)this.roiWidth / 2.0;
        double srcCenterY = (double)this.roiY + (double)this.roiHeight / 2.0;
        double dstCenterX = (double)dstWidth / 2.0;
        double dstCenterY = (double)dstHeight / 2.0;
        double xScale = (double)dstWidth / (double)this.roiWidth;
        double yScale = (double)dstHeight / (double)this.roiHeight;
        if (this.interpolate) {
            dstCenterX += xScale / 2.0;
            dstCenterY += yScale / 2.0;
        }
        ImageProcessor ip2 = this.createProcessor(dstWidth, dstHeight);
        byte[] pixels2 = (byte[])ip2.getPixels();
        double xlimit = (double)this.width - 1.0;
        double xlimit2 = (double)this.width - 1.001;
        double ylimit = (double)this.height - 1.0;
        double ylimit2 = (double)this.height - 1.001;
        for (int y = 0; y <= dstHeight - 1; ++y) {
            double ys = ((double)y - dstCenterY) / yScale + srcCenterY;
            if (this.interpolate) {
                if (ys < 0.0) {
                    ys = 0.0;
                }
                if (ys >= ylimit) {
                    ys = ylimit2;
                }
            }
            int index1 = this.width * (int)ys;
            int index2 = y * dstWidth;
            for (int x = 0; x <= dstWidth - 1; ++x) {
                double xs = ((double)x - dstCenterX) / xScale + srcCenterX;
                if (this.interpolate) {
                    if (xs < 0.0) {
                        xs = 0.0;
                    }
                    if (xs >= xlimit) {
                        xs = xlimit2;
                    }
                    pixels2[index2++] = (byte)((int)(this.getBetterInterpolatedPixel(xs, ys, this.pixels) + 0.5) & 0xFF);
                    continue;
                }
                pixels2[index2++] = this.pixels[index1 + (int)xs];
            }
            if (y % 20 != 0) continue;
            this.showProgress((double)y / (double)dstHeight);
        }
        this.hideProgress();
        return ip2;
    }
}

