/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.MiriadMrxSeg;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.viewer.MiriadMrxSeg.SegColorModel;
import org.nrg.plexiViewer.lite.viewer.MiriadMrxSeg.SegImage;
import org.nrg.plexiViewer.lite.viewer.MiriadMrxSeg.SegStackWindow;

public class SegCanvas
extends ImageCanvas {
    SegImage _image;
    int startX;
    int startY;
    int xhandled;
    int yhandled;
    private boolean syncFlag;
    int crosshairX = -1;
    int crosshairY = -1;
    Image buffer;
    Graphics bufferGraphics;
    boolean mouseDown = false;
    SegColorModel cm;
    int[] volCount = null;
    int currentRegion;

    public SegCanvas(SegImage image) {
        super(image.getStrImage());
        this._image = image;
        int scale = image.getScale();
        super.setMagnification((double)scale);
        int height = image.getStrImage().getHeight();
        int width = image.getStrImage().getWidth();
        super.setDrawingSize(width * scale, height * scale);
        this.setSize(width * scale, height * scale);
        this.currentRegion = (Integer)PlexiManager.getSetting("SegImage.regionID");
    }

    private void buildColorModel() {
        if (this.cm == null) {
            this.cm = new SegColorModel();
        }
        this.cm.setRegion(this.currentRegion);
        this.cm.makeDefaultLUT();
        this._image.getAsegImage().getProcessor().setColorModel((ColorModel)this.cm.getCm());
    }

    public void updateAndDraw() {
        this.buildColorModel();
    }

    public void setCmRegion(int region) {
        this.currentRegion = region;
        this.buildColorModel();
        this.repaint();
    }

    public void paint(Graphics g) {
        Point src2;
        Point src1;
        Point dst2;
        String s = this._image.getOrientation().equalsIgnoreCase("sagittal") ? "" : (this._image.getRadiologic() ? "L" : "R");
        Rectangle r = super.getSrcRect();
        int scale = this._image.getScale();
        if (this.bufferGraphics == null) {
            this.buffer = this.createImage(r.width * scale, r.height * scale);
            this.bufferGraphics = this.buffer.getGraphics();
        }
        this.bufferGraphics.setColor(Color.black);
        this.bufferGraphics.fillRect(0, 0, r.width * scale, r.height * scale);
        ImagePlus str = this._image.getStrImage();
        ImagePlus seg = this._image.getAsegImage();
        seg.setSlice(str.getCurrentSlice());
        str.updateImage();
        seg.updateImage();
        Image img = str.getImage();
        if (img != null) {
            dst2 = new Point(r.width * scale, r.height * scale);
            src1 = new Point(r.x, r.y);
            src2 = new Point(r.x + r.width, r.y + r.height);
            this.bufferGraphics.drawImage(img, 0, 0, dst2.x, dst2.y, src1.x, src1.y, src2.x, src2.y, null);
        }
        if ((img = seg.getImage()) != null) {
            dst2 = new Point(r.width * scale, r.height * scale);
            src1 = new Point(r.x, r.y);
            src2 = new Point(r.x + r.width, r.y + r.height);
            this.bufferGraphics.drawImage(img, 0, 0, dst2.x, dst2.y, src1.x, src1.y, src2.x, src2.y, null);
        }
        if (str.getWindow() != null && ((SegStackWindow)str.getWindow()).markRight()) {
            this.bufferGraphics.setColor(new Color(50, 200, 25));
            this.bufferGraphics.drawString(s, r.width * scale - 20, r.height * scale - 10);
        }
        if (str.getWindow() != null && ((SegStackWindow)str.getWindow()).showCrossHair()) {
            this.bufferGraphics.setColor(new Color(100, 255, 50));
            double space = 5.0;
            this.bufferGraphics.drawLine(0, this.crosshairY, this.crosshairX - (int)space, this.crosshairY);
            this.bufferGraphics.drawLine(this.crosshairX + (int)space, this.crosshairY, this.getBounds().width * scale, this.crosshairY);
            this.bufferGraphics.drawLine(this.crosshairX, 0, this.crosshairX, this.crosshairY - (int)space);
            this.bufferGraphics.drawLine(this.crosshairX, this.crosshairY + (int)space, this.crosshairX, scale * this.getBounds().height);
        }
        g.drawImage(this.buffer, 0, 0, (ImageObserver)((Object)this));
    }

    public Dimension getPreferredSize() {
        int scale = this._image.getScale();
        int height = this._image.getImagePlus().getHeight();
        int width = this._image.getImagePlus().getWidth();
        return new Dimension(width * scale, height * scale);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        Point p = e.getPoint();
        this.startX = p.x;
        this.startY = p.y;
        this.xhandled = 0;
        this.yhandled = 0;
    }

    public void mouseClicked(MouseEvent e) {
        Point p = e.getPoint();
        this._image.syncEvent(p.x, p.y, true);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
    }

    public void setCursor(int x, int y) {
    }

    public void mouseDragged(MouseEvent e) {
        int flags = e.getModifiers();
        ImagePlus imp = this._image.getStrImage();
        Point p = e.getPoint();
        ImageProcessor ip = imp.getProcessor();
        int xdist = p.x - this.startX;
        int xincr = xdist - this.xhandled;
        this.xhandled = xdist;
        int ydist = p.y - this.startY;
        int yincr = ydist - this.yhandled;
        this.yhandled = ydist;
        this.adjustAlpha(xincr);
        this.buildColorModel();
        imp.updateAndDraw();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    void adjustAlpha(double bvalue) {
        int a = this.cm.getAlpha();
        if ((a += (int)bvalue * 10) > 255) {
            a = 255;
        }
        if (a < 0) {
            a = 0;
        }
        this.cm.setAlpha(a);
        this.buildColorModel();
    }

    void adjustBrightness(ImageProcessor ip, double bvalue) {
        double min = ip.getMin();
        double max = ip.getMax();
        ip.setMinAndMax(min - bvalue, max - bvalue);
        if (min == max) {
            this.setThreshold(ip);
        }
    }

    void adjustContrast(ImageProcessor ip, int cvalue) {
        double min = ip.getMin();
        double max = ip.getMax();
        double center = (min + max) / 2.0;
        double range = max - min;
        if ((range += (double)(4 * cvalue)) < 2.0) {
            range = 2.0;
        }
        ip.setMinAndMax(center - range / 2.0, center + range / 2.0);
    }

    void setThreshold(ImageProcessor ip) {
        if (!(ip instanceof ByteProcessor)) {
            return;
        }
        if (((ByteProcessor)ip).isInvertedLut()) {
            ip.setThreshold(255.0, 255.0, 2);
        } else {
            ip.setThreshold(0.0, 255.0, 2);
        }
    }

    void setCrosshairPosition(int x, int y) {
        this.crosshairX = x;
        this.crosshairY = y;
    }

    public String getVolumeCount(int index) {
        String rtn = "";
        if (this._image.getDisplay().equalsIgnoreCase("MONTAGE")) {
            rtn = "Req. Stack display";
        }
        if (this.volCount != null && 0 <= index && index <= this.volCount.length) {
            rtn = "" + this.volCount[index];
        }
        System.out.println("getVolumeCount retn " + index + " " + rtn);
        return rtn;
    }

    public void setVolumeCount(int[] count) {
        this.volCount = count;
    }
}

