/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.viewer.Seg;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageWindow;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.display.PlexiCoordinates;
import org.nrg.plexiViewer.lite.display.Point3d;
import org.nrg.plexiViewer.lite.gui.PlexiMessagePanel;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.manager.PlexiImageViewerI;
import org.nrg.plexiViewer.lite.manager.PlexiManager;
import org.nrg.plexiViewer.lite.tunneler.ImageDimLoader;
import org.nrg.plexiViewer.lite.tunneler.MontageImageLoader;
import org.nrg.plexiViewer.lite.tunneler.NoMsgImageTunneler;
import org.nrg.plexiViewer.lite.utils.BrowserVersionInfo;
import org.nrg.plexiViewer.lite.utils.HTTPDetails;
import org.nrg.plexiViewer.lite.viewer.Seg.SegCanvas;
import org.nrg.plexiViewer.lite.viewer.Seg.SegStackWindow;
import org.nrg.plexiViewer.lite.viewer.Seg.SegVolumeCounter;
import org.nrg.plexiViewer.lite.xml.HiRes;
import org.nrg.plexiViewer.lite.xml.Layout;

public class SegImage
implements KeyListener,
PlexiImageViewerI {
    private int x;
    private int y;
    private int z;
    private float ipValue;
    private int currentImageIndex;
    private SegStackWindow stackWin;
    private int scaleFactor = 1;
    private boolean selfClose = false;
    private boolean rescaling = false;
    private int nColumns;
    private int nRows;
    private PlexiCoordinates coords;
    private String viewableGroupName;
    private String orientation;
    private String sequenceName;
    private String display;
    private boolean radiologic;
    private MontageDisplay mDisplay;
    private UserSelection uselection;
    private HiRes hRes;
    private int winWidth;
    private int winHeight;
    private int slices;
    private int numberOfImagesToBeFetched;
    private SegCanvas segCanvas;
    int[] volCount;
    SegVolumeCounter segVolCounter;
    private ImagePlus asegIP;
    private ImagePlus origIP;
    private PlexiMessagePanel msgPanel;

    public SegImage(UserSelection u) {
        this.uselection = u;
        this.winWidth = -1;
        this.winHeight = -1;
        this.init();
        this.coords = null;
        this.mDisplay = null;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.volCount = null;
    }

    public void init() {
        this.orientation = this.uselection.getOrientation();
        this.display = this.uselection.getDisplay();
        this.radiologic = this.uselection.isRadiologic();
    }

    public void loadByTunnel(int i) {
        UserSelection u = (UserSelection)this.getUserSelection().clone();
        u.setHiResLayerNum((Integer)u.getHiResLayerNos().elementAt(i));
        NoMsgImageTunneler tunnel = new NoMsgImageTunneler(this);
        tunnel.load(u, i);
    }

    public int loadImages() {
        int rtn = 1;
        String key = "";
        try {
            if (this.getDisplay().equalsIgnoreCase("Montage")) {
                this.uselection.setHiResLayerNum((Integer)this.uselection.getHiResLayerNos().elementAt(0));
                MontageImageLoader loader = new MontageImageLoader(this, false);
                loader.load();
                this.uselection.setHiResLayerNum(-1);
                this.msgPanel.setMessage("Procuring requested Image ......");
                this.loadByTunnel(0);
                this.loadByTunnel(1);
            } else {
                UserSelection u = (UserSelection)this.getUserSelection().clone();
                u.setHiResLayerNum((Integer)u.getHiResLayerNos().elementAt(0));
                ImageDimLoader loader = new ImageDimLoader(u, HTTPDetails.getHost());
                loader.load();
                if (loader.isError()) {
                    this.msgPanel.setMessage("Image couldnt be found");
                    loader = null;
                    u = null;
                    System.gc();
                    Runtime.getRuntime().gc();
                    rtn = 0;
                } else {
                    this.segVolCounter = new SegVolumeCounter(this.uselection.getSessionId(), HTTPDetails.getHost());
                    if (this.volCount == null) {
                        this.segVolCounter.setVolumeCounts();
                    }
                    this.volCount = this.segVolCounter.getVolumeCount();
                    this.setMontageDisplay((MontageDisplay)loader.getMontageDisplay().clone());
                    this.setWindowDimensions((PlexiImageFile)loader.getPlexiImageFile().clone());
                    loader = null;
                    u = null;
                    System.gc();
                    Runtime.getRuntime().gc();
                    this.msgPanel.setMessage("Procuring requested Image");
                    this.loadByTunnel(0);
                    this.loadByTunnel(1);
                }
            }
        }
        catch (OutOfMemoryError ome) {
            this.handleOutOfMemoryError();
        }
        return rtn;
    }

    public void windowClosing() {
        if (this.selfClose) {
            this.selfClose = false;
        } else {
            this.segVolCounter = null;
            this.volCount = null;
            PlexiManager.removeImage(this);
        }
    }

    @Override
    public int open(PlexiMessagePanel msgPanel) {
        this.msgPanel = msgPanel;
        int rtn = 1;
        if (PlexiManager.findImage(this.uselection) != null) {
            PlexiManager.findImage(this.uselection).getWindow().toFront();
        } else {
            rtn = this.loadImages();
            System.gc();
        }
        return rtn;
    }

    @Override
    public void setWaitCursor(boolean wait) {
    }

    public void setMinAndMax(ImageProcessor ip) {
        double min2 = ip.getMin();
        double max2 = ip.getMax();
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip.resetMinAndMax();
        }
        ip.setMinAndMax(min2, max2);
        min2 = ip.getMin();
        max2 = ip.getMax();
    }

    public void setSlice(int sNo) {
        this.origIP.setSlice(sNo);
        this.asegIP.setSlice(sNo);
    }

    public void setUpImages() {
        int slice = 1;
        if (this.display.equalsIgnoreCase("STACK")) {
            slice = 50;
        }
        this.setSlice(slice);
        this.setMinAndMax(this.origIP.getProcessor());
    }

    public void show(int scale) {
        int currentRegionShown = (Integer)PlexiManager.getSetting("SegImage.regionID");
        this.segCanvas = new SegCanvas(this);
        this.segCanvas.setCmRegion(currentRegionShown);
        this.segCanvas.setVolumeCount(this.volCount);
        this.segCanvas.updateAndDraw();
        this.show();
        this.stackWin.tp.setRegionName(currentRegionShown);
        this.stackWin.setMessage("");
    }

    public boolean show() {
        boolean rtn = true;
        if (this.selfClose) {
            this.asegIP.setWindow(null);
            this.origIP.setWindow(null);
            this.stackWin.stopThread();
            boolean isRunning = this.stackWin.running || this.stackWin.running2;
            this.stackWin.running2 = false;
            this.stackWin.running = false;
            if (isRunning) {
                IJ.wait((int)500);
            }
            this.stackWin.setVisible(false);
            this.stackWin.dispose();
        }
        Runtime.getRuntime().runFinalization();
        long totalMemory = Runtime.getRuntime().totalMemory();
        Runtime.getRuntime().gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        int freeMemPct = (int)((float)freeMemory / (float)totalMemory * 100.0f);
        System.out.println("Seg Image Memory Free:: " + freeMemPct + "%");
        int limit = 25;
        BrowserVersionInfo bInfo = new BrowserVersionInfo();
        if (bInfo.isWin()) {
            limit = 15;
        }
        if (freeMemPct < limit) {
            this.msgPanel.setMessage("Not enough memory! See Viewer Help to increase memory");
            System.out.println("Not enough memory available to show ");
            this.getAsegImage().flush();
            this.getStrImage().flush();
            this.windowClosing();
            rtn = false;
        } else {
            this.stackWin = new SegStackWindow(this, this.segCanvas);
            this.stackWin.setRegion((Integer)PlexiManager.getSetting("SegImage.regionID"));
            this.msgPanel.setMessage("Procuring requested Image");
            this.stackWin.setMessage("Procuring image. Please wait");
            this.stackWin.updateSliceSelector();
            this.listenTo((Component)((Object)this.stackWin));
        }
        return rtn;
    }

    public String setTitle() {
        String title = this.uselection.getWindowTitle();
        if (this.uselection.isRadiologic()) {
            title = title + ":Radiologic";
        }
        return title;
    }

    @Override
    public synchronized void setMessage(String descriptor, String message) {
        if (this.stackWin != null) {
            this.stackWin.setMessage(message);
            this.stackWin.repaint();
        }
    }

    public ImagePlus getImageCopy() {
        return new ImagePlus();
    }

    @Override
    public synchronized ImagePlus getImagePlus() {
        return this.getStrImage();
    }

    public ImagePlus getAsegImage() {
        return this.asegIP;
    }

    public ImagePlus getStrImage() {
        return this.origIP;
    }

    public int getScale() {
        return this.scaleFactor;
    }

    public void rescale(int s) {
        if (s > 4) {
            return;
        }
        if (this.display.equalsIgnoreCase("MONTAGE")) {
            return;
        }
        if (s != this.scaleFactor) {
            this.selfClose = true;
            this.scaleFactor = s;
            this.rescaling = true;
            this.coords.setScale(this.scaleFactor);
            if (this.display.equalsIgnoreCase("STACK")) {
                this.show(this.scaleFactor);
            }
            this.adjustCoords(this.x, this.y, this.z, this.ipValue, true, this.orientation, this.radiologic);
            this.rescaling = false;
        }
    }

    public boolean isScaling() {
        return this.rescaling;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (Character.isDigit(keyChar)) {
            this.rescale(Integer.parseInt(String.valueOf(keyChar)));
            int currentSlice = this.asegIP.getCurrentSlice();
            this.asegIP.setSlice(currentSlice);
            this.origIP.setSlice(currentSlice);
            if (this.stackWin != null) {
                this.stackWin.setSelectorToSlice();
            }
        } else if (keycode == 37) {
            if (this.stackWin != null) {
                int currentSlice = this.origIP.getCurrentSlice();
                this.origIP.setSlice(currentSlice + 1);
                this.asegIP.setSlice(currentSlice + 1);
            }
        } else if (keycode == 39 && this.stackWin != null) {
            int currentSlice = this.origIP.getCurrentSlice();
            this.origIP.setSlice(currentSlice - 1);
            this.asegIP.setSlice(currentSlice - 1);
        }
    }

    @Override
    public UserSelection getUserSelection() {
        return this.uselection;
    }

    public String getDisplay() {
        return this.display;
    }

    public boolean getRadiologic() {
        return this.radiologic;
    }

    public void syncRegions(int region, String regionName) {
        String imageViewerClass = this.uselection.getImageViewerClass();
        this.ipValue = this.asegIP.getProcessor().getPixelValue(this.x, this.y);
        PlexiManager.syncSegStacks(this.x, this.y, this.z, this.ipValue, this.orientation, this.radiologic, this.mDisplay.getLayout().getName(), imageViewerClass, region, regionName);
    }

    public void syncEvent(boolean resetSlice) {
        this.ipValue = this.asegIP.getProcessor().getPixelValue(this.x / this.getScale(), this.y / this.getScale());
        PlexiManager.syncStacks(this.x, this.y, this.z, this.ipValue, resetSlice, this.orientation, this.radiologic, this.mDisplay.getLayout().getName(), this.uselection.getProject(), this.uselection.getDataType());
    }

    public void syncEvent(int x, int y, boolean resetSlice) {
        this.setCoords(x, y);
        this.ipValue = this.asegIP.getProcessor().getPixelValue(x / this.getScale(), y / this.getScale());
        PlexiManager.syncStacks(this.x, this.y, this.z, this.ipValue, resetSlice, this.orientation, this.radiologic, this.mDisplay.getLayout().getName(), this.uselection.getProject(), this.uselection.getDataType());
    }

    public void setCoords(int x, int y) {
        if (this.display.equalsIgnoreCase("STACK")) {
            this.setStackCoords(x, y);
        } else {
            this.setMontageCoords(x, y);
        }
    }

    private void setMontageCoords(int x, int y) {
        this.coords.setTalFromMontage(x, y);
        this.setCoords(this.coords.getPosTal());
    }

    private void setCoords(Point3d talCoordinates) {
        this.x = (int)talCoordinates.getX();
        this.y = (int)talCoordinates.getY();
        this.z = (int)talCoordinates.getZ();
        this.stackWin.setCoords(this.x, this.y, this.z);
    }

    private void setStackCoords(int x, int y) {
        int currentSlice = this.getStrImage().getCurrentSlice();
        this.coords.setTalFromStack(x, y, currentSlice);
        this.setCoords(this.coords.getPosTal());
    }

    public void setCoordBySlice() {
        int currentSlice = this.origIP.getCurrentSlice();
        this.coords.setTalFromSlice(currentSlice);
        this.z = (int)this.coords.getPosTal().getZ();
    }

    @Override
    public void adjustCoords(int x, int y, int z, float ipValue, boolean resetSlice, String fromView, boolean fromRadiologic) {
        if (this.display.equalsIgnoreCase("STACK")) {
            this.coords.setTalFromTal(x, y, z);
            Point3d winPos = this.coords.getPosWindow(this.display, fromView, fromRadiologic);
            if (resetSlice) {
                this.stackWin.showSlice((int)winPos.getZ());
            }
            this.setCoords(new Point3d(x, y, z));
            int[] val = this.getAsegImage().getPixel((int)(winPos.x / (float)this.getScale()), (int)(winPos.y / (float)this.getScale()));
            this.stackWin.setRegion(val[0]);
            this.stackWin.updateCrosshairs((int)winPos.getX(), (int)winPos.getY());
            this.getAsegImage().updateAndDraw();
            this.getStrImage().updateAndDraw();
        }
    }

    @Override
    public void adjustRegions(int x, int y, int z, float ipValue, boolean resetSlice, String regionName, boolean fromRadiologic, int region) {
        this.segCanvas.setCmRegion(region);
        this.stackWin.tp.displayChoice.select(regionName);
        this.stackWin.tp.setVolumeCount(this.segCanvas.getVolumeCount(region));
    }

    public void listenTo(Component c) {
        c.addKeyListener(this);
        c.removeKeyListener((KeyListener)IJ.getInstance());
        if (c instanceof Container) {
            Component[] allComps = ((Container)c).getComponents();
            for (int i = 0; i < allComps.length; ++i) {
                this.listenTo(allComps[i]);
            }
        }
    }

    public void setSelfClose(boolean b) {
        this.selfClose = b;
    }

    @Override
    public synchronized void setMontageDisplay(MontageDisplay md) {
        this.mDisplay = md;
    }

    @Override
    public Layout getLayout() {
        if (this.mDisplay != null) {
            return this.mDisplay.getLayout();
        }
        return null;
    }

    @Override
    public void setWindowDimensions(int w, int h, int s) {
        this.winWidth = w;
        this.winHeight = h;
        this.slices = s;
    }

    @Override
    public void setWindowDimensions(PlexiImageFile pf) {
        this.winWidth = pf.getDimX();
        this.winHeight = pf.getDimY();
        this.slices = pf.getDimZ();
        this.initIP(this.winWidth, this.winHeight, this.setTitle());
        this.segCanvas = new SegCanvas(this);
        this.coords = this.display != null && this.display.equalsIgnoreCase("Montage") ? new PlexiCoordinates(this.mDisplay.getOriginalWidth(), this.mDisplay.getOriginalHeight(), this.mDisplay.getOriginalStackSize(), this.mDisplay, this.orientation, this.radiologic, this.mDisplay.getNumberOfColumns()) : new PlexiCoordinates(this.origIP.getWidth(), this.origIP.getHeight(), this.slices, this.mDisplay, this.orientation, this.radiologic, this.nColumns);
        this.coords.setScale(this.getScale());
        this.segCanvas.setVolumeCount(this.volCount);
        this.show();
    }

    public void initIP(int width, int height, String title) {
        this.origIP = new ImagePlus(title, (ImageProcessor)new ByteProcessor(width, height));
        this.asegIP = new ImagePlus(title, (ImageProcessor)new ByteProcessor(width, height));
        this.origIP.getProcessor().setColor(Color.black);
        this.origIP.getProcessor().fill();
        this.asegIP.getProcessor().setColor(Color.black);
        this.asegIP.getProcessor().fill();
    }

    public String getOrientation() {
        return this.orientation;
    }

    @Override
    public synchronized Rectangle getWindowDimensions() {
        return new Rectangle(this.winWidth, this.winHeight);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void handleOutOfMemoryError() {
        System.out.println("Handling out of memory " + this.selfClose);
        this.windowClosing();
        if (this.origIP != null) {
            this.origIP.flush();
        }
        if (this.asegIP != null) {
            this.asegIP.flush();
        }
        this.volCount = null;
        if (this.segCanvas != null) {
            this.segCanvas.setVolumeCount(null);
        }
        if (this.stackWin != null) {
            this.stackWin.removeKeyListener(this);
            this.stackWin.close();
            System.out.println("Out of Memory Encountered");
            this.stackWin.setVisible(false);
            this.stackWin.dispose();
        }
        this.msgPanel.setMessage("Not enough memory! See Viewer Help to increase memory");
    }

    @Override
    public synchronized void setImage(int index, ImageStack s) {
        try {
            if (index == 0) {
                ImageWindow win = this.origIP.getWindow();
                this.origIP.setWindow(null);
                this.origIP.setStack(this.setTitle(), s);
                this.origIP.setWindow(win);
            } else {
                this.asegIP.setStack(this.setTitle(), s);
                ((SegCanvas)this.origIP.getWindow().getCanvas()).updateAndDraw();
            }
            if (this.getDisplay().equalsIgnoreCase("Stack")) {
                this.stackWin.updateSliceSelector();
            }
            if (this.asegIP.getStackSize() == s.getSize() && this.origIP.getStackSize() == s.getSize()) {
                this.stackWin.setRegion((Integer)PlexiManager.getSetting("SegImage.regionID"));
                this.stackWin.setMessage("");
                this.msgPanel.setMessage("");
                if (this.getDisplay().equalsIgnoreCase("Montage")) {
                    this.stackWin.getCanvas().repaint();
                    this.stackWin.repaint();
                }
            }
        }
        catch (OutOfMemoryError ome) {
            this.handleOutOfMemoryError();
        }
    }

    @Override
    public void setImage(int index, ImagePlus s) {
    }

    @Override
    public void updateCrossHair() {
        if (this.display.equalsIgnoreCase("STACK")) {
            Point3d point = this.coords.getPosWindow(this.display, this.orientation, this.radiologic);
            this.stackWin.updateCrosshairs((int)point.x, (int)point.y);
        }
    }

    @Override
    public void updateCrossHair(String fromOrientation, int sliceNo) {
        if (this.display.equalsIgnoreCase("STACK") && !this.orientation.equalsIgnoreCase(fromOrientation)) {
            Point3d point = this.coords.getPosWindow(this.display, this.orientation, this.radiologic);
            int x = (int)point.x;
            int y = (int)point.y;
            if (fromOrientation.equalsIgnoreCase("TRANSVERSE")) {
                y = sliceNo;
            } else if (fromOrientation.equalsIgnoreCase("CORONAL")) {
                if (this.orientation.equalsIgnoreCase("TRANSVERSE")) {
                    y = sliceNo;
                } else if (this.orientation.equalsIgnoreCase("SAGITTAL")) {
                    x = sliceNo;
                }
            } else if (fromOrientation.equalsIgnoreCase("SAGITTAL")) {
                x = sliceNo;
            }
            this.setCoords(x, y);
            this.stackWin.updateCrosshairs(x, y);
        }
    }
}

