/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.lite.xml;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.nrg.plexiViewer.lite.xml.LinkedDropDown;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.plexiViewer.utils.ArchivePathManager;

public class PlexiViewerSpecForSession
implements Cloneable {
    private String defaultLoResType;
    private Hashtable viewableItemHash = new Hashtable();
    private String project;

    public String getProject() {
        return this.project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getArchiveLocation() {
        return ArchivePathManager.GetInstance().getArchivePathLocation(this.project);
    }

    public String getCacheLocation() {
        return ArchivePathManager.GetInstance().getCachePathLocation(this.project, null);
    }

    public String getLoResArchiveLocation(String sessionId) {
        return ArchivePathManager.GetInstance().getLoResLocation(this.project, sessionId);
    }

    public String getThumbnailArchiveLocation() {
        return ArchivePathManager.GetInstance().getThumbnailLocation(this.project);
    }

    public Hashtable getViewableItemHash() {
        return this.viewableItemHash;
    }

    public void setViewableItemHash(Hashtable hashtable) {
        this.viewableItemHash = hashtable;
    }

    public ViewableItem getViewableItem(String type) {
        ViewableItem rtn = (ViewableItem)this.viewableItemHash.get(type);
        if (rtn == null) {
            rtn = new ViewableItem();
        }
        return rtn;
    }

    public void addViewableItem(ViewableItem v) {
        this.viewableItemHash.put(v.getType(), v);
    }

    public Vector getDropDownItems(String type) {
        Vector<String> rtn = new Vector<String>();
        ViewableItem v = this.getViewableItem(type);
        Vector linkedVItems = v.getUserInterface().getLinkedDropDownList();
        for (int i = 0; i < linkedVItems.size(); ++i) {
            String vtype = ((LinkedDropDown)linkedVItems.elementAt(i)).getViewableItemType();
            ViewableItem vi = this.getViewableItem(vtype);
            rtn.add(i, vi.getUserInterface().getDisplayText());
        }
        return rtn;
    }

    public String getDefaultLoResType() {
        return this.defaultLoResType;
    }

    public int getNextAvailableSelectionPriority() {
        int rtn = -1;
        Enumeration keys = this.viewableItemHash.keys();
        while (keys.hasMoreElements()) {
            String viType = (String)keys.nextElement();
            ViewableItem vi = (ViewableItem)this.viewableItemHash.get(viType);
            if (vi == null || !vi.isWrapper() || vi.getUserInterface() == null || vi.getUserInterface().getSelectionPriority() <= rtn) continue;
            rtn = vi.getUserInterface().getSelectionPriority();
        }
        rtn = rtn == -1 ? 1000 : ++rtn;
        return rtn;
    }

    public void setDefaultLoResType(String string) {
        this.defaultLoResType = string;
    }

    public Object clone() {
        try {
            PlexiViewerSpecForSession deepClone = (PlexiViewerSpecForSession)super.clone();
            if (this.viewableItemHash == null) {
                deepClone.setViewableItemHash(null);
            } else {
                Enumeration enumerator = this.viewableItemHash.keys();
                while (enumerator.hasMoreElements()) {
                    String key = (String)enumerator.nextElement();
                    ViewableItem value = (ViewableItem)this.viewableItemHash.get(key);
                    deepClone.addViewableItem(value);
                }
            }
            return deepClone;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

