/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.manager;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.nrg.plexiViewer.exceptions.LayoutNotFoundException;
import org.nrg.plexiViewer.lite.xml.Layout;
import org.nrg.plexiViewer.lite.xml.PlexiViewerSpecDoc;
import org.nrg.plexiViewer.lite.xml.PlexiViewerSpecForSession;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.plexiViewer.manager.Populate;
import org.nrg.xdat.XDATTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PlexiSpecDocReader {
    private PlexiViewerSpecDoc viewerSpecDoc;
    private Hashtable layoutHash = new Hashtable();
    private static PlexiSpecDocReader DR = null;
    private Document doc;

    private PlexiSpecDocReader() {
        this.viewerSpecDoc = new PlexiViewerSpecDoc();
        this.loadImageViewerInfo();
    }

    public boolean refresh() {
        this.viewerSpecDoc = new PlexiViewerSpecDoc();
        return this.loadImageViewerInfo();
    }

    public boolean loadImageViewerInfo() {
        boolean success = true;
        try {
            String settingsDir = XDATTool.GetSettingsDirectory();
            String plexiImageSpecDoc = "PlexiViewerSpec.xml";
            String fileLocation = settingsDir + File.separator + plexiImageSpecDoc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(new File(fileLocation));
            Element rootElement = this.doc.getDocumentElement();
            NodeList elements = rootElement.getChildNodes();
            for (int i = 0; i < elements.getLength(); ++i) {
                if (!elements.item(i).getNodeName().equalsIgnoreCase("PlexiViewer")) continue;
                this.loadImageViewerInfo(elements.item(i));
            }
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            success = false;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            success = false;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            success = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            success = false;
        }
        return success;
    }

    public void loadImageViewerInfo(Node plexiViewerNode) throws Exception {
        PlexiViewerSpecForSession plexiViewerSpecDoc = new PlexiViewerSpecForSession();
        Populate populateFromXML = new Populate();
        try {
            NodeList elements = plexiViewerNode.getChildNodes();
            for (int i = 0; i < elements.getLength(); ++i) {
                if (elements.item(i).getNodeName().equalsIgnoreCase("DefaultLoResType")) {
                    plexiViewerSpecDoc.setDefaultLoResType(elements.item(i).getFirstChild().getNodeValue());
                    continue;
                }
                if (elements.item(i).getNodeName().equalsIgnoreCase("Layout")) {
                    Layout layout = populateFromXML.FillLayout(elements.item(i));
                    this.layoutHash.put(layout.getName(), layout);
                    continue;
                }
                if (!elements.item(i).getNodeName().equalsIgnoreCase("ViewableItem")) continue;
                ViewableItem v = populateFromXML.FillViewableItem(elements.item(i));
                plexiViewerSpecDoc.addViewableItem(v);
            }
            try {
                this.setupLayout(plexiViewerSpecDoc);
            }
            catch (LayoutNotFoundException lnfe) {
                lnfe.printStackTrace();
            }
            String[] sessionTypes = plexiViewerNode.getAttributes().getNamedItem("sessionType").getNodeValue().split(",");
            for (int i = 0; i < sessionTypes.length; ++i) {
                this.viewerSpecDoc.setViewerSpecification(sessionTypes[i].trim(), plexiViewerSpecDoc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PlexiSpecDocReader GetInstance() {
        if (DR == null) {
            DR = new PlexiSpecDocReader();
        }
        return DR;
    }

    public PlexiViewerSpecDoc getSpecDoc() {
        return this.viewerSpecDoc;
    }

    public PlexiViewerSpecForSession getSpecDoc(String project) {
        return this.viewerSpecDoc.getPlexiViewerSpecForSession(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecDoc(String project, PlexiViewerSpecForSession projectSpec) throws LayoutNotFoundException {
        PlexiViewerSpecDoc plexiViewerSpecDoc = this.viewerSpecDoc;
        synchronized (plexiViewerSpecDoc) {
            this.setupLayout(projectSpec);
            this.viewerSpecDoc.setViewerSpecification(project, projectSpec);
        }
    }

    public void setupLayout(PlexiViewerSpecForSession plexiViewerSpecDoc) throws LayoutNotFoundException {
        if (plexiViewerSpecDoc != null && !plexiViewerSpecDoc.getViewableItemHash().isEmpty()) {
            Enumeration e = plexiViewerSpecDoc.getViewableItemHash().keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                ViewableItem v = (ViewableItem)plexiViewerSpecDoc.getViewableItemHash().get(key);
                if (v.getHiRes() == null) continue;
                String lname = v.getHiRes().getLayoutName();
                if (this.layoutHash.containsKey(lname)) {
                    v.getHiRes().setLayout((Layout)this.layoutHash.get(v.getHiRes().getLayoutName()));
                    continue;
                }
                throw new LayoutNotFoundException("Didnt find the Layout " + v.getHiRes().getLayoutName());
            }
        } else {
            System.out.println("Error PlexiViewerDocInfo is null");
        }
    }

    public static void main(String[] args) {
        PlexiViewerSpecDoc vd = PlexiSpecDocReader.GetInstance().getSpecDoc();
        System.out.println("Read the doc ");
        PlexiViewerSpecForSession specDoc = PlexiSpecDocReader.GetInstance().getSpecDoc("GenPIB");
        System.out.println("CachePath is " + specDoc.getCacheLocation());
    }
}

