/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.manager;

import java.awt.Rectangle;
import java.util.Hashtable;
import java.util.Vector;
import org.nrg.plexiViewer.lite.display.Point3d;
import org.nrg.plexiViewer.lite.xml.CropDetails;
import org.nrg.plexiViewer.lite.xml.HiRes;
import org.nrg.plexiViewer.lite.xml.Layout;
import org.nrg.plexiViewer.lite.xml.LinkedDropDown;
import org.nrg.plexiViewer.lite.xml.LoRes;
import org.nrg.plexiViewer.lite.xml.MontageView;
import org.nrg.plexiViewer.lite.xml.SchemaLink;
import org.nrg.plexiViewer.lite.xml.Thumbnail;
import org.nrg.plexiViewer.lite.xml.UserInterface;
import org.nrg.plexiViewer.lite.xml.ViewableItem;
import org.nrg.xft.utils.XMLUtils;
import org.w3c.dom.Node;

public class Populate {
    public Layout FillLayout(Node layoutNode) {
        Layout layout = new Layout();
        layout.setName(layoutNode.getAttributes().getNamedItem("name").getNodeValue());
        layout.setVoxelSize(Integer.parseInt(layoutNode.getAttributes().getNamedItem("voxelSize").getNodeValue()));
        for (int k = 0; k < layoutNode.getChildNodes().getLength(); ++k) {
            if (!layoutNode.getChildNodes().item(k).getNodeName().equalsIgnoreCase("Coordinates")) continue;
            Node coordinatesNode = layoutNode.getChildNodes().item(k);
            float oX = Float.parseFloat(coordinatesNode.getAttributes().getNamedItem("originX").getNodeValue());
            float oY = Float.parseFloat(coordinatesNode.getAttributes().getNamedItem("originY").getNodeValue());
            float oZ = Float.parseFloat(coordinatesNode.getAttributes().getNamedItem("originZ").getNodeValue());
            layout.setOrigin(new Point3d(oX, oY, oZ));
        }
        return layout;
    }

    public ViewableItem FillViewableItem(Node vNode) {
        ViewableItem vi = new ViewableItem();
        vi.setType(vNode.getAttributes().getNamedItem("type").getNodeValue());
        if (XMLUtils.HasAttribute((Node)vNode, (String)"imageViewerClassName")) {
            vi.setImageViewerClassName(vNode.getAttributes().getNamedItem("imageViewerClassName").getNodeValue());
        }
        if (XMLUtils.HasAttribute((Node)vNode, (String)"displayCondition")) {
            vi.setDisplayCondition(vNode.getAttributes().getNamedItem("displayCondition").getNodeValue());
        }
        for (int j = 0; j < vNode.getChildNodes().getLength(); ++j) {
            if (vNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("SchemaLink")) {
                Node sNode = vNode.getChildNodes().item(j);
                SchemaLink sl = this.FillSchemaLink(sNode);
                vi.setSchemaLink(sl);
                continue;
            }
            if (vNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("UserInterface")) {
                Node uNode = vNode.getChildNodes().item(j);
                UserInterface u = this.FillUserInterface(uNode);
                vi.setUserInterface(u);
                continue;
            }
            if (vNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("Thumbnail")) {
                Node tNode = vNode.getChildNodes().item(j);
                Thumbnail tbnail = this.FillThumbNail(tNode);
                vi.setThumbnail(tbnail);
                continue;
            }
            if (vNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("Hi-Res")) {
                Node hResNode = vNode.getChildNodes().item(j);
                HiRes hRes = this.FillHiRes(hResNode);
                vi.setHiRes(hRes);
                continue;
            }
            if (!vNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("Lo-Res")) continue;
            Node lResNode = vNode.getChildNodes().item(j);
            LoRes lRes = this.FillLoRes(lResNode);
            vi.addToLoResHash(lRes);
        }
        return vi;
    }

    private SchemaLink FillSchemaLink(Node sNode) {
        SchemaLink s = new SchemaLink();
        if (XMLUtils.HasAttribute((Node)sNode, (String)"element")) {
            s.setElementName(sNode.getAttributes().getNamedItem("element").getNodeValue());
        }
        if (XMLUtils.HasAttribute((Node)sNode, (String)"value")) {
            s.setValue(sNode.getAttributes().getNamedItem("value").getNodeValue());
        }
        return s;
    }

    private UserInterface FillUserInterface(Node uNode) {
        UserInterface u = new UserInterface();
        if (XMLUtils.HasAttribute((Node)uNode, (String)"selectionPriority")) {
            u.setSelectionPriority(Integer.parseInt(uNode.getAttributes().getNamedItem("selectionPriority").getNodeValue()));
        }
        if (XMLUtils.HasAttribute((Node)uNode, (String)"displayText")) {
            u.setDisplayText(uNode.getAttributes().getNamedItem("displayText").getNodeValue());
        }
        if (XMLUtils.HasAttribute((Node)uNode, (String)"allowedToChooseFiles")) {
            u.setAllowedToChooseFiles(Boolean.valueOf(uNode.getAttributes().getNamedItem("allowedToChooseFiles").getNodeValue()));
        }
        if (XMLUtils.HasAttribute((Node)uNode, (String)"allowedToChooseID")) {
            u.setAllowedToChooseIds(Boolean.valueOf(uNode.getAttributes().getNamedItem("allowedToChooseID").getNodeValue()));
        }
        for (int j = 0; j < uNode.getChildNodes().getLength(); ++j) {
            if (!uNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("LinkedDropDown")) continue;
            Node lNode = uNode.getChildNodes().item(j);
            LinkedDropDown l = this.FillLinkedDropDown(lNode);
            u.addToLinkedDropDown(l);
        }
        return u;
    }

    private LinkedDropDown FillLinkedDropDown(Node lNode) {
        LinkedDropDown l = new LinkedDropDown();
        if (XMLUtils.HasAttribute((Node)lNode, (String)"viewableItemType")) {
            l.setViewableItemType(lNode.getAttributes().getNamedItem("viewableItemType").getNodeValue());
        }
        return l;
    }

    private HiRes FillHiRes(Node hResNode) {
        HiRes hRes = new HiRes();
        int location = 0;
        hRes.setFormat(hResNode.getAttributes().getNamedItem("format").getNodeValue());
        if (XMLUtils.HasAttribute((Node)hResNode, (String)"minIntensity")) {
            hRes.setMinIntensity(new Float(Float.parseFloat(hResNode.getAttributes().getNamedItem("minIntensity").getNodeValue())));
        }
        if (XMLUtils.HasAttribute((Node)hResNode, (String)"maxIntensity")) {
            hRes.setMaxIntensity(new Float(Float.parseFloat(hResNode.getAttributes().getNamedItem("maxIntensity").getNodeValue())));
        }
        for (int j = 0; j < hResNode.getChildNodes().getLength(); ++j) {
            if (hResNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("Layer")) {
                Node iNode = hResNode.getChildNodes().item(j);
                if (XMLUtils.HasAttribute((Node)iNode, (String)"num")) {
                    location = Integer.parseInt(iNode.getAttributes().getNamedItem("num").getNodeValue());
                }
                SchemaLink s = this.FillSchemaLink(iNode);
                hRes.setLayer(new Integer(location), s);
                continue;
            }
            if (hResNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("LayoutRef")) {
                hRes.setLayoutName(hResNode.getChildNodes().item(j).getAttributes().getNamedItem("name").getNodeValue());
                continue;
            }
            if (!hResNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("MontageView")) continue;
            Node mvNode = hResNode.getChildNodes().item(j);
            hRes.setMontageView(this.FillMontageView(mvNode));
        }
        return hRes;
    }

    private LoRes FillLoRes(Node lResNode) {
        LoRes lRes = new LoRes();
        lRes.setFormat(lResNode.getAttributes().getNamedItem("format").getNodeValue());
        lRes.setConverterClassName(lResNode.getAttributes().getNamedItem("converterClassName").getNodeValue());
        lRes.setType(lResNode.getAttributes().getNamedItem("type").getNodeValue());
        for (int j = 0; j < lResNode.getChildNodes().getLength(); ++j) {
            if (lResNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("CropDetails")) {
                Node cdNode = lResNode.getChildNodes().item(j);
                lRes.setCropDetails(this.FillCropDetails(cdNode));
                continue;
            }
            if (lResNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("MontageView")) {
                Node mvNode = lResNode.getChildNodes().item(j);
                lRes.setMontageView(this.FillMontageView(mvNode));
                continue;
            }
            if (!lResNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("Parameter")) continue;
            Node pNode = lResNode.getChildNodes().item(j);
            String attrib = pNode.getAttributes().getNamedItem("attribute").getNodeValue();
            String value = pNode.getAttributes().getNamedItem("value").getNodeValue();
            lRes.setParameter(attrib, value);
        }
        return lRes;
    }

    private Thumbnail FillThumbNail(Node tNode) {
        Thumbnail tbnail = new Thumbnail();
        tbnail.setFormat(tNode.getAttributes().getNamedItem("format").getNodeValue());
        tbnail.setConverterClassName(tNode.getAttributes().getNamedItem("converterClassName").getNodeValue());
        Hashtable<String, Vector> sliceInfo = new Hashtable<String, Vector>();
        for (int j = 0; j < tNode.getChildNodes().getLength(); ++j) {
            Vector v;
            Node sNode;
            if (tNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("CropDetails")) {
                Node cdNode = tNode.getChildNodes().item(j);
                tbnail.setCropDetails(this.FillCropDetails(cdNode));
                continue;
            }
            if (!tNode.getChildNodes().item(j).getNodeName().equalsIgnoreCase("Slice") || !XMLUtils.HasAttribute((Node)(sNode = tNode.getChildNodes().item(j)), (String)"orientation") || !XMLUtils.HasAttribute((Node)sNode, (String)"number")) continue;
            String key = sNode.getAttributes().getNamedItem("orientation").getNodeValue().toUpperCase();
            Integer value = Integer.valueOf(sNode.getAttributes().getNamedItem("number").getNodeValue());
            if (sliceInfo.containsKey(key)) {
                v = (Vector)sliceInfo.get(key);
                v.add(value);
                continue;
            }
            v = new Vector();
            v.addElement(value);
            sliceInfo.put(key, v);
        }
        tbnail.setSlices(sliceInfo);
        return tbnail;
    }

    private CropDetails FillCropDetails(Node cdNode) {
        CropDetails cd = new CropDetails();
        if (XMLUtils.HasAttribute((Node)cdNode, (String)"startSlice")) {
            cd.setStartSlice(Integer.parseInt(cdNode.getAttributes().getNamedItem("startSlice").getNodeValue()));
        }
        if (XMLUtils.HasAttribute((Node)cdNode, (String)"endSlice")) {
            cd.setEndSlice(Integer.parseInt(cdNode.getAttributes().getNamedItem("endSlice").getNodeValue()));
        }
        Rectangle bounds = new Rectangle();
        bounds.x = Integer.parseInt(cdNode.getAttributes().getNamedItem("X").getNodeValue());
        bounds.y = Integer.parseInt(cdNode.getAttributes().getNamedItem("Y").getNodeValue());
        bounds.width = Integer.parseInt(cdNode.getAttributes().getNamedItem("width").getNodeValue());
        bounds.height = Integer.parseInt(cdNode.getAttributes().getNamedItem("height").getNodeValue());
        cd.setBoundingRectangle(bounds);
        return cd;
    }

    private MontageView FillMontageView(Node mvNode) {
        MontageView mv = new MontageView();
        if (XMLUtils.HasAttribute((Node)mvNode, (String)"scale")) {
            mv.setScale(Float.parseFloat(mvNode.getAttributes().getNamedItem("scale").getNodeValue()));
        }
        for (int i = 0; i < mvNode.getChildNodes().getLength(); ++i) {
            Node childNode;
            if (mvNode.getChildNodes().item(i).getNodeName().equalsIgnoreCase("transverse")) {
                childNode = mvNode.getChildNodes().item(i);
                mv.addViewInfo("TRANSVERSE", this.getMvStartSlice(childNode), this.getMvEndSlice(childNode), this.getMvSliceSpacing(childNode));
                continue;
            }
            if (mvNode.getChildNodes().item(i).getNodeName().equalsIgnoreCase("sagittal")) {
                childNode = mvNode.getChildNodes().item(i);
                mv.addViewInfo("SAGITTAL", this.getMvStartSlice(childNode), this.getMvEndSlice(childNode), this.getMvSliceSpacing(childNode));
                continue;
            }
            if (!mvNode.getChildNodes().item(i).getNodeName().equalsIgnoreCase("coronal")) continue;
            childNode = mvNode.getChildNodes().item(i);
            mv.addViewInfo("CORONAL", this.getMvStartSlice(childNode), this.getMvEndSlice(childNode), this.getMvSliceSpacing(childNode));
        }
        return mv;
    }

    private int getMvStartSlice(Node node) {
        return Integer.parseInt(node.getAttributes().getNamedItem("start_slice").getNodeValue());
    }

    private int getMvEndSlice(Node node) {
        return Integer.parseInt(node.getAttributes().getNamedItem("end_slice").getNodeValue());
    }

    private int getMvSliceSpacing(Node node) {
        return Integer.parseInt(node.getAttributes().getNamedItem("slice_spacing").getNodeValue());
    }
}

