/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.nrg.xdat.bean.ArcArchivespecificationBean;
import org.nrg.xdat.bean.ArcPathinfoBean;
import org.nrg.xdat.bean.ArcProjectBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;
import org.nrg.xft.XFTItem;
import org.nrg.xft.collections.ItemCollection;
import org.nrg.xft.search.ItemSearch;

public class ArchivePathManager {
    private static ArchivePathManager self;
    private static ArcArchivespecificationBean archiveSpecification;
    private static final String elementName = "arc:ArchiveSpecification";
    private static long lastAccess;
    private static final long lastAccessCheckDuration = 600000L;
    private static Logger logger;
    public static final String LORES_SUBFOLDER_NAME = "LORES";
    public static final String THUMBNAIL_SUBFOLDER_NAME = "THUMB";

    private ArchivePathManager() {
    }

    public static ArchivePathManager GetInstance() {
        if (self == null) {
            self = new ArchivePathManager();
        }
        ArchivePathManager.refresh();
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refresh() {
        if (lastAccess == 0L || ArchivePathManager.needsUpdate()) {
            try {
                archiveSpecification = new ArcArchivespecificationBean();
                ItemCollection ic = ItemSearch.GetAllItems((String)elementName, null, (boolean)true);
                ArrayList list = ic.getItems();
                XFTItem arcSpecItem = (XFTItem)list.get(0);
                XDATXMLReader xdatXmlReader = new XDATXMLReader();
                BaseElement baseElement = xdatXmlReader.parse((InputStream)new ByteArrayInputStream(arcSpecItem.toXML_BOS(null).toByteArray()));
                ArcArchivespecificationBean arcArchivespecificationBean = archiveSpecification;
                synchronized (arcArchivespecificationBean) {
                    archiveSpecification = (ArcArchivespecificationBean)baseElement;
                }
                list = null;
                arcSpecItem = null;
                lastAccess = Calendar.getInstance().getTimeInMillis();
            }
            catch (Exception e) {
                archiveSpecification = null;
                e.printStackTrace();
                logger.debug((Object)e);
            }
        }
    }

    private static boolean needsUpdate() {
        boolean rtn = false;
        long now = Calendar.getInstance().getTimeInMillis();
        if (now - lastAccess > 600000L) {
            rtn = true;
        }
        return rtn;
    }

    public String getArchivePathLocation(String projectId) {
        String path = null;
        if (archiveSpecification != null) {
            ArcPathinfoBean pathInfo;
            List projects = archiveSpecification.getProjects_project();
            for (int i = 0; i < projects.size(); ++i) {
                ArcProjectBean project = (ArcProjectBean)projects.get(i);
                if (!project.getId().equals(projectId)) continue;
                ArcPathinfoBean pathInfo2 = project.getPaths();
                if (pathInfo2 == null) break;
                path = pathInfo2.getArchivepath();
                break;
            }
            if ((path == null || path.trim().equals("")) && (pathInfo = archiveSpecification.getGlobalpaths()) != null) {
                path = pathInfo.getArchivepath();
            }
            if (path == null) {
                path = ".";
            }
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
        }
        return path;
    }

    public String getLoResLocation(String projectId, String sessionId) {
        String cpath = this.getCachePathLocation(projectId, sessionId);
        return cpath;
    }

    public String getThumbnailLocation(String projectId) {
        return this.getCachePathLocation(projectId, null) + THUMBNAIL_SUBFOLDER_NAME;
    }

    public String getCachePathLocation(String projectId, String sessionId) {
        String path = null;
        if (archiveSpecification != null) {
            ArcPathinfoBean pathInfo;
            List projects = archiveSpecification.getProjects_project();
            for (int i = 0; i < projects.size(); ++i) {
                ArcProjectBean project = (ArcProjectBean)projects.get(i);
                if (!project.getId().equals(projectId)) continue;
                ArcPathinfoBean pathInfo2 = project.getPaths();
                if (pathInfo2 == null) break;
                path = pathInfo2.getCachepath();
                break;
            }
            if ((path == null || path.trim().equals("")) && (pathInfo = archiveSpecification.getGlobalpaths()) != null) {
                path = pathInfo.getCachepath();
            }
            if (path == null) {
                path = ".";
            }
            if (!(path = path.replace('\\', '/')).endsWith("/")) {
                path = path + "/";
            }
        }
        if (sessionId != null) {
            path = path + sessionId;
        }
        return path;
    }

    static {
        lastAccess = 0L;
        logger = Logger.getLogger(ArchivePathManager.class);
    }
}

