/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.lite.xml.SchemaLink;
import org.nrg.plexiViewer.manager.PlexiSpecDocReader;
import org.nrg.plexiViewer.utils.ArchivePathManager;
import org.nrg.plexiViewer.utils.URIUtils;
import org.nrg.plexiViewer.utils.XFTUtils;
import org.nrg.xdat.bean.XnatAbstractresourceBean;
import org.nrg.xdat.bean.XnatDicomseriesBean;
import org.nrg.xdat.bean.XnatDicomseriesImageBean;
import org.nrg.xdat.bean.XnatImageresourceBean;
import org.nrg.xdat.bean.XnatImageresourceseriesBean;
import org.nrg.xdat.bean.XnatImagescandataBean;
import org.nrg.xdat.bean.XnatImagesessiondataBean;
import org.nrg.xdat.bean.XnatResourcecatalogBean;
import org.nrg.xdat.bean.base.BaseElement;
import org.nrg.xdat.bean.reader.XDATXMLReader;
import org.nrg.xft.XFTItem;
import org.nrg.xft.collections.ItemCollection;
import org.nrg.xft.exception.FieldNotFoundException;
import org.nrg.xft.search.CriteriaCollection;
import org.nrg.xft.search.ItemSearch;

public class FileUtils {
    public static String getTempFolder() {
        String rtn = System.getProperty("plexi.tmp");
        if (rtn == null) {
            rtn = System.getProperty("user.home");
        }
        return rtn;
    }

    public static URI ResolveURIAgainstArchivePath(String project, String fileUriStr) throws URISyntaxException {
        URI fileUri = new URI(fileUriStr.replace("\\", "/"));
        return FileUtils.ResolveURIAgainstArchivePath(project, fileUri);
    }

    public static boolean deleteFile(LocalFile f) {
        if (f == null) {
            return false;
        }
        System.out.println("Deleting file " + f.getAbsolutePath());
        return FileUtils.recursiveDelete((GeneralFile)f);
    }

    public static boolean deleteFile(LocalFile f, boolean safeDelete) {
        if (f == null) {
            return false;
        }
        System.out.println("Deleting file " + f.getAbsolutePath());
        return FileUtils.recursiveDelete((GeneralFile)f);
    }

    public static boolean deleteFile(File f) {
        return FileUtils.recursiveDelete(f);
    }

    public static boolean deleteFile(File f, boolean safeDelete) {
        if (safeDelete) {
            String temp = FileUtils.getTempFolder();
            File tempFolder = new File(temp);
            if (f.getPath().startsWith(tempFolder.getPath())) {
                return FileUtils.recursiveDelete(f);
            }
            return false;
        }
        return FileUtils.recursiveDelete(f);
    }

    private static boolean recursiveDelete(GeneralFile file) {
        GeneralFile[] fileList;
        if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                FileUtils.recursiveDelete(fileList[i]);
            }
        }
        return file.delete();
    }

    private static boolean recursiveDelete(File file) {
        File[] fileList;
        if (file.isDirectory() && (fileList = file.listFiles()) != null) {
            for (int i = 0; i < fileList.length; ++i) {
                FileUtils.recursiveDelete(fileList[i]);
            }
        }
        return file.delete();
    }

    public static boolean deleteFile(String path) {
        return FileUtils.deleteFile(new File(path));
    }

    public static boolean deleteFile(String path, boolean safeDelete) {
        return FileUtils.deleteFile(new File(path), safeDelete);
    }

    public static boolean deleteFile(ArrayList files) {
        int i;
        boolean rtn = true;
        String path = null;
        for (i = 0; i < files.size(); ++i) {
            if (path == null) {
                path = ((File)files.get(i)).getParent();
            }
            if (!((File)files.get(i)).delete()) break;
        }
        if (i < files.size()) {
            rtn = false;
        }
        if (rtn) {
            new File(path).delete();
        }
        return rtn;
    }

    public static URI ResolveURIAgainstCachePath(String projectPath, String fileUriStr) throws URISyntaxException {
        URI fileUri = new URI(fileUriStr.replace("\\", "/"));
        return FileUtils.ResolveURIAgainstCachePath(projectPath, fileUri);
    }

    public static URI ResolveURIAgainstArchivePath(String projectPath, URI fileUri) throws URISyntaxException {
        URI base = URIUtils.getURI(projectPath.replace("\\", "/"));
        URI rtn = base.resolve(fileUri);
        return rtn;
    }

    public static URI ResolveURIAgainstCachePath(String projectPath, URI fileUri) throws URISyntaxException {
        URI base = URIUtils.getURI(projectPath.replace("\\", "/"));
        URI rtn = base.resolve(fileUri);
        return rtn;
    }

    public static PlexiImageFile fileExists(PlexiImageFile pf) {
        boolean rtn = false;
        rtn = FileUtils.fileExists(pf.getPath(), pf.getName());
        if (rtn) {
            return pf;
        }
        rtn = FileUtils.fileExists(pf.getCachePath(), pf.getName());
        if (rtn) {
            pf.setPath(pf.getCachePath());
            return pf;
        }
        int indexOfDot = pf.getName().indexOf(".");
        if (indexOfDot != -1) {
            pf.setName(pf.getName().substring(0, indexOfDot) + ".4dfp.img");
            rtn = FileUtils.fileExists(pf.getCachePath(), pf.getName());
            if (rtn) {
                pf.setPath(pf.getCachePath());
                return pf;
            }
            rtn = FileUtils.fileExists(pf.getPath(), pf.getName());
            if (rtn) {
                return pf;
            }
            return null;
        }
        return null;
    }

    public static boolean fileExists(String path, String fileName) {
        File fileOrDir;
        if (path == null && fileName == null) {
            return false;
        }
        String uri = path;
        uri = !uri.endsWith(File.separator) ? uri + File.separator + fileName : uri + fileName;
        URI u = null;
        try {
            u = new URI(uri);
        }
        catch (Exception e) {
            u = null;
            File f = new File(uri);
            u = f.toURI();
        }
        if (u != null) {
            fileOrDir = null;
            try {
                fileOrDir = new File(u);
            }
            catch (Exception e) {
                System.out.println("FileUtils::fileExists Invalid URI " + uri);
            }
            if (fileOrDir != null) {
                return fileOrDir.exists();
            }
        }
        try {
            fileOrDir = new File(uri);
            boolean rtn = fileOrDir.exists();
            return rtn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean createDirectory(String path) {
        boolean success = false;
        File dir = null;
        try {
            URI u = new URI(path);
            dir = new File(u);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dir == null) {
            dir = new File(path);
        }
        if (dir.exists() && dir.isDirectory()) {
            return true;
        }
        success = dir.mkdirs();
        return success;
    }

    public static boolean dirExists(String path) {
        boolean success = false;
        File dir = null;
        try {
            URI u = new URI(path);
            dir = new File(u);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dir == null) {
            dir = new File(path);
        }
        if (dir.exists() && dir.isDirectory()) {
            return true;
        }
        return success;
    }

    public static String getLoResFileName(String baseFileName, String loResType, String orientation) {
        String rtn = null;
        int indexOfDot = baseFileName.lastIndexOf(".");
        rtn = indexOfDot != -1 ? baseFileName.substring(0, indexOfDot) + "_" + loResType + "_" + orientation.substring(0, 3).toLowerCase().trim() + ".img" : baseFileName + "_" + loResType + "_" + orientation.substring(0, 3).toLowerCase().trim() + ".img";
        return rtn;
    }

    public static String getThumbnailFileName(String fromFileName, String orientation, int sliceNo) {
        String rtn = null;
        int indexOfDot = fromFileName.indexOf(".");
        rtn = indexOfDot == -1 ? fromFileName + "_" + orientation.substring(0, 3).toLowerCase() + "_" + sliceNo + ".gif" : fromFileName.substring(0, indexOfDot) + "_" + orientation.substring(0, 3).toLowerCase() + "_" + sliceNo + ".gif";
        return rtn;
    }

    public static PlexiImageFile getHiResFilePath(String sessionId, String sessionType, String viewableItemType, int layerNum, String scanNumber) {
        PlexiImageFile pf = null;
        SchemaLink s = (SchemaLink)PlexiSpecDocReader.GetInstance().getSpecDoc(sessionType).getViewableItem(viewableItemType).getHiRes().getLayersHash().get(new Integer(layerNum));
        try {
            ArrayList files = FileUtils.getFiles(s, sessionId, sessionType, scanNumber);
            pf = files != null && files.size() > 0 ? (PlexiImageFile)files.get(0) : FileUtils.getScanFile(sessionId, scanNumber);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pf;
    }

    private static PlexiImageFile getScanFile(String sessionId, String scanNumber) {
        PlexiImageFile pf;
        block18: {
            pf = null;
            try {
                List files;
                ItemCollection mrs = ItemSearch.GetItems((String)"xnat:imagesessionData.ID", (Object)sessionId, null, (boolean)false);
                XFTItem item = (XFTItem)mrs.getFirst();
                XDATXMLReader xdatXmlReader = new XDATXMLReader();
                BaseElement baseElement = xdatXmlReader.parse((InputStream)new ByteArrayInputStream(item.toXML_BOS(null).toByteArray()));
                XnatImagesessiondataBean imageSession = (XnatImagesessiondataBean)baseElement;
                List mrScans = imageSession.getScans_scan();
                XnatImagescandataBean mrScan = null;
                for (int i = 0; i < mrScans.size(); ++i) {
                    XnatImagescandataBean aScan = (XnatImagescandataBean)mrScans.get(i);
                    if (!aScan.getId().equals(scanNumber)) continue;
                    mrScan = aScan;
                    break;
                }
                if (mrScan == null || (files = mrScan.getFile()) == null || files.size() <= 0) break block18;
                if (files.size() == 1) {
                    XnatAbstractresourceBean abs = (XnatAbstractresourceBean)files.get(0);
                    if (abs instanceof XnatImageresourceBean) {
                        XnatImageresourceBean rsc = (XnatImageresourceBean)abs;
                        pf = FileUtils.getImageDetails(rsc, imageSession.getProject(), imageSession.getId());
                    } else if (abs instanceof XnatImageresourceseriesBean) {
                        XnatImageresourceseriesBean rsc = (XnatImageresourceseriesBean)abs;
                        pf = FileUtils.getImageDetails(rsc, imageSession.getProject(), imageSession.getId());
                    } else if (abs instanceof XnatDicomseriesBean) {
                        XnatDicomseriesBean rsc = (XnatDicomseriesBean)abs;
                        pf = FileUtils.getImageDetails(rsc, imageSession.getProject(), imageSession.getId(), mrScan.getId());
                    } else if (abs instanceof XnatResourcecatalogBean) {
                        XnatResourcecatalogBean rsc = (XnatResourcecatalogBean)abs;
                        pf = FileUtils.getImageDetails(rsc, imageSession.getProject(), imageSession.getId(), mrScan.getId());
                    }
                    break block18;
                }
                for (int i = 0; i < files.size(); ++i) {
                    XnatImageresourceBean rsc;
                    XnatAbstractresourceBean abs = (XnatAbstractresourceBean)files.get(i);
                    if (abs instanceof XnatImageresourceBean) {
                        rsc = (XnatImageresourceBean)abs;
                        if (!rsc.getContent().equalsIgnoreCase("RAW") && !rsc.getContent().equalsIgnoreCase(mrScan.getType() + "_RAW")) continue;
                        pf = FileUtils.getImageDetails(rsc, imageSession.getProject(), imageSession.getId());
                    } else if (abs instanceof XnatImageresourceseriesBean) {
                        rsc = (XnatImageresourceseriesBean)abs;
                        if (!rsc.getContent().equalsIgnoreCase("RAW") && !rsc.getContent().equalsIgnoreCase(mrScan.getType() + "_RAW")) continue;
                        pf = FileUtils.getImageDetails((XnatImageresourceseriesBean)rsc, imageSession.getProject(), imageSession.getId());
                    } else if (abs instanceof XnatDicomseriesBean) {
                        rsc = (XnatDicomseriesBean)abs;
                        if (!rsc.getContent().equalsIgnoreCase("RAW") && !rsc.getContent().equalsIgnoreCase(mrScan.getType() + "_RAW")) continue;
                        pf = FileUtils.getImageDetails((XnatDicomseriesBean)rsc, imageSession.getProject(), imageSession.getId(), mrScan.getId());
                    } else {
                        if (!(abs instanceof XnatResourcecatalogBean) || !(rsc = (XnatResourcecatalogBean)abs).getContent().equalsIgnoreCase("RAW") && !rsc.getContent().equalsIgnoreCase(mrScan.getType() + "_RAW")) continue;
                        pf = FileUtils.getImageDetails((XnatResourcecatalogBean)rsc, imageSession.getProject(), imageSession.getId(), mrScan.getId());
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pf;
    }

    private static PlexiImageFile getImageDetails(XnatImageresourceBean rsc, String project, String sessionId) throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        String archivePathLocation = ArchivePathManager.GetInstance().getArchivePathLocation(project);
        String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(project, sessionId);
        pf.setURIAsString(FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, rsc.getUri()).toString());
        pf.setXsiType("xnat:imageResource");
        pf.setFormat(rsc.getFormat());
        if (rsc.getCachepath() != null) {
            pf.setCachePath(FileUtils.ResolveURIAgainstCachePath(cachePathLocation, rsc.getCachepath()).toString());
        } else {
            pf.setCachePath(URIUtils.getURI(cachePathLocation + "/" + sessionId).toString());
        }
        if (rsc.getDimensions_x() != null && rsc.getDimensions_y() != null && rsc.getDimensions_z() != null) {
            pf.setDimensions(rsc.getDimensions_x(), rsc.getDimensions_y(), rsc.getDimensions_z());
        }
        if (rsc.getVoxelres_x() != null) {
            pf.setVoxelResX(rsc.getVoxelres_x().floatValue());
        }
        if (rsc.getVoxelres_y() != null) {
            pf.setVoxelResY(rsc.getVoxelres_y().floatValue());
        }
        if (rsc.getVoxelres_z() != null) {
            pf.setVoxelResZ(rsc.getVoxelres_z().floatValue());
        }
        if (rsc.getDimensions_volumes() == null) {
            pf.setVolumes(1);
        } else {
            pf.setVolumes(rsc.getDimensions_volumes());
        }
        return pf;
    }

    private static PlexiImageFile getImageDetails(XnatImageresourceseriesBean rsc, String project, String sessionId) throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        String archivePathLocation = ArchivePathManager.GetInstance().getArchivePathLocation(project);
        String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(project, sessionId);
        pf.setURIAsString(FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, rsc.getPath()).toString());
        pf.setPath(org.nrg.xft.utils.FileUtils.AppendRootPath((String)archivePathLocation, (String)rsc.getPath()));
        pf.setPattern(rsc.getPattern());
        pf.setFormat(rsc.getFormat());
        pf.setName(rsc.getName());
        pf.setXsiType("xnat:imageResourceSeries");
        if (rsc.getCachepath() != null) {
            pf.setCachePath(FileUtils.ResolveURIAgainstCachePath(cachePathLocation, rsc.getCachepath()).toString());
        } else {
            pf.setCachePath(URIUtils.getURI(cachePathLocation + "/" + sessionId).toString());
        }
        if (rsc.getDimensions_x() != null && rsc.getDimensions_y() != null && rsc.getDimensions_z() != null) {
            pf.setDimensions(rsc.getDimensions_x(), rsc.getDimensions_y(), rsc.getDimensions_z());
        }
        if (rsc.getVoxelres_x() != null) {
            pf.setVoxelResX(rsc.getVoxelres_x().floatValue());
        }
        if (rsc.getVoxelres_y() != null) {
            pf.setVoxelResY(rsc.getVoxelres_y().floatValue());
        }
        if (rsc.getVoxelres_z() != null) {
            pf.setVoxelResZ(rsc.getVoxelres_z().floatValue());
        }
        if (rsc.getDimensions_volumes() == null) {
            pf.setVolumes(1);
        } else {
            pf.setVolumes(rsc.getDimensions_volumes());
        }
        return pf;
    }

    private static PlexiImageFile getImageDetails(XnatDicomseriesBean rsc, String project, String sessionId, String scanNumber) throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        String archivePathLocation = ArchivePathManager.GetInstance().getArchivePathLocation(project);
        String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(project, sessionId);
        List imageSet = rsc.getImageset_image();
        for (int j = 0; j < imageSet.size(); ++j) {
            pf.addToFiles(FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, ((XnatDicomseriesImageBean)imageSet.get(j)).getUri()).toString());
        }
        pf.setXsiType("xnat:dicomSeries");
        pf.setFormat(rsc.getFormat());
        if (scanNumber != null) {
            pf.setName(sessionId + "_" + scanNumber);
        }
        if (rsc.getCachepath() != null) {
            pf.setCachePath(FileUtils.ResolveURIAgainstCachePath(cachePathLocation, rsc.getCachepath()).toString());
        } else {
            pf.setCachePath(URIUtils.getURI(cachePathLocation + "/" + sessionId).toString());
        }
        if (rsc.getDimensions_x() != null && rsc.getDimensions_y() != null && rsc.getDimensions_z() != null) {
            pf.setDimensions(rsc.getDimensions_x(), rsc.getDimensions_y(), rsc.getDimensions_z());
        }
        if (rsc.getVoxelres_x() != null) {
            pf.setVoxelResX(rsc.getVoxelres_x().floatValue());
        }
        if (rsc.getVoxelres_y() != null) {
            pf.setVoxelResY(rsc.getVoxelres_y().floatValue());
        }
        if (rsc.getVoxelres_z() != null) {
            pf.setVoxelResZ(rsc.getVoxelres_z().floatValue());
        }
        if (rsc.getDimensions_volumes() == null) {
            pf.setVolumes(1);
        } else {
            pf.setVolumes(rsc.getDimensions_volumes());
        }
        return pf;
    }

    private static PlexiImageFile getImageDetails(XnatResourcecatalogBean rsc, String project, String sessionId, String scanNumber) throws Exception {
        PlexiImageFile pf = new PlexiImageFile();
        String archivePathLocation = ArchivePathManager.GetInstance().getArchivePathLocation(project);
        String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(project, sessionId);
        String catalogPath = FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, rsc.getUri()).toString();
        pf.setResourceCatalogPath(catalogPath);
        pf.setFormat(rsc.getFormat());
        pf.setXsiType("xnat:resourceCatalog");
        if (scanNumber != null) {
            pf.setName(sessionId + "_" + scanNumber);
        }
        if (rsc.getCachepath() != null) {
            pf.setCachePath(FileUtils.ResolveURIAgainstCachePath(cachePathLocation, rsc.getCachepath()).toString());
        } else {
            pf.setCachePath(URIUtils.getURI(cachePathLocation + "/" + sessionId).toString());
        }
        return pf;
    }

    public static ArrayList parseFile(String pathToFile) {
        ArrayList<String> rtn = new ArrayList<String>();
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(pathToFile));
            while ((str = in.readLine()) != null) {
                rtn.add(str);
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println("Unable to read from file " + pathToFile);
        }
        return rtn;
    }

    public static ArrayList getFiles(SchemaLink s, String sessionId, String project, String scanNumber) {
        ArrayList<PlexiImageFile> rtn;
        block24: {
            rtn = null;
            try {
                ArrayList filesList;
                CriteriaCollection cc = new CriteriaCollection("AND");
                int elementNameIndex = s.getElementName().indexOf(".");
                System.out.println(sessionId + " " + scanNumber + " Files are required for " + s.toString());
                String elementName = s.getElementName().substring(0, elementNameIndex);
                cc.addClause(elementName + "." + XFTUtils.getSessionFieldName(elementName), (Object)sessionId);
                if (scanNumber != null && scanNumber != "" && elementName.equals(XFTUtils.getXMLPathToScan())) {
                    cc.addClause(elementName + ".ID", (Object)scanNumber);
                }
                String archivePathLocation = ArchivePathManager.GetInstance().getArchivePathLocation(project);
                String cachePathLocation = ArchivePathManager.GetInstance().getCachePathLocation(project, sessionId);
                ItemCollection ic = ItemSearch.GetItems((CriteriaCollection)cc, null, (boolean)true);
                ArrayList parentList = ic.getItems();
                if (parentList == null || (filesList = XFTUtils.getChildItems(parentList, s.getElementName(), s.getValue())) == null) break block24;
                rtn = new ArrayList<PlexiImageFile>();
                for (int i = 0; i < filesList.size(); ++i) {
                    XFTItem f = (XFTItem)filesList.get(i);
                    PlexiImageFile pf = new PlexiImageFile();
                    if (f.getXSIType().equals("xnat:imageResource")) {
                        pf.setURIAsString(FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, f.getStringProperty("URI")).toString());
                        pf.setXsiType("xnat:imageResource");
                        pf.setFormat(f.getStringProperty("format"));
                    } else if (f.getXSIType().equals("xnat:imageResourceSeries")) {
                        pf.setURIAsString(FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, f.getStringProperty("path")).toString());
                        pf.setPath(org.nrg.xft.utils.FileUtils.AppendRootPath((String)archivePathLocation, (String)f.getStringProperty("path")));
                        pf.setPattern(f.getStringProperty("pattern"));
                        pf.setName(f.getStringProperty("name"));
                        pf.setXsiType("xnat:imageResourceSeries");
                        pf.setFormat(f.getStringProperty("format"));
                    } else if (f.getXSIType().equals("xnat:dicomSeries")) {
                        ArrayList imageSet = f.getChildItems("xnat:dicomSeries.imageSet.image");
                        for (int j = 0; j < imageSet.size(); ++j) {
                            pf.addToFiles(FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, ((XFTItem)imageSet.get(j)).getStringProperty("URI")).toString());
                        }
                        pf.setXsiType("xnat:dicomSeries");
                        pf.setFormat(f.getStringProperty("format"));
                        if (scanNumber != null) {
                            pf.setName(sessionId + "_" + scanNumber);
                        }
                    } else if (f.getXSIType().equals("xnat:resourceCatalog")) {
                        String catalogPath = FileUtils.ResolveURIAgainstArchivePath(archivePathLocation, f.getStringProperty("URI")).toString();
                        pf.setResourceCatalogPath(catalogPath);
                        pf.setFormat(f.getStringProperty("format"));
                        pf.setXsiType("xnat:resourceCatalog");
                        if (scanNumber != null) {
                            pf.setName(sessionId + "_" + scanNumber);
                        }
                    }
                    if (f.getStringProperty("cachepath") != null) {
                        pf.setCachePath(FileUtils.ResolveURIAgainstCachePath(cachePathLocation, f.getStringProperty("cachepath")).toString());
                    } else {
                        pf.setCachePath(URIUtils.getURI(cachePathLocation + "/" + sessionId).toString());
                    }
                    try {
                        if (f.getIntegerProperty("dimensions.x") != null && f.getIntegerProperty("dimensions.y") != null && f.getIntegerProperty("dimensions.z") != null) {
                            pf.setDimensions(f.getIntegerProperty("dimensions.x"), f.getIntegerProperty("dimensions.y"), f.getIntegerProperty("dimensions.z"));
                        }
                        if (f.getStringProperty("voxelRes.x") != null) {
                            pf.setVoxelResX(Float.parseFloat(f.getStringProperty("voxelRes.x")));
                        }
                        if (f.getStringProperty("voxelRes.y") != null) {
                            pf.setVoxelResY(Float.parseFloat(f.getStringProperty("voxelRes.y")));
                        }
                        if (f.getStringProperty("voxelRes.z") != null) {
                            pf.setVoxelResZ(Float.parseFloat(f.getStringProperty("voxelRes.z")));
                        }
                        if (f.getIntegerProperty("dimensions.volumes") == null) {
                            pf.setVolumes(1);
                        } else {
                            pf.setVolumes(f.getIntegerProperty("dimensions.volumes"));
                        }
                    }
                    catch (FieldNotFoundException e) {
                        // empty catch block
                    }
                    System.out.println("FileUtils:: " + pf.toString());
                    rtn.add(pf);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return rtn;
    }

    public static ArrayList getFiles(SchemaLink s, String sessionId, String project) {
        ArrayList rtn = null;
        try {
            rtn = FileUtils.getFiles(s, sessionId, project, null);
        }
        catch (Exception e) {
            return null;
        }
        return rtn;
    }

    public static void main(String[] args) {
    }
}

