/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils;

import ij.ImagePlus;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedReader;
import java.io.FileReader;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;

public class LUTApplier {
    PlexiImageFile plexifile;
    String lkupfile;
    boolean radiologic;

    public LUTApplier(PlexiImageFile file, String lkupfile) {
        this.plexifile = file;
        this.lkupfile = lkupfile;
        this.radiologic = false;
    }

    public LUTApplier(String lkupfile) {
        this.lkupfile = lkupfile;
        this.radiologic = false;
    }

    public boolean isRadiologic() {
        return this.radiologic;
    }

    public void setRadiologic(boolean radiologic) {
        this.radiologic = radiologic;
    }

    public ImagePlus applyLUT(ImagePlus img) throws Exception {
        IndexColorModel cm = this.getColorModel();
        img.getProcessor().setColorModel((ColorModel)cm);
        if (img.getStackSize() > 1) {
            img.getStack().setColorModel((ColorModel)cm);
        }
        img.updateImage();
        return img;
    }

    public ImagePlus getImagePlus() throws Exception {
        ImagePlus baseimage = PlexiFileOpener.openBaseFile(this.plexifile, this.radiologic);
        IndexColorModel cm = this.getColorModel();
        baseimage.getProcessor().setColorModel((ColorModel)cm);
        if (baseimage.getStackSize() > 1) {
            baseimage.getStack().setColorModel((ColorModel)cm);
        }
        baseimage.updateImage();
        return baseimage;
    }

    private IndexColorModel getColorModel() throws Exception {
        int[][] rgb = this.readLkupFile();
        int size = rgb.length;
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        for (int i = 0; i < 256; ++i) {
            reds[i] = (byte)(rgb[i][0] & 0xFF);
            greens[i] = (byte)(rgb[i][1] & 0xFF);
            blues[i] = (byte)(rgb[i][2] & 0xFF);
        }
        return new IndexColorModel(8, 256, reds, greens, blues);
    }

    private int[][] readLkupFile() throws Exception {
        BufferedReader in = null;
        int[][] rgbs = new int[256][3];
        int[][] rtn = new int[256][3];
        try {
            String str;
            in = new BufferedReader(new FileReader(this.lkupfile));
            int lineCnt = 0;
            while ((str = in.readLine()) != null) {
                ++lineCnt;
                String[] rgb = str.split(" ");
                if (rgb.length != 3) {
                    throw new Exception("Inavlid file format expecting space separated three col input from " + this.lkupfile + " found " + str + " on line " + lineCnt);
                }
                for (int j = 0; j < 3; ++j) {
                    rgbs[lineCnt - 1][j] = Integer.parseInt(rgb[j]);
                }
            }
            if (lineCnt == 0) {
                throw new Exception("Incomplete file...expecting space separated three col input from " + this.lkupfile);
            }
            if (lineCnt < 256) {
                int bins = (int)Math.round(256.0 / (double)lineCnt);
                for (int i = 0; i < 256; ++i) {
                    int binRow = i / bins;
                    for (int j = 0; j < 3; ++j) {
                        rtn[i][j] = rgbs[binRow][j];
                    }
                }
            } else {
                rtn = rgbs;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return rtn;
    }
}

