/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import java.io.IOException;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.FileUtils;

public class ImaTo4dfpBuilder {
    PlexiImageFile pf;

    public ImaTo4dfpBuilder(PlexiImageFile pf) {
        this.pf = pf;
    }

    public boolean create() {
        boolean success = true;
        if (this.pf.getFormat() != null && this.pf.getFormat().equalsIgnoreCase("IMA")) {
            if (!this.exists4dfpVersionForIma()) {
                success = this.buildImaImage();
            }
            this.pf.setPath(this.pf.getCachePath());
            this.pf.setName(this.pf.getName() + ".4dfp.img");
            this.pf.setXsiType("plexi:imageResource");
            this.pf.setFormat("IFH");
            try {
                if (this.pf.getPath().endsWith("/")) {
                    this.pf.setURIAsString(this.pf.getPath() + this.pf.getName());
                } else {
                    this.pf.setURIAsString(this.pf.getPath() + "/" + this.pf.getName());
                }
            }
            catch (Exception e) {
                System.out.println("URI Exception " + this.pf.getPath() + " " + this.pf.getName());
            }
        }
        return success;
    }

    private boolean exists4dfpVersionForIma() {
        return FileUtils.fileExists(this.pf.getCachePath(), this.pf.getName() + ".4dfp.img");
    }

    private boolean buildImaImage() {
        String cachePath = this.pf.getCachePath();
        if (cachePath.startsWith("file:")) {
            cachePath = cachePath.substring(5);
        }
        String launchProcess = "arc-build-RawMprage -d " + this.pf.getPath() + " -f " + this.pf.getName() + " -o " + cachePath;
        System.out.println("Attempting to launch script..." + launchProcess);
        int rtnValue = 1;
        try {
            Process p = Runtime.getRuntime().exec(launchProcess);
            rtnValue = p.waitFor();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        System.out.println("Return value from process is " + rtnValue);
        if (rtnValue != 0) {
            System.out.println("Imato4dfpBuilder::Unable to build Ima launch script..." + launchProcess);
        }
        return rtnValue == 0;
    }
}

