/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import org.nrg.plexiViewer.io.PlexiFileOpener;
import org.nrg.plexiViewer.lite.io.PlexiImageFile;
import org.nrg.plexiViewer.utils.Transform.BitConverter;
import org.nrg.plexiViewer.utils.Transform.PlexiImageOrientor;

public class IntensitySetter {
    private ImagePlus image;
    private boolean reset;
    double min;
    double max;
    boolean RGBImage;
    static final int AUTO_THRESHOLD = 5000;
    int channels = 7;
    int autoThreshold = 0;
    double defaultMin = 0.0;
    double defaultMax = 255.0;

    public IntensitySetter(ImagePlus img, boolean reset) {
        this.image = img;
        int type = this.image.getType();
        this.RGBImage = type == 4;
        ImageProcessor ip = this.image.getProcessor();
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            this.image.resetDisplayRange();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
        } else {
            this.defaultMin = 0.0;
            this.defaultMax = 255.0;
        }
        this.min = Double.MAX_VALUE;
        this.max = Double.MIN_VALUE;
        this.reset = reset;
    }

    void setMinAndMax(ImagePlus imp, double min, double max) {
        if (this.channels != 7 && imp.getType() == 4) {
            imp.setDisplayRange(min, max, this.channels);
        } else {
            imp.setDisplayRange(min, max);
        }
    }

    public void autoAdjust(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask;
        int count;
        if (this.RGBImage) {
            ip.reset();
        }
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int limit = stats.pixelCount / 10;
        int[] histogram = stats.histogram;
        this.autoThreshold = this.autoThreshold < 10 ? 5000 : (this.autoThreshold /= 2);
        int threshold = stats.pixelCount / this.autoThreshold;
        int i = -1;
        boolean found = false;
        do {
            if ((count = histogram[++i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i < 255);
        int hmin = i;
        i = 256;
        do {
            if ((count = histogram[--i]) > limit) {
                count = 0;
            }
            boolean bl = found = count > threshold;
        } while (!found && i > 0);
        int hmax = i;
        Roi roi = imp.getRoi();
        if (hmax >= hmin) {
            if (this.RGBImage) {
                imp.killRoi();
            }
            this.min = stats.histMin + (double)hmin * stats.binSize;
            this.max = stats.histMin + (double)hmax * stats.binSize;
            if (this.min == this.max) {
                this.min = stats.min;
                this.max = stats.max;
            }
            this.setMinAndMax(imp, this.min, this.max);
            if (this.RGBImage && roi != null) {
                imp.setRoi(roi);
            }
        } else {
            this.reset(imp, ip);
            return;
        }
        if (roi != null && (mask = roi.getMask()) != null) {
            ip.reset(mask);
        }
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        if (this.RGBImage) {
            ip.reset();
        }
        if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            imp.resetDisplayRange();
            this.defaultMin = ip.getMin();
            this.defaultMax = ip.getMax();
        }
        this.min = this.defaultMin;
        this.max = this.defaultMax;
        this.setMinAndMax(imp, this.min, this.max);
        this.autoThreshold = 0;
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void setMinAndMax(ImagePlus imp, ImageProcessor ip) {
        this.min = ip.getMin();
        this.max = ip.getMax();
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        double minValue = cal.getCValue(this.min);
        double maxValue = cal.getCValue(this.max);
        minValue = cal.getRawValue(minValue);
        if ((maxValue = cal.getRawValue(maxValue)) >= minValue) {
            this.min = minValue;
            this.max = maxValue;
            this.setMinAndMax(imp, this.min, this.max);
            if (this.RGBImage) {
                this.doMasking(imp, ip);
            }
        }
    }

    public static void main(String[] args) {
        try {
            PlexiImageFile pf = new PlexiImageFile();
            pf.setURIAsString("file:/C:/data/archive/FTest2/arc001/061121_tc22923/PROCESSED/MPRAGE/T88_111/061121_tc22923_mpr_n2_111_t88_gfc.4dfp");
            pf.setXsiType("xnat:imageResource");
            PlexiFileOpener pfo = new PlexiFileOpener("ANALYZE", pf);
            ImageJ ij = IJ.getInstance();
            if (ij == null || !ij.quitting()) {
                new ImageJ().exitWhenQuitting(false);
                ij = IJ.getInstance();
                ij.setVisible(true);
            }
            ImagePlus img = pfo.getImagePlus();
            IntensitySetter i = new IntensitySetter(img, true);
            i.autoAdjust(img, img.getProcessor());
            PlexiImageOrientor pio = new PlexiImageOrientor(img, pf.getFormat());
            ImagePlus img1 = pio.getImage(pfo.getOrientation(), "CORONALF");
            BitConverter converter = new BitConverter();
            converter.convertToGrayscale(img1);
            img1.show();
            System.out.println(img.getProcessor().getMin() + "   " + img.getProcessor().getMax());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

