/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import org.nrg.plexiViewer.utils.Transform.plexiViewerImageRelayer;

public class PlexiImageOrientor {
    private int width;
    private int height;
    private int stackSize;
    private ImagePlus inImg;
    private int owidth;
    private int oheight;
    private int oStackSize;
    private String format;
    public static final String AS_ACQUIRED_TXT = "As Acquired    ";
    public static final String AS_ACQUIRED = "ASACQUIRED";
    public static final String AS_ACQUIRED_ORIENTATION = "as acquired";

    public PlexiImageOrientor(ImagePlus inImg) {
        this.inImg = inImg;
        this.width = inImg.getWidth();
        this.height = inImg.getHeight();
        this.stackSize = inImg.getStackSize();
        this.format = null;
    }

    public PlexiImageOrientor(ImagePlus inImg, String format) {
        this.inImg = inImg;
        this.width = inImg.getWidth();
        this.height = inImg.getHeight();
        this.stackSize = inImg.getStackSize();
        this.format = format;
    }

    private void init(String inOrientation, String outOrientation) {
        if (inOrientation != null) {
            if (outOrientation.toUpperCase().equals(AS_ACQUIRED) || outOrientation.toUpperCase().equals("ASACQUIREDF")) {
                this.owidth = this.width;
                this.oheight = this.height;
                this.oStackSize = this.stackSize;
            } else if (inOrientation.equalsIgnoreCase("Sagittal") || inOrientation.equalsIgnoreCase("SagittalF")) {
                if (outOrientation.equalsIgnoreCase("Transverse") || outOrientation.equalsIgnoreCase("TransverseF")) {
                    this.owidth = this.stackSize;
                    this.oheight = this.width;
                    this.oStackSize = this.height;
                } else if (outOrientation.equalsIgnoreCase("Coronal") || outOrientation.equalsIgnoreCase("CoronalF")) {
                    this.owidth = this.stackSize;
                    this.oheight = this.height;
                    this.oStackSize = this.width;
                }
            } else if (inOrientation.equalsIgnoreCase("Transverse") || inOrientation.equalsIgnoreCase("TransverseF")) {
                if (outOrientation.equalsIgnoreCase("Sagittal") || outOrientation.equalsIgnoreCase("SagittalF")) {
                    this.owidth = this.height;
                    this.oheight = this.stackSize;
                    this.oStackSize = this.width;
                } else if (outOrientation.equalsIgnoreCase("Coronal") || outOrientation.equalsIgnoreCase("CoronalF")) {
                    this.owidth = this.width;
                    this.oheight = this.stackSize;
                    this.oStackSize = this.height;
                }
            } else if (inOrientation.equalsIgnoreCase("Coronal") || inOrientation.equalsIgnoreCase("CoronalF")) {
                if (outOrientation.equalsIgnoreCase("Transverse") || outOrientation.equalsIgnoreCase("TransverseF")) {
                    this.owidth = this.width;
                    this.oheight = this.stackSize;
                    this.oStackSize = this.height;
                } else if (outOrientation.equalsIgnoreCase("Sagittal") || outOrientation.equalsIgnoreCase("SagittalF")) {
                    this.owidth = this.stackSize;
                    this.oheight = this.height;
                    this.oStackSize = this.width;
                }
            }
        }
    }

    private Calibration getCalibration(String inOrientation, String outOrientation) {
        Calibration cal = this.inImg.getCalibration();
        if (inOrientation != null) {
            if (outOrientation.toUpperCase().equals(AS_ACQUIRED)) {
                return cal;
            }
            if (inOrientation.equalsIgnoreCase("Sagittal") || inOrientation.equalsIgnoreCase("SagittalF")) {
                if (outOrientation.equalsIgnoreCase("Transverse") || outOrientation.equalsIgnoreCase("TransverseF")) {
                    cal.pixelWidth = this.inImg.getCalibration().pixelDepth;
                    cal.pixelHeight = this.inImg.getCalibration().pixelWidth;
                    cal.pixelDepth = this.inImg.getCalibration().pixelHeight;
                } else if (outOrientation.equalsIgnoreCase("Coronal") || outOrientation.equalsIgnoreCase("CoronalF")) {
                    cal.pixelWidth = this.inImg.getCalibration().pixelDepth;
                    cal.pixelHeight = this.inImg.getCalibration().pixelHeight;
                    cal.pixelDepth = this.inImg.getCalibration().pixelWidth;
                }
            } else if (inOrientation.equalsIgnoreCase("Transverse") || inOrientation.equalsIgnoreCase("TransverseF")) {
                if (outOrientation.equalsIgnoreCase("Sagittal") || outOrientation.equalsIgnoreCase("SagittalF")) {
                    cal.pixelWidth = this.inImg.getCalibration().pixelHeight;
                    cal.pixelHeight = this.inImg.getCalibration().pixelDepth;
                    cal.pixelDepth = this.inImg.getCalibration().pixelWidth;
                } else if (outOrientation.equalsIgnoreCase("Coronal") || outOrientation.equalsIgnoreCase("CoronalF")) {
                    cal.pixelWidth = this.inImg.getCalibration().pixelWidth;
                    cal.pixelHeight = this.inImg.getCalibration().pixelDepth;
                    cal.pixelDepth = this.inImg.getCalibration().pixelHeight;
                }
            } else if (inOrientation.equalsIgnoreCase("Coronal") || inOrientation.equalsIgnoreCase("CoronalF")) {
                if (outOrientation.equalsIgnoreCase("Transverse") || outOrientation.equalsIgnoreCase("TransverseF")) {
                    cal.pixelWidth = this.inImg.getCalibration().pixelWidth;
                    cal.pixelHeight = this.inImg.getCalibration().pixelDepth;
                    cal.pixelDepth = this.inImg.getCalibration().pixelHeight;
                } else if (outOrientation.equalsIgnoreCase("Sagittal") || outOrientation.equalsIgnoreCase("SagittalF")) {
                    cal.pixelWidth = this.inImg.getCalibration().pixelDepth;
                    cal.pixelHeight = this.inImg.getCalibration().pixelHeight;
                    cal.pixelDepth = this.inImg.getCalibration().pixelWidth;
                }
            }
        }
        return cal;
    }

    public ImagePlus getImage(String inOrientation, String outOrientation) {
        if (inOrientation.equalsIgnoreCase("as acquiredF") || outOrientation.equalsIgnoreCase("as acquiredF") || inOrientation.equalsIgnoreCase(AS_ACQUIRED_ORIENTATION) || outOrientation.equalsIgnoreCase(AS_ACQUIRED_ORIENTATION)) {
            return this.inImg;
        }
        if (inOrientation.equalsIgnoreCase(outOrientation)) {
            return this.inImg;
        }
        if (outOrientation.substring(0, outOrientation.length() - 1).equalsIgnoreCase(inOrientation)) {
            StackProcessor sp = new StackProcessor(this.inImg.getStack(), this.inImg.getProcessor());
            sp.flipVertical();
            return this.inImg;
        }
        if (inOrientation.substring(0, inOrientation.length() - 1).equalsIgnoreCase(outOrientation)) {
            StackProcessor sp = new StackProcessor(this.inImg.getStack(), this.inImg.getProcessor());
            sp.flipVertical();
            return this.inImg;
        }
        ImageProcessor ip2 = null;
        ImagePlus oip = new ImagePlus();
        this.init(inOrientation, outOrientation);
        if (this.format != null && this.format.startsWith("ANALYZE") && inOrientation != null && !inOrientation.endsWith("F")) {
            StackProcessor sp = new StackProcessor(this.inImg.getStack(), this.inImg.getProcessor());
            sp.flipVertical();
            inOrientation = inOrientation + "F";
        }
        ImageStack inStack = this.inImg.getStack();
        ImageStack ostack = new ImageStack(this.owidth, this.oheight);
        for (int z = 0; z < this.oStackSize; ++z) {
            ip2 = inStack.getProcessor(1).createProcessor(this.owidth, this.oheight);
            this.createSlice(inOrientation, outOrientation, ip2, z);
            ostack.addSlice("", ip2, z);
        }
        oip.setStack("", ostack);
        oip.setCalibration(this.getCalibration(inOrientation, outOrientation));
        oip.setFileInfo(this.inImg.getFileInfo());
        oip = this.correctFlips(inOrientation, outOrientation, oip);
        return oip;
    }

    private ImagePlus correctFlips(String inOrientation, String outOrientation, ImagePlus oip) {
        if (inOrientation.equalsIgnoreCase("CORONALF")) {
            if (outOrientation.equalsIgnoreCase("TRANSVERSE") || outOrientation.equalsIgnoreCase("TRANSVERSEF")) {
                oip = new plexiViewerImageRelayer(inOrientation).reverseStacks(oip);
                if (outOrientation.equalsIgnoreCase("TRANSVERSEF")) {
                    StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                    sp.flipVertical();
                }
            } else if (outOrientation.equalsIgnoreCase("SAGITTAL")) {
                StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                sp.flipVertical();
            }
        } else if (inOrientation.equalsIgnoreCase("SAGITTALF")) {
            if (outOrientation.equalsIgnoreCase("TRANSVERSE") || outOrientation.equalsIgnoreCase("TRANSVERSEF")) {
                oip = new plexiViewerImageRelayer(inOrientation).reverseStacks(oip);
                if (outOrientation.equalsIgnoreCase("TRANSVERSEF")) {
                    StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                    sp.flipVertical();
                }
            } else if (outOrientation.equalsIgnoreCase("CORONAL")) {
                StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                sp.flipVertical();
            }
        } else if (inOrientation.equalsIgnoreCase("TRANSVERSEF")) {
            if (outOrientation.equalsIgnoreCase("CORONAL") || outOrientation.equalsIgnoreCase("CORONALF")) {
                oip = new plexiViewerImageRelayer(inOrientation).reverseStacks(oip);
                if (outOrientation.equalsIgnoreCase("CORONAL")) {
                    StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                    sp.flipVertical();
                }
            } else if (outOrientation.equalsIgnoreCase("SAGITTAL")) {
                StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                sp.flipHorizontal();
                sp.flipVertical();
            } else if (outOrientation.equalsIgnoreCase("SAGITTALF")) {
                StackProcessor sp = new StackProcessor(oip.getStack(), oip.getProcessor());
                sp.flipHorizontal();
            }
        }
        return oip;
    }

    private void createSlice(String inOrientation, String outOrientation, ImageProcessor ip2, int z) {
        if (inOrientation.equalsIgnoreCase("Sagittal") || inOrientation.equalsIgnoreCase("SagittalF")) {
            if (outOrientation.equalsIgnoreCase("Transverse") || outOrientation.equalsIgnoreCase("TransverseF")) {
                this.createSliceSag2Tra(ip2, z);
            } else if (outOrientation.equalsIgnoreCase("Coronal") || outOrientation.equalsIgnoreCase("CoronalF")) {
                this.createSliceCor2Sag(ip2, z);
            }
        } else if (inOrientation.equalsIgnoreCase("Transverse") || inOrientation.equalsIgnoreCase("TransverseF")) {
            if (outOrientation.equalsIgnoreCase("Sagittal") || outOrientation.equalsIgnoreCase("SagittalF")) {
                this.createSliceTra2Sag(ip2, z);
            } else if (outOrientation.equalsIgnoreCase("Coronal") || outOrientation.equalsIgnoreCase("CoronalF")) {
                this.createSliceTra2Cor(ip2, z);
            }
        } else if (inOrientation.equalsIgnoreCase("Coronal") || inOrientation.equalsIgnoreCase("CoronalF")) {
            if (outOrientation.equalsIgnoreCase("Transverse") || outOrientation.equalsIgnoreCase("TransverseF")) {
                this.createSliceCor2Tra(ip2, z);
            } else if (outOrientation.equalsIgnoreCase("Sagittal") || outOrientation.equalsIgnoreCase("SagittalF")) {
                this.createSliceCor2Sag(ip2, z);
            }
        }
    }

    private void createSliceCor2Sag(ImageProcessor ip2, int x) {
        for (int z = 0; z < this.stackSize; ++z) {
            ImageProcessor ip = this.inImg.getStack().getProcessor(z + 1);
            for (int y = 0; y < this.height; ++y) {
                ip2.putPixel(z, y, ip.getPixel(x, y));
            }
        }
    }

    private void createSliceCor2Tra(ImageProcessor ip2, int y) {
        for (int z = 0; z < this.stackSize; ++z) {
            ImageProcessor ip = this.inImg.getStack().getProcessor(z + 1);
            for (int x = 0; x < this.width; ++x) {
                ip2.putPixel(x, z, ip.getPixel(x, y));
            }
        }
    }

    private void createSliceSag2Tra(ImageProcessor ip2, int y) {
        for (int z = 0; z < this.stackSize; ++z) {
            ImageProcessor ip = this.inImg.getStack().getProcessor(z + 1);
            for (int x = 0; x < this.width; ++x) {
                ip2.putPixel(z, x, ip.getPixel(x, y));
            }
        }
    }

    private void createSliceTra2Sag(ImageProcessor ip2, int x) {
        for (int z = 0; z < this.stackSize; ++z) {
            ImageProcessor ip = this.inImg.getStack().getProcessor(z + 1);
            for (int y = 0; y < this.height; ++y) {
                ip2.putPixel(y, this.oheight - 1 - z, ip.getPixel(x, y));
            }
        }
    }

    private void createSliceTra2Cor(ImageProcessor ip2, int y) {
        for (int z = 0; z < this.stackSize; ++z) {
            ImageProcessor ip = this.inImg.getStack().getProcessor(z + 1);
            for (int x = 0; x < this.width; ++x) {
                ip2.putPixel(x, this.oheight - 1 - z, ip.getPixel(x, y));
            }
        }
    }

    public void clearImage() {
        if (this.inImg != null) {
            this.inImg.flush();
        }
    }

    public static void main(String[] args) {
    }
}

