/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Color;
import java.awt.Frame;

public class PlexiMontageMaker {
    private int columns;
    private int rows;
    private int first;
    private int last;
    private int inc;
    private double scale;
    private boolean label = false;
    private boolean borders = false;
    private int saveID;

    public ImagePlus makeMontage(ImagePlus imp) {
        if (imp == null || imp.getStackSize() == 1) {
            IJ.error((String)"Stack required");
            return null;
        }
        int nSlices = imp.getStackSize();
        if (this.columns == 0 || imp.getID() != this.saveID) {
            this.rows = this.columns = (int)Math.sqrt(nSlices);
            int n = nSlices - this.columns * this.rows;
            if (n > 0) {
                this.columns += (int)Math.ceil((double)n / (double)this.rows);
            }
            this.scale = 1.0;
            if (imp.getWidth() * this.columns > 800) {
                this.scale = 0.5;
            }
            if (imp.getWidth() * this.columns > 1600) {
                this.scale = 0.25;
            }
            this.inc = 1;
            this.first = 1;
            this.last = nSlices;
        }
        GenericDialog gd = new GenericDialog("Make Montage", (Frame)IJ.getInstance());
        gd.addNumericField("Columns:", (double)this.columns, 0);
        gd.addNumericField("Rows:", (double)this.rows, 0);
        gd.addNumericField("Scale Factor:", this.scale, 2);
        gd.addNumericField("First Slice:", (double)this.first, 0);
        gd.addNumericField("Last Slice:", (double)this.last, 0);
        gd.addNumericField("Increment:", (double)this.inc, 0);
        gd.addCheckbox("Label Slices", this.label);
        gd.addCheckbox("Borders", this.borders);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        this.columns = (int)gd.getNextNumber();
        this.rows = (int)gd.getNextNumber();
        this.scale = gd.getNextNumber();
        this.first = (int)gd.getNextNumber();
        this.last = (int)gd.getNextNumber();
        this.inc = (int)gd.getNextNumber();
        if (this.first < 1) {
            this.first = 1;
        }
        if (this.last > nSlices) {
            this.last = nSlices;
        }
        if (this.inc < 1) {
            this.inc = 1;
        }
        if (gd.invalidNumber()) {
            IJ.error((String)"Invalid number");
            return null;
        }
        this.label = gd.getNextBoolean();
        this.borders = gd.getNextBoolean();
        return this.makeMontage(imp, this.columns, this.rows, this.scale, this.first, this.last, this.inc, this.label, this.borders);
    }

    public ImagePlus makeMontage(ImagePlus imp, int columns, int rows, double scale, int first, int last, int inc, boolean labels, boolean borders) {
        int stackWidth = imp.getWidth();
        int stackHeight = imp.getHeight();
        int nSlices = imp.getStackSize();
        int width = (int)((double)stackWidth * scale);
        int height = (int)((double)stackHeight * scale);
        int montageWidth = width * columns;
        int montageHeight = height * rows;
        ImageProcessor montage = imp.getProcessor().createProcessor(montageWidth, montageHeight);
        Color fgColor = Color.white;
        Color bgColor = Color.black;
        boolean whiteBackground = false;
        if (imp.getProcessor() instanceof ByteProcessor || imp.getProcessor() instanceof ColorProcessor) {
            ImageStatistics is = imp.getStatistics();
            boolean bl = whiteBackground = is.mode >= 200;
            if (imp.isInvertedLut()) {
                boolean bl2 = whiteBackground = !whiteBackground;
            }
        }
        if (whiteBackground) {
            fgColor = Color.black;
            bgColor = Color.white;
        }
        montage.setColor(bgColor);
        montage.fill();
        montage.setColor(fgColor);
        ImageStack stack = imp.getStack();
        int x = 0;
        int y = 0;
        for (int slice = first; slice <= last; slice += inc) {
            ImageProcessor aSlice = stack.getProcessor(slice);
            if (scale != 1.0) {
                aSlice = aSlice.resize(width, height);
            }
            montage.insert(aSlice, x, y);
            if (borders) {
                this.drawBorder(montage, x, y, width, height);
            }
            if (labels) {
                this.drawLabel(montage, slice, x, y, width, height);
            }
            if ((x += width) < montageWidth) continue;
            x = 0;
            if ((y += height) >= montageHeight) break;
        }
        if (borders) {
            this.drawBorder(montage, 0, 0, montageWidth - 1, montageHeight - 1);
        }
        ImagePlus montageImage = new ImagePlus("", montage);
        montageImage.getProcessor().setColorModel(imp.getProcessor().getColorModel());
        montageImage.setCalibration(imp.getCalibration());
        Calibration cal = montageImage.getCalibration();
        if (cal.scaled()) {
            cal.pixelWidth /= scale;
            cal.pixelHeight /= scale;
        }
        return montageImage;
    }

    void drawBorder(ImageProcessor montage, int x, int y, int width, int height) {
        montage.moveTo(x, y);
        montage.lineTo(x + width, y);
        montage.lineTo(x + width, y + height);
        montage.lineTo(x, y + height);
        montage.lineTo(x, y);
    }

    void drawLabel(ImageProcessor montage, int slice, int x, int y, int width, int height) {
        String s = "" + slice;
        montage.moveTo(x, y += 15);
        montage.drawString(s);
    }

    public static int getColumns(int noSlices, double aspect) {
        int nRows;
        int nColumns = Math.round((float)Math.sqrt((double)noSlices * aspect));
        if (nColumns < (nRows = (int)Math.ceil((float)noSlices / (float)nColumns)) && nRows <= 6) {
            nColumns = nRows;
        }
        return nColumns;
    }

    public static void main(String[] args) {
        int noSlices = 18;
        System.out.println("NO of Slices " + noSlices);
        System.out.println(PlexiMontageMaker.getColumns(noSlices, 0.65));
    }
}

