/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.ImagePlus;
import ij.process.StackProcessor;
import org.nrg.plexiViewer.utils.Transform.PlexiSlicer;

public class PlexiReOrient {
    public static ImagePlus reOrient(ImagePlus inImg, String inOrientation, String outOrientation, String[] postProcess, boolean goCount, boolean showProgress) {
        String beginFrom = null;
        ImagePlus rtn = inImg;
        if (inOrientation != null) {
            if (inOrientation.equalsIgnoreCase("Sagittal")) {
                beginFrom = outOrientation.equalsIgnoreCase("Transverse") ? "BOTTOM" : (outOrientation.equalsIgnoreCase("Coronal") ? "LEFT" : null);
            } else if (inOrientation.equalsIgnoreCase("Transverse")) {
                beginFrom = outOrientation.equalsIgnoreCase("Sagittal") ? "LEFT" : (outOrientation.equalsIgnoreCase("Coronal") ? "TOP" : null);
            } else if (inOrientation.equalsIgnoreCase("Coronal")) {
                beginFrom = outOrientation.equalsIgnoreCase("Transverse") ? "BOTTOM" : (outOrientation.equalsIgnoreCase("Sagittal") ? "LEFT" : null);
            }
            if (beginFrom != null) {
                rtn = new PlexiSlicer().doSlice(inImg, beginFrom, goCount, showProgress);
                if (postProcess != null) {
                    for (int i = 0; i < postProcess.length; ++i) {
                        PlexiReOrient.doPerform(rtn, postProcess[i]);
                    }
                }
            }
        }
        return rtn;
    }

    private static void doPerform(ImagePlus rtn, String process) {
        if (process != null && rtn != null) {
            StackProcessor sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
            if (process.equalsIgnoreCase("RotateRight")) {
                rtn.setStack(rtn.getTitle(), sp.rotateRight());
            } else if (process.equalsIgnoreCase("RotateLeft")) {
                rtn.setStack(rtn.getTitle(), sp.rotateLeft());
            } else if (process.equalsIgnoreCase("flipHorizontal")) {
                sp.flipHorizontal();
            } else if (process.equalsIgnoreCase("flipVertical")) {
                sp.flipVertical();
            }
        }
    }

    public static ImagePlus reOrient(ImagePlus inImg, String inOrientation, String outOrientation, boolean goCount, boolean showProgress) {
        String beginFrom = null;
        ImagePlus rtn = inImg;
        if (inOrientation != null) {
            if (inOrientation.equalsIgnoreCase("Sagittal")) {
                beginFrom = outOrientation.equalsIgnoreCase("Transverse") ? "BOTTOM" : (outOrientation.equalsIgnoreCase("Coronal") ? "LEFT" : null);
            } else if (inOrientation.equalsIgnoreCase("Transverse")) {
                beginFrom = outOrientation.equalsIgnoreCase("Sagittal") ? "LEFT" : (outOrientation.equalsIgnoreCase("Coronal") ? "TOP" : null);
            } else if (inOrientation.equalsIgnoreCase("Coronal")) {
                beginFrom = outOrientation.equalsIgnoreCase("Transverse") ? "BOTTOM" : (outOrientation.equalsIgnoreCase("Sagittal") ? "LEFT" : null);
            }
            if (beginFrom != null) {
                rtn = new PlexiSlicer().doSlice(inImg, beginFrom, goCount, showProgress);
            }
        }
        return rtn;
    }
}

