/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class PlexiSlicer {
    private double outputZSpacing = 1.0;
    private int outputSlices = 1;
    private boolean isLine;
    private boolean noRoi;
    private boolean rgb;
    private boolean goCount;

    public ImagePlus doSlice(ImagePlus imp, String startLocation, boolean goCount, boolean showProgress) {
        int stackSize = imp.getStackSize();
        if (stackSize < 2) {
            System.out.println("Unable to reslice Stack required");
            return null;
        }
        this.goCount = goCount;
        Calibration cal = imp.getCalibration();
        double outputSpacing = cal.pixelDepth;
        String units = cal.getUnits();
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        if (goCount) {
            this.outputZSpacing = 1.0;
            cal.pixelDepth = 1.0;
        } else {
            cal.pixelDepth = outputSpacing;
            this.outputZSpacing = outputSpacing / cal.pixelWidth;
        }
        ImagePlus imp2 = null;
        this.rgb = imp.getType() == 4;
        imp2 = this.reslice(imp, startLocation, showProgress);
        if (imp2 == null) {
            return null;
        }
        imp2.setCalibration(imp.getCalibration());
        cal = imp2.getCalibration();
        cal.pixelDepth = this.outputZSpacing * cal.pixelWidth;
        return imp2;
    }

    private ImagePlus reslice(ImagePlus imp, String startLocation, boolean showProgress) {
        int roiType;
        Roi roi = imp.getRoi();
        int n = roiType = roi != null ? roi.getType() : 0;
        if (roi == null || roiType == 0 || roiType == 5) {
            return this.resliceRectOrLine(imp, startLocation, showProgress);
        }
        System.out.println("Unable to Reslice...Line or rectangular selection required");
        return null;
    }

    ImagePlus resliceRectOrLine(ImagePlus imp, String startLocation, boolean showProgress) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double xInc = 0.0;
        double yInc = 0.0;
        this.noRoi = false;
        Roi roi = imp.getRoi();
        if (roi == null) {
            this.noRoi = true;
            imp.setRoi(0, 0, imp.getWidth(), imp.getHeight());
            roi = imp.getRoi();
        }
        if (roi.getType() == 0) {
            Rectangle r = roi.getBoundingRect();
            if (startLocation.equalsIgnoreCase("TOP")) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y;
                xInc = 0.0;
                yInc = this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startLocation.equalsIgnoreCase("LEFT")) {
                x1 = r.x;
                y1 = r.y;
                x2 = r.x;
                y2 = r.y + r.height;
                xInc = this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            } else if (startLocation.equalsIgnoreCase("BOTTOM")) {
                x1 = r.x;
                y1 = r.y + r.height;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = 0.0;
                yInc = -this.outputZSpacing;
                this.outputSlices = (int)((double)r.height / this.outputZSpacing);
            } else if (startLocation.equalsIgnoreCase("RIGHT")) {
                x1 = r.x + r.width;
                y1 = r.y;
                x2 = r.x + r.width;
                y2 = r.y + r.height;
                xInc = -this.outputZSpacing;
                yInc = 0.0;
                this.outputSlices = (int)((double)r.width / this.outputZSpacing);
            }
        } else if (roi.getType() == 5) {
            Line line = (Line)roi;
            x1 = line.x1;
            y1 = line.y1;
            x2 = line.x2;
            y2 = line.y2;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double nrm = Math.sqrt(dx * dx + dy * dy) / this.outputZSpacing;
            xInc = -(dy / nrm);
            yInc = dx / nrm;
        } else {
            return null;
        }
        if (this.outputSlices == 0) {
            System.out.println("Reslicer...Output Z spacing (" + IJ.d2s((double)this.outputZSpacing, (int)0) + " pixels) is too large.");
            return null;
        }
        ImageStack stack = null;
        for (int i = 0; i < this.outputSlices; ++i) {
            ImageProcessor ip = this.getSlice(imp, x1, y1, x2, y2, null);
            if (stack == null) {
                stack = new ImageStack(ip.getWidth(), ip.getHeight());
            }
            stack.addSlice(null, ip);
            x1 += xInc;
            x2 += xInc;
            y1 += yInc;
            y2 += yInc;
            if (!showProgress) continue;
            double percent = (double)i / (double)this.outputSlices;
        }
        return new ImagePlus(imp.getTitle(), stack);
    }

    ImageProcessor getSlice(ImagePlus imp, double x1, double y1, double x2, double y2, String status) {
        Roi roi = imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        ImageStack stack = imp.getStack();
        int stackSize = stack.getSize();
        ImageProcessor ip2 = null;
        float[] line = null;
        for (int i = 0; i < stackSize; ++i) {
            ImageProcessor ip = stack.getProcessor(i + 1);
            line = this.getLine(ip, x1, y1, x2, y2, line);
            if (i == 0) {
                ip2 = ip.createProcessor(line.length, stackSize);
            }
            this.putRow(ip2, 0, i, line, line.length);
        }
        Calibration cal = imp.getCalibration();
        double zSpacing = cal.pixelDepth / cal.pixelWidth;
        if (this.goCount) {
            zSpacing = 1.0;
        }
        if (zSpacing != 1.0) {
            ip2.setInterpolate(true);
            ip2 = ip2.resize(line.length, (int)((double)stackSize * zSpacing));
        }
        return ip2;
    }

    public void putRow(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            for (int i = 0; i < length; ++i) {
                ip.putPixel(x++, y, Float.floatToIntBits(data[i]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                ip.putPixelValue(x++, y, (double)data[i]);
            }
        }
    }

    private float[] getLine(ImageProcessor ip, double x1, double y1, double x2, double y2, float[] data) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        if (data == null) {
            data = new float[n];
        }
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double rx = x1;
        double ry = y1;
        for (int i = 0; i < n; ++i) {
            data[i] = (float)ip.getInterpolatedValue(rx, ry);
            rx += xinc;
            ry += yinc;
        }
        return data;
    }
}

