/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.Transform;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.process.StackProcessor;
import java.util.Hashtable;
import org.nrg.plexiViewer.lite.UserSelection;
import org.nrg.plexiViewer.lite.display.MontageDisplay;
import org.nrg.plexiViewer.lite.xml.MontageInfo;
import org.nrg.plexiViewer.utils.ImageUtils;
import org.nrg.plexiViewer.utils.Transform.PlexiMontageMaker;
import org.nrg.plexiViewer.utils.Transform.plexiViewerImageRelayer;

public class ReOrientMakeMontage {
    UserSelection options;
    String format = null;
    MontageDisplay mDisplay;
    int nColumns;
    int nRows;

    public ReOrientMakeMontage(UserSelection opt, String format, MontageDisplay mD) {
        this.options = opt;
        this.mDisplay = mD;
        this.format = format;
    }

    public ImagePlus doPerform(ImagePlus image) {
        if (image != null) {
            FileInfo fi = image.getOriginalFileInfo();
            if (this.format != null && this.format.startsWith("ANALYZE")) {
                if (!(image == null || "As Acquired".equalsIgnoreCase(this.options.getOrientation()) || !this.options.getOrientation().equalsIgnoreCase("sagittal") && this.options.isRadiologic())) {
                    StackProcessor sp = new StackProcessor(image.getStack(), image.getProcessor());
                    sp.flipHorizontal();
                }
                if (this.options.getOrientation().equalsIgnoreCase("sagittal")) {
                    image = new plexiViewerImageRelayer(this.options.getOrientation()).reverseStacks(image);
                }
            }
            if (this.options.getDisplay() != null && this.options.getDisplay().equalsIgnoreCase("Montage")) {
                double aspect = 1.0;
                PlexiMontageMaker mm = new PlexiMontageMaker();
                this.mDisplay.setOriginalWidth(image.getWidth());
                this.mDisplay.setOriginalHeight(image.getHeight());
                this.mDisplay.setOriginalStackSize(image.getStackSize());
                try {
                    int startSlice = this.mDisplay.getStartSlice();
                    int endSlice = this.mDisplay.getEndSlice();
                    int noSlices = (endSlice - startSlice) / this.mDisplay.getSliceSpacing() + 1;
                    if (image.getStackSize() == 1) {
                        this.nColumns = 1;
                        this.nRows = 1;
                    } else {
                        this.nColumns = PlexiMontageMaker.getColumns(noSlices, aspect);
                        this.nRows = (int)Math.ceil((float)noSlices / (float)this.nColumns);
                    }
                    this.mDisplay.setNumberOfColumns(this.nColumns);
                    image = mm.makeMontage(image, this.nColumns, this.nRows, this.mDisplay.getScale(), startSlice, endSlice, this.mDisplay.getSliceSpacing(), false, false);
                    System.out.println("ReOrientMakeMontage::Image DImensions are " + image.getWidth() + " " + image.getHeight());
                }
                catch (Exception e) {
                    System.out.println("ReOrientMakeMontage::Unable to get slice information trying defaults");
                    Hashtable attribs = ImageUtils.getSliceIncrement(image);
                    image = mm.makeMontage(image, 5, 5, 0.5, (Integer)attribs.get("startslice"), (Integer)attribs.get("endslice"), (Integer)attribs.get("increment"), true, false);
                    this.mDisplay.setNumberOfColumns(5);
                    MontageInfo mInfo = new MontageInfo();
                    mInfo.setStartSlice((Integer)attribs.get("startslice"));
                    mInfo.setEndSlice((Integer)attribs.get("endslice"));
                    mInfo.setSliceSpacing((Integer)attribs.get("increment"));
                    this.mDisplay.setMInfo(mInfo);
                }
            }
            image.setFileInfo(fi);
            System.out.println("ReOrientMakeMontage outImage File Type is " + image.getOriginalFileInfo().fileType);
        }
        return image;
    }

    public int getNumberOfColumns() {
        return this.nColumns;
    }

    public int getNumberOfRows() {
        return this.nRows;
    }
}

