/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.imageformats;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import ij.process.StackProcessor;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.nrg.plexiViewer.Reader.DICOMReader;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.UnzipFile;
import org.nrg.plexiViewer.utils.imageformats.DicomImage;

public class DicomFileOpener {
    private boolean convertToGrayscale;
    private boolean convertToRGB;
    private double scale = 100.0;
    private int n;
    private int start;
    private int increment;
    private FileInfo fi;
    private String info1;
    private String directory;
    private String orientation = null;
    private String patientOrientation = null;
    private String[] list;
    private String title;
    boolean zipped = false;
    public static final String ORIENTATION_AS_ACQUIRED = "As Acquired";
    String rowAxis;
    String colAxis;
    int width = 0;
    int height = 0;
    int depth = 0;
    int bitDepth = 0;

    public DicomFileOpener(String dir) {
        this.directory = dir;
        this.setTitle();
        this.list = new File(this.directory).list();
        String zext = ".gz";
        for (int i = 0; i < this.list.length; ++i) {
            if (!this.list[i].endsWith(zext)) continue;
            this.zipped = true;
        }
        this.unzip();
    }

    public DicomFileOpener(ArrayList fileList) {
        this.directory = ((File)fileList.get(0)).getParent();
        if (this.directory.startsWith("file:")) {
            this.directory = this.directory.substring(5);
        }
        this.list = new String[fileList.size()];
        this.setTitle();
        String zext = ".gz";
        for (int i = 0; i < fileList.size(); ++i) {
            this.list[i] = ((File)fileList.get(i)).getName();
            if (!new File(this.directory + File.separator + this.list[i]).exists() && new File(this.directory + File.separator + this.list[i] + zext).exists()) {
                this.zipped = true;
                continue;
            }
            if (!this.list[i].endsWith(".gz")) continue;
            this.zipped = true;
        }
        this.unzip();
    }

    private void unzip() {
        String zext = ".gz";
        if (this.zipped) {
            String suffix = "_" + new Random().nextInt();
            File tempDir = new File(FileUtils.getTempFolder());
            try {
                File dir = File.createTempFile("NRG", suffix, tempDir);
                if (dir.exists()) {
                    dir.delete();
                }
                System.out.println("DicomSequence tempdir " + dir.getPath());
                boolean success = dir.mkdir();
                System.out.println("DicomSequence tempdir " + dir.getPath() + " success " + success);
                for (int i = 0; i < this.list.length; ++i) {
                    new UnzipFile().gunzip(this.directory + File.separator + this.list[i], dir.getPath());
                }
                this.directory = dir.getPath();
                this.list = new File(this.directory).list();
            }
            catch (IOException ioe) {
                System.out.println("DicomSequence:: Unable to create temporary directory " + ioe.getMessage());
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
    }

    private void setTitle() {
        int index;
        this.title = this.directory;
        if (this.title.endsWith(File.separator)) {
            this.title = this.title.substring(0, this.title.length() - 1);
        }
        if ((index = this.title.lastIndexOf(File.separatorChar)) != -1) {
            this.title = this.title.substring(index + 1);
        }
        if (this.title.endsWith(":")) {
            this.title = this.title.substring(0, this.title.length() - 1);
        }
    }

    public ImagePlus getImagePlus() {
        return this.getImagePlus(null);
    }

    public ImagePlus getImagePlus(String filter, boolean convertToGrayscale, boolean convertToRGB) {
        boolean allSameCalibration;
        Calibration cal;
        double max;
        double min;
        ImageStack stack;
        ImagePlus rtn;
        block33: {
            rtn = null;
            this.convertToGrayscale = convertToGrayscale;
            this.convertToRGB = convertToRGB;
            try {
                this.list = this.sortFileList();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            this.n = this.list.length;
            this.start = 0;
            this.increment = 1;
            this.scale = 100.0;
            if (IJ.debugMode) {
                IJ.log((String)("DicomSequence: " + this.directory + " (" + this.list.length + " files)"));
            }
            stack = null;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            cal = null;
            allSameCalibration = true;
            int count = 0;
            try {
                for (int i = this.start; i < this.list.length; ++i) {
                    String info;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    ImagePlus imp = opener.openImage(this.directory, this.list[i]);
                    if (imp != null && stack == null) {
                        this.width = imp.getWidth();
                        this.height = imp.getHeight();
                        this.depth = imp.getStackSize();
                        this.bitDepth = imp.getBitDepth();
                        cal = imp.getCalibration();
                        if (convertToRGB) {
                            this.bitDepth = 24;
                        }
                        if (convertToGrayscale) {
                            this.bitDepth = 8;
                        }
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = this.scale < 100.0 ? new ImageStack((int)((double)this.width * this.scale / 100.0), (int)((double)this.height * this.scale / 100.0), cm) : new ImageStack(this.width, this.height, cm);
                    }
                    if (imp == null) {
                        if (this.list[i].startsWith(".")) continue;
                        IJ.log((String)(this.list[i] + ": unable to open"));
                        continue;
                    }
                    if (imp.getWidth() != this.width || imp.getHeight() != this.height) {
                        IJ.log((String)(this.list[i] + ": wrong size; " + this.width + "x" + this.height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found"));
                        continue;
                    }
                    String label = imp.getTitle();
                    if (this.depth == 1 && (info = (String)imp.getProperty("Info")) != null) {
                        label = label + "\n" + info;
                    }
                    if (imp.getCalibration().pixelWidth != cal.pixelWidth) {
                        allSameCalibration = false;
                    }
                    ImageStack inputStack = imp.getStack();
                    for (int slice = 1; slice <= inputStack.getSize(); ++slice) {
                        ImageProcessor ip = inputStack.getProcessor(slice);
                        int bitDepth2 = imp.getBitDepth();
                        if (convertToRGB) {
                            ip = ip.convertToRGB();
                            bitDepth2 = 24;
                        } else if (convertToGrayscale) {
                            ip = ip.convertToByte(true);
                            bitDepth2 = 8;
                        }
                        if (bitDepth2 != this.bitDepth) {
                            if (this.bitDepth == 8) {
                                ip = ip.convertToByte(true);
                                bitDepth2 = 8;
                            } else if (this.bitDepth == 24) {
                                ip = ip.convertToRGB();
                                bitDepth2 = 24;
                            }
                        }
                        if (bitDepth2 != this.bitDepth) {
                            IJ.log((String)(this.list[i] + ": wrong bit depth; " + this.bitDepth + " expected, " + bitDepth2 + " found"));
                            break;
                        }
                        if (slice == 1) {
                            ++count;
                        }
                        if (this.scale < 100.0) {
                            ip = ip.resize((int)((double)this.width * this.scale / 100.0), (int)((double)this.height * this.scale / 100.0));
                        }
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        String label2 = label;
                        if (this.depth > 1) {
                            label2 = "" + slice;
                        }
                        stack.addSlice(label2, ip);
                    }
                    if (count < this.n) {
                        continue;
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                if (stack == null) break block33;
                stack.trim();
            }
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2 = new ImagePlus(this.title, stack);
            if (imp2.getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.setFileInfo(this.fi);
            if (allSameCalibration) {
                imp2.setCalibration(cal);
            }
            if (imp2.getStackSize() == 1 && this.info1 != null) {
                imp2.setProperty("Info", (Object)this.info1);
            }
            rtn = imp2;
        }
        rtn = this.reorientImage(rtn);
        if (this.zipped) {
            FileUtils.deleteFile(this.directory, true);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImagePlus getImagePlus(String filter) {
        ImagePlus rtn = null;
        try {
            this.list = this.sortFileList();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.zipped) {
                FileUtils.deleteFile(this.directory, true);
            }
            return null;
        }
        this.n = this.list.length;
        this.start = 0;
        this.increment = 1;
        this.scale = 100.0;
        if (IJ.debugMode) {
            IJ.log((String)("DicomSequence: " + this.directory + " (" + this.list.length + " files)"));
        }
        ImageStack stack = null;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Calibration cal = null;
        boolean allSameCalibration = true;
        int count = 0;
        try {
            for (int i = this.start; i < this.list.length; ++i) {
                String info;
                Opener opener = new Opener();
                opener.setSilentMode(true);
                ImagePlus imp = opener.openImage(this.directory, this.list[i]);
                if (imp != null && stack == null) {
                    this.width = imp.getWidth();
                    this.height = imp.getHeight();
                    this.depth = imp.getStackSize();
                    this.bitDepth = imp.getBitDepth();
                    cal = imp.getCalibration();
                    ColorModel cm = imp.getProcessor().getColorModel();
                    stack = this.scale < 100.0 ? new ImageStack((int)((double)this.width * this.scale / 100.0), (int)((double)this.height * this.scale / 100.0), cm) : new ImageStack(this.width, this.height, cm);
                }
                if (imp == null) {
                    if (this.list[i].startsWith(".")) continue;
                    IJ.log((String)(this.directory + File.separator + this.list[i] + ": unable to open"));
                    continue;
                }
                if (imp.getWidth() != this.width || imp.getHeight() != this.height) {
                    IJ.log((String)(this.list[i] + ": wrong size; " + this.width + "x" + this.height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found"));
                    continue;
                }
                String label = imp.getTitle();
                if (this.depth == 1 && (info = (String)imp.getProperty("Info")) != null) {
                    label = label + "\n" + info;
                }
                if (imp.getCalibration().pixelWidth != cal.pixelWidth) {
                    allSameCalibration = false;
                }
                ImageStack inputStack = imp.getStack();
                for (int slice = 1; slice <= inputStack.getSize(); ++slice) {
                    ImageProcessor ip = inputStack.getProcessor(slice);
                    if (slice == 1) {
                        ++count;
                    }
                    if (this.scale < 100.0) {
                        ip = ip.resize((int)((double)this.width * this.scale / 100.0), (int)((double)this.height * this.scale / 100.0));
                    }
                    if (ip.getMin() < min) {
                        min = ip.getMin();
                    }
                    if (ip.getMax() > max) {
                        max = ip.getMax();
                    }
                    String label2 = label;
                    if (this.depth > 1) {
                        label2 = "" + slice;
                    }
                    stack.addSlice(label2, ip);
                }
                if (count >= this.n) break;
            }
            if (stack != null && stack.getSize() > 0) {
                ImagePlus imp2 = new ImagePlus(this.title, stack);
                if (imp2.getType() == 1 || imp2.getType() == 2) {
                    imp2.getProcessor().setMinAndMax(min, max);
                }
                imp2.setFileInfo(this.fi);
                if (allSameCalibration) {
                    imp2.setCalibration(cal);
                }
                if (imp2.getStackSize() == 1 && this.info1 != null) {
                    imp2.setProperty("Info", (Object)this.info1);
                }
                rtn = imp2;
            }
            rtn = this.reorientImage(rtn);
        }
        catch (OutOfMemoryError e) {
        }
        finally {
            if (this.zipped) {
                FileUtils.deleteFile(this.directory, true);
            }
        }
        return rtn;
    }

    private ImagePlus reorientImage(ImagePlus img) {
        StackProcessor sp = null;
        ImagePlus rtn = img;
        if (this.orientation.equals(ORIENTATION_AS_ACQUIRED)) {
            return rtn;
        }
        if (this.orientation.equals("SAGITTAL")) {
            if (this.rowAxis.equals("A") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
                sp.flipVertical();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("F")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("P")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("P")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
            }
            rtn = new ImagePlus(rtn.getTitle(), this.reverseStack(rtn.getStack(), rtn));
        } else if (this.orientation.equals("TRANSVERSE")) {
            if (this.rowAxis.equals("R") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                sp.flipHorizontal();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("R") && this.colAxis.equals("P")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("L") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("A") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("A") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipHorizontal();
            }
        } else if (this.orientation.equals("CORONAL")) {
            if (this.rowAxis.equals("R") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                sp.flipHorizontal();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("R") && this.colAxis.equals("F")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("L") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                rtn = new ImagePlus(img.getTitle(), img.getStack());
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            }
            rtn = new ImagePlus(rtn.getTitle(), this.reverseStack(rtn.getStack(), rtn));
        }
        this.orientation = this.orientation + "F";
        return rtn;
    }

    private ImageStack reverseStack(ImageStack stack, ImagePlus imp) {
        int n;
        ImageStack stack2 = imp.createEmptyStack();
        while ((n = stack.getSize()) > 0) {
            stack2.addSlice(stack.getSliceLabel(n), stack.getProcessor(n));
            stack.deleteLastSlice();
        }
        return stack2;
    }

    private String[] sortFileList() throws Exception {
        int j;
        float[] normal = new float[3];
        float[] cosines = new float[6];
        Object[] dcmImage = new DicomImage[this.list.length];
        String[] rtn = new String[this.list.length];
        boolean secondaryImage = false;
        for (int i = 0; i < this.list.length; ++i) {
            int imagePositionPatient;
            ImagePlus imp = new Opener().openImage(this.directory, this.list[i]);
            if (imp == null) continue;
            String taginfo = (String)imp.getProperty("Info");
            float[] ipp = new float[3];
            if (i == 0) {
                this.width = imp.getWidth();
                this.height = imp.getHeight();
                this.depth = imp.getStackSize();
                this.bitDepth = imp.getBitDepth();
                this.info1 = taginfo;
                this.setOrientation();
                this.setPatientOrientation();
                int imageOrientationPatient = this.info1.indexOf("0020,0037");
                if (imageOrientationPatient != -1) {
                    String dcs = this.info1.substring(imageOrientationPatient + 10).split("\n")[0].split(":")[1];
                    String[] inDCS = dcs.split("\\\\");
                    for (int k = 0; k < 3; ++k) {
                        cosines[k] = Float.parseFloat(inDCS[k]);
                        cosines[k + 3] = Float.parseFloat(inDCS[k + 3]);
                    }
                    normal[0] = cosines[1] * cosines[5] - cosines[2] * cosines[4];
                    normal[1] = cosines[2] * cosines[3] - cosines[0] * cosines[5];
                    normal[2] = cosines[0] * cosines[4] - cosines[1] * cosines[3];
                } else {
                    secondaryImage = true;
                }
            }
            if ((imagePositionPatient = taginfo.indexOf("0020,0032")) != -1) {
                String ippStr = taginfo.substring(imagePositionPatient + 10).split("\n")[0].split(":")[1];
                int instanceNumber = taginfo.indexOf("0020,0013");
                if (instanceNumber != -1) {
                    String instanceNo = taginfo.substring(instanceNumber + 10).split("\n")[0].split(":")[1];
                    String[] ippStrs = ippStr.split("\\\\");
                    for (int j2 = 0; j2 < 3; ++j2) {
                        ipp[j2] = Float.parseFloat(ippStrs[j2]);
                    }
                    float dist = 0.0f;
                    for (int j3 = 0; j3 < 3; ++j3) {
                        dist += normal[j3] * ipp[j3];
                    }
                    dcmImage[i] = new DicomImage(this.list[i], instanceNo, dist);
                    continue;
                }
                secondaryImage = true;
                continue;
            }
            secondaryImage = true;
        }
        if (secondaryImage) {
            for (j = 0; j < this.list.length; ++j) {
                rtn[j] = this.list[j];
            }
        } else {
            Arrays.sort(dcmImage);
            for (j = 0; j < dcmImage.length; ++j) {
                rtn[j] = ((DicomImage)dcmImage[j]).getFilePath();
                dcmImage[j] = null;
            }
        }
        return rtn;
    }

    private void setPatientOrientation() {
        try {
            int patientOri = this.info1.indexOf("0020,0020");
            if (patientOri == -1) {
                return;
            }
            this.patientOrientation = this.info1.substring(patientOri + 10).split("\n")[0].split(":")[1];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPatientOrientation() {
        return this.patientOrientation;
    }

    public String getOrientation() {
        return this.orientation;
    }

    private void setOrientation() {
        int imagePositionPatient = this.info1.indexOf("0020,0037");
        if (imagePositionPatient == -1) {
            this.orientation = ORIENTATION_AS_ACQUIRED;
            return;
        }
        String dcs = this.info1.substring(imagePositionPatient + 10).split("\n")[0].split(":")[1];
        try {
            this.rowAxis = DICOMReader.getRowAxis(dcs);
            this.colAxis = DICOMReader.getColumnAxis(dcs);
            this.orientation = DICOMReader.setOrientation(dcs);
        }
        catch (Exception e) {
            this.orientation = ORIENTATION_AS_ACQUIRED;
        }
    }

    public static void main(String[] args) {
        String dir = args[0];
        DicomFileOpener dcm = new DicomFileOpener(dir);
        ImagePlus img1 = dcm.getImagePlus(null);
        ImageStack stack = img1.getImageStack();
        if (img1.getType() == 4) {
            int nColors = 256;
            if (stack.getSize() > 2) {
                new StackConverter(img1).convertToIndexedColor(nColors);
            } else {
                ImageConverter ic = new ImageConverter(img1);
                ic.convertRGBtoIndexedColor(nColors);
            }
        }
        img1.show();
        System.out.println("All done");
    }
}

