/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.imageformats;

public class DicomImage
implements Comparable {
    float distFromNormal;
    int instanceNumber;
    String filePath;
    float LIKE_NULL = Float.NaN;

    public DicomImage(String filePath, String i) {
        this.filePath = filePath;
        this.distFromNormal = this.LIKE_NULL;
        this.instanceNumber = Integer.parseInt(i.trim());
    }

    public DicomImage(String filePath, String i, float d) {
        this.filePath = filePath;
        this.instanceNumber = Integer.parseInt(i.trim());
        this.distFromNormal = d;
    }

    public float getDistFromNormal() {
        return this.distFromNormal;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public void setDistFromNormal(float distFromNormal) {
        this.distFromNormal = distFromNormal;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public void setInstanceNumber(String instanceNumber) {
        this.instanceNumber = Integer.parseInt(instanceNumber);
    }

    public int compareTo(Object o) throws ClassCastException {
        if (!(o instanceof DicomImage)) {
            throw new ClassCastException("A DicomImage object expected.");
        }
        float distB = ((DicomImage)o).getDistFromNormal();
        int instanceNumber = ((DicomImage)o).getInstanceNumber();
        int rtn = this.distFromNormal != this.LIKE_NULL ? ((double)Math.abs(this.distFromNormal - distB) > 1.0E-6 ? (this.distFromNormal < distB ? -1 : 1) : (this.instanceNumber < instanceNumber ? -1 : 1)) : (this.instanceNumber < instanceNumber ? -1 : 1);
        return rtn;
    }

    public String toString() {
        return "File=" + this.getFilePath() + " DISTANCE=" + this.getDistFromNormal() + " Instance Number=" + this.getInstanceNumber();
    }
}

