/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.plexiViewer.utils.imageformats;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.DICOM_Sorter;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.nrg.plexiViewer.Reader.DICOMReader;
import org.nrg.plexiViewer.utils.FileUtils;
import org.nrg.plexiViewer.utils.UnzipFile;

public class DicomSequence {
    private boolean convertToGrayscale;
    private boolean convertToRGB;
    private double scale = 100.0;
    private int n;
    private int start;
    private int increment;
    private String filter;
    private FileInfo fi;
    private String info1;
    private String directory;
    private String orientation = null;
    private String patientOrientation = null;
    private String[] list;
    private String title;
    boolean zipped = false;
    String rowAxis;
    String colAxis;

    public DicomSequence(String dir) {
        this.directory = dir;
        this.setTitle();
        this.list = new File(this.directory).list();
        String zext = ".gz";
        for (int i = 0; i < this.list.length; ++i) {
            if (!this.list[i].endsWith(zext)) continue;
            this.zipped = true;
        }
        this.unzip();
    }

    private void unzip() {
        String zext = ".gz";
        if (this.zipped) {
            String suffix = "_" + new Random().nextInt();
            File tempDir = new File(FileUtils.getTempFolder());
            try {
                File dir = File.createTempFile("NRG", suffix, tempDir);
                if (dir.exists()) {
                    dir.delete();
                }
                dir.mkdir();
                for (int i = 0; i < this.list.length; ++i) {
                    new UnzipFile().gunzip(this.directory + File.separator + this.list[i], dir.getPath());
                }
                this.directory = dir.getPath();
                this.list = new File(this.directory).list();
            }
            catch (IOException ioe) {
                System.out.println("DicomSequence:: Unable to create temporary directory");
            }
        }
    }

    public DicomSequence(ArrayList fileList) {
        this.directory = ((File)fileList.get(0)).getParent();
        if (this.directory.startsWith("file:")) {
            this.directory = this.directory.substring(5);
        }
        this.list = new String[fileList.size()];
        this.setTitle();
        String zext = ".gz";
        for (int i = 0; i < fileList.size(); ++i) {
            this.list[i] = ((File)fileList.get(i)).getName();
            if (new File(this.directory + File.separator + this.list[i]).exists() || !new File(this.directory + File.separator + this.list[i] + zext).exists()) continue;
            this.zipped = true;
        }
        this.unzip();
    }

    private void setTitle() {
        int index;
        this.title = this.directory;
        if (this.title.endsWith(File.separator)) {
            this.title = this.title.substring(0, this.title.length() - 1);
        }
        if ((index = this.title.lastIndexOf(File.separatorChar)) != -1) {
            this.title = this.title.substring(index + 1);
        }
        if (this.title.endsWith(":")) {
            this.title = this.title.substring(0, this.title.length() - 1);
        }
    }

    public ImagePlus getImagePlus() {
        return this.getImagePlus(null, true, false);
    }

    public ImagePlus getImagePlus(String filter, boolean convertToGrayscale, boolean convertToRGB) {
        boolean allSameCalibration;
        Calibration cal;
        double max;
        double min;
        ImageStack stack;
        ImagePlus rtn;
        block45: {
            rtn = null;
            this.convertToGrayscale = convertToGrayscale;
            this.convertToRGB = convertToRGB;
            this.filter = filter;
            this.list = this.sortFileList(this.list);
            this.n = this.list.length;
            this.start = 1;
            this.increment = 1;
            this.scale = 100.0;
            if (IJ.debugMode) {
                IJ.log((String)("DicomSequence: " + this.directory + " (" + this.list.length + " files)"));
            }
            int width = 0;
            int height = 0;
            int depth = 0;
            int bitDepth = 0;
            stack = null;
            min = Double.MAX_VALUE;
            max = -1.7976931348623157E308;
            cal = null;
            allSameCalibration = true;
            try {
                for (int i = 0; i < this.list.length; ++i) {
                    ImagePlus imp;
                    if (this.list[i].endsWith(".txt") || (imp = new Opener().openImage(this.directory, this.list[i])) == null) continue;
                    width = imp.getWidth();
                    height = imp.getHeight();
                    bitDepth = imp.getBitDepth();
                    this.fi = imp.getOriginalFileInfo();
                }
                if (width == 0) {
                    IJ.error((String)"Import Sequence", (String)"This folder does not appear to contain any TIFF,\nJPEG, BMP, DICOM, GIF, FITS or PGM files.");
                    return null;
                }
                if (filter != null && (filter.equals("") || filter.equals("*"))) {
                    filter = null;
                }
                if (filter != null) {
                    int filteredImages = 0;
                    for (int i = 0; i < this.list.length; ++i) {
                        if (this.list[i].indexOf(filter) >= 0) {
                            ++filteredImages;
                            continue;
                        }
                        this.list[i] = null;
                    }
                    if (filteredImages == 0) {
                        IJ.error((String)("None of the " + this.list.length + " files contain\n the string '" + filter + "' in their name."));
                        return null;
                    }
                    String[] list2 = new String[filteredImages];
                    int j = 0;
                    for (int i = 0; i < this.list.length; ++i) {
                        if (this.list[i] == null) continue;
                        list2[j++] = this.list[i];
                    }
                    this.list = list2;
                }
                if (this.n < 1) {
                    this.n = this.list.length;
                }
                if (this.start < 1 || this.start > this.list.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > this.list.length) {
                    this.n = this.list.length - this.start + 1;
                }
                int count = 0;
                int counter = 0;
                for (int i = this.start - 1; i < this.list.length; ++i) {
                    String info;
                    if (this.list[i].endsWith(".txt") || counter++ % this.increment != 0) continue;
                    Opener opener = new Opener();
                    opener.setSilentMode(true);
                    ImagePlus imp = opener.openImage(this.directory, this.list[i]);
                    if (imp != null && stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        depth = imp.getStackSize();
                        bitDepth = imp.getBitDepth();
                        cal = imp.getCalibration();
                        if (convertToRGB) {
                            bitDepth = 24;
                        }
                        if (convertToGrayscale) {
                            bitDepth = 8;
                        }
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = this.scale < 100.0 ? new ImageStack((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0), cm) : new ImageStack(width, height, cm);
                        this.info1 = (String)imp.getProperty("Info");
                        if (this.orientation == null) {
                            this.setOrientation();
                        }
                        if (this.patientOrientation == null) {
                            this.setPatientOrientation();
                        }
                    }
                    if (imp == null) {
                        if (this.list[i].startsWith(".")) continue;
                        IJ.log((String)(this.list[i] + ": unable to open"));
                        continue;
                    }
                    if (imp.getWidth() != width || imp.getHeight() != height) {
                        IJ.log((String)(this.list[i] + ": wrong size; " + width + "x" + height + " expected, " + imp.getWidth() + "x" + imp.getHeight() + " found"));
                        continue;
                    }
                    String label = imp.getTitle();
                    if (depth == 1 && (info = (String)imp.getProperty("Info")) != null) {
                        label = label + "\n" + info;
                    }
                    if (imp.getCalibration().pixelWidth != cal.pixelWidth) {
                        allSameCalibration = false;
                    }
                    ImageStack inputStack = imp.getStack();
                    for (int slice = 1; slice <= inputStack.getSize(); ++slice) {
                        ImageProcessor ip = inputStack.getProcessor(slice);
                        int bitDepth2 = imp.getBitDepth();
                        if (convertToRGB) {
                            ip = ip.convertToRGB();
                            bitDepth2 = 24;
                        } else if (convertToGrayscale) {
                            ip = ip.convertToByte(true);
                            bitDepth2 = 8;
                        }
                        if (bitDepth2 != bitDepth) {
                            if (bitDepth == 8) {
                                ip = ip.convertToByte(true);
                                bitDepth2 = 8;
                            } else if (bitDepth == 24) {
                                ip = ip.convertToRGB();
                                bitDepth2 = 24;
                            }
                        }
                        if (bitDepth2 != bitDepth) {
                            IJ.log((String)(this.list[i] + ": wrong bit depth; " + bitDepth + " expected, " + bitDepth2 + " found"));
                            break;
                        }
                        if (slice == 1) {
                            ++count;
                        }
                        if (this.scale < 100.0) {
                            ip = ip.resize((int)((double)width * this.scale / 100.0), (int)((double)height * this.scale / 100.0));
                        }
                        if (ip.getMin() < min) {
                            min = ip.getMin();
                        }
                        if (ip.getMax() > max) {
                            max = ip.getMax();
                        }
                        String label2 = label;
                        if (depth > 1) {
                            label2 = "" + slice;
                        }
                        stack.addSlice(label2, ip);
                    }
                    if (count < this.n) {
                        continue;
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                if (stack == null) break block45;
                stack.trim();
            }
        }
        if (stack != null && stack.getSize() > 0) {
            ImagePlus imp2;
            if (this.info1 != null && this.info1.lastIndexOf("7FE0,0010") > 0) {
                stack = new DICOM_Sorter().sort(stack);
            }
            if ((imp2 = new ImagePlus(this.title, stack)).getType() == 1 || imp2.getType() == 2) {
                imp2.getProcessor().setMinAndMax(min, max);
            }
            imp2.setFileInfo(this.fi);
            if (allSameCalibration) {
                imp2.setCalibration(cal);
            }
            if (imp2.getStackSize() == 1 && this.info1 != null) {
                imp2.setProperty("Info", (Object)this.info1);
            }
            rtn = imp2;
        }
        this.reorientImage(rtn);
        if (this.zipped) {
            FileUtils.deleteFile(this.directory);
        }
        return rtn;
    }

    private ImagePlus reorientImage(ImagePlus img) {
        StackProcessor sp = null;
        ImagePlus rtn = img;
        if (this.orientation.equals("SAGITTAL")) {
            if (this.rowAxis.equals("A") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
                sp.flipVertical();
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("F")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("P")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("P")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
            }
        } else if (this.orientation.equals("TRANSVERSE")) {
            if (this.rowAxis.equals("R") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("R") && this.colAxis.equals("P")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("L") && this.colAxis.equals("A")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("A") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("A") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("P") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipHorizontal();
            }
        } else if (this.orientation.equals("CORONAL")) {
            if (this.rowAxis.equals("R") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("R") && this.colAxis.equals("F")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipHorizontal();
            } else if (this.rowAxis.equals("L") && this.colAxis.equals("H")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            } else if (this.rowAxis.equals("H") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("R")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateRight();
                rtn = new ImagePlus(img.getTitle(), stack);
            } else if (this.rowAxis.equals("F") && this.colAxis.equals("L")) {
                sp = new StackProcessor(img.getStack(), img.getProcessor());
                ImageStack stack = sp.rotateLeft();
                rtn = new ImagePlus(img.getTitle(), stack);
                sp = new StackProcessor(rtn.getStack(), rtn.getProcessor());
                sp.flipVertical();
            }
            rtn = new ImagePlus(rtn.getTitle(), this.reverseStack(rtn.getStack(), rtn));
        }
        this.orientation = this.orientation + "F";
        return rtn;
    }

    private ImageStack reverseStack(ImageStack stack, ImagePlus imp) {
        int n;
        ImageStack stack2 = imp.createEmptyStack();
        while ((n = stack.getSize()) > 0) {
            stack2.addSlice(stack.getSliceLabel(n), stack.getProcessor(n));
            stack.deleteLastSlice();
        }
        return stack2;
    }

    private void setPatientOrientation() {
        int patientOri = this.info1.indexOf("0020,0020");
        if (patientOri == -1) {
            return;
        }
        this.patientOrientation = this.info1.substring(patientOri + 10).split("\n")[0].split(":")[1];
    }

    public String getPatientOrientation() {
        return this.patientOrientation;
    }

    private void setOrientation() {
        int imagePositionPatient = this.info1.indexOf("0020,0037");
        String dcs = this.info1.substring(imagePositionPatient + 10).split("\n")[0].split(":")[1];
        this.rowAxis = DICOMReader.getRowAxis(dcs);
        this.colAxis = DICOMReader.getColumnAxis(dcs);
        this.orientation = DICOMReader.setOrientation(dcs);
    }

    String[] sortFileList(String[] list) {
        int i;
        int first;
        int listLength = list.length;
        int n = first = listLength > 1 ? 1 : 0;
        if (list[first].length() == list[listLength - 1].length() && list[first].length() == list[listLength / 2].length()) {
            StringSorter.sort((String[])list);
            return list;
        }
        int maxDigits = 15;
        String[] list2 = null;
        for (i = 0; i < listLength; ++i) {
            int len = list[i].length();
            String num = "";
            for (int j = 0; j < len; ++j) {
                char ch = list[i].charAt(j);
                if (ch < '0' || ch > '9') continue;
                num = num + ch;
            }
            if (list2 == null) {
                list2 = new String[listLength];
            }
            num = "000000000000000" + num;
            num = num.substring(num.length() - maxDigits);
            list2[i] = num + list[i];
        }
        if (list2 != null) {
            StringSorter.sort(list2);
            for (i = 0; i < listLength; ++i) {
                list2[i] = list2[i].substring(maxDigits);
            }
            return list2;
        }
        StringSorter.sort((String[])list);
        return list;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public static void main(String[] args) {
        String dir = "C:\\Archive\\TEST_DCM\\UNZIPPED";
        DicomSequence dcm = new DicomSequence(dir);
        ImagePlus img = dcm.getImagePlus();
        img.show();
    }
}

