/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.NonBlockingGenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class BatchProcesser
implements PlugIn,
ActionListener,
ItemListener,
Runnable {
    private static final String MACRO_FILE_NAME = "BatchMacro.ijm";
    private static final String[] formats = new String[]{"TIFF", "8-bit TIFF", "JPEG", "GIF", "PNG", "PGM", "BMP", "FITS", "Text Image", "ZIP", "Raw"};
    private static String format = Prefs.get("batch.format", formats[0]);
    private static final String[] code = new String[]{"[Select from list]", "Add Border", "Convert to RGB", "Crop", "Gaussian Blur", "Invert", "Label", "Timestamp", "Measure", "Resize", "Scale", "Show File Info", "Unsharp Mask"};
    private String macro = "";
    private int testImage;
    private Button input;
    private Button output;
    private Button open;
    private Button save;
    private Button test;
    private TextField inputDir;
    private TextField outputDir;
    private GenericDialog gd;
    private Thread thread;
    private ImagePlus virtualStack;

    public void run(String arg) {
        if (arg.equals("stack")) {
            this.virtualStack = IJ.getImage();
            if (this.virtualStack.getStackSize() == 1) {
                this.error("This command requires a stack or virtual stack.");
                return;
            }
        }
        String macroPath = IJ.getDirectory("macros") + MACRO_FILE_NAME;
        this.macro = IJ.openAsString(macroPath);
        if (this.macro == null || this.macro.startsWith("Error: ")) {
            IJ.showStatus(this.macro.substring(7) + ": " + macroPath);
            this.macro = "";
        }
        if (!this.showDialog()) {
            return;
        }
        String inputPath = null;
        if (this.virtualStack == null) {
            inputPath = this.inputDir.getText();
            if (inputPath.equals("")) {
                this.error("Please choose an input folder");
                return;
            }
            File f1 = new File(inputPath = this.addSeparator(inputPath));
            if (!f1.exists() || !f1.isDirectory()) {
                this.error("Input does not exist or is not a folder\n \n" + inputPath);
                return;
            }
        }
        String outputPath = this.outputDir.getText();
        outputPath = this.addSeparator(outputPath);
        File f2 = new File(outputPath);
        if (!(outputPath.equals("") || f2.exists() && f2.isDirectory())) {
            this.error("Output does not exist or is not a folder\n \n" + outputPath);
            return;
        }
        if (this.macro.equals("")) {
            this.error("There is no macro code in the text area");
            return;
        }
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            ij.getProgressBar().setBatchMode(true);
        }
        IJ.resetEscape();
        if (this.virtualStack != null) {
            this.processVirtualStack(outputPath);
        } else {
            this.processFolder(inputPath, outputPath);
        }
        IJ.showProgress(1, 1);
        if (this.virtualStack == null) {
            Prefs.set("batch.input", this.inputDir.getText());
        }
        Prefs.set("batch.output", this.outputDir.getText());
        Prefs.set("batch.format", format);
        this.macro = this.gd.getTextArea1().getText();
        if (!this.macro.equals("")) {
            IJ.saveString(this.macro, IJ.getDirectory("macros") + MACRO_FILE_NAME);
        }
    }

    boolean showDialog() {
        this.validateFormat();
        this.gd = new NonBlockingGenericDialog("Batch Process");
        this.addPanels(this.gd);
        this.gd.setInsets(15, 0, 5);
        this.gd.addChoice("Output Format:", formats, format);
        this.gd.setInsets(0, 0, 5);
        this.gd.addChoice("Add Macro Code:", code, code[0]);
        this.gd.setInsets(15, 10, 0);
        Dimension screen = IJ.getScreenSize();
        this.gd.addTextAreas(this.macro, null, screen.width <= 600 ? 10 : 15, 60);
        this.addButtons(this.gd);
        this.gd.setOKLabel("Process");
        Vector choices = this.gd.getChoices();
        Choice choice = (Choice)choices.elementAt(1);
        choice.addItemListener(this);
        this.gd.showDialog();
        format = this.gd.getNextChoice();
        this.macro = this.gd.getNextText();
        return !this.gd.wasCanceled();
    }

    void processVirtualStack(String outputPath) {
        ImageStack stack = this.virtualStack.getStack();
        int n = stack.getSize();
        int index = 0;
        for (int i = 1; i <= n && !IJ.escapePressed(); ++i) {
            IJ.showProgress(i, n);
            ImageProcessor ip = stack.getProcessor(i);
            if (ip == null) {
                return;
            }
            ImagePlus imp = new ImagePlus("", ip);
            if (!this.macro.equals("")) {
                WindowManager.setTempCurrentImage(imp);
                String str = IJ.runMacro("i=" + index++ + ";" + this.macro, "");
                if (str != null && str.equals("[aborted]")) break;
            }
            if (!outputPath.equals("")) {
                if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                    if (imp.getBitDepth() == 24) {
                        IJ.run(imp, "8-bit Color", "number=256");
                    } else {
                        IJ.run(imp, "8-bit", "");
                    }
                }
                IJ.saveAs(imp, format, outputPath + this.pad(i));
            }
            imp.close();
        }
        if (outputPath != null && !outputPath.equals("")) {
            IJ.run("Image Sequence...", "open=[" + outputPath + "]" + " use");
        }
    }

    String pad(int n) {
        String str = "" + n;
        while (str.length() < 5) {
            str = "0" + str;
        }
        return str;
    }

    void processFolder(String inputPath, String outputPath) {
        String[] list = new File(inputPath).list();
        int index = 0;
        for (int i = 0; i < list.length && !IJ.escapePressed(); ++i) {
            String path = inputPath + list[i];
            if (IJ.debugMode) {
                IJ.log(i + ": " + path);
            }
            if (new File(path).isDirectory() || list[i].startsWith(".") || list[i].endsWith(".avi") || list[i].endsWith(".AVI")) continue;
            IJ.showProgress(i + 1, list.length);
            ImagePlus imp = IJ.openImage(path);
            if (imp == null) continue;
            if (!this.macro.equals("")) {
                WindowManager.setTempCurrentImage(imp);
                String str = IJ.runMacro("i=" + index++ + ";" + this.macro, "");
                if (str != null && str.equals("[aborted]")) break;
            }
            if (!outputPath.equals("")) {
                if (format.equals("8-bit TIFF") || format.equals("GIF")) {
                    if (imp.getBitDepth() == 24) {
                        IJ.run(imp, "8-bit Color", "number=256");
                    } else {
                        IJ.run(imp, "8-bit", "");
                    }
                }
                IJ.saveAs(imp, format, outputPath + list[i]);
            }
            imp.close();
        }
    }

    String addSeparator(String path) {
        if (path.equals("")) {
            return path;
        }
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separator;
        }
        return path;
    }

    void validateFormat() {
        boolean validFormat = false;
        for (int i = 0; i < formats.length; ++i) {
            if (!format.equals(formats[i])) continue;
            validFormat = true;
            break;
        }
        if (!validFormat) {
            format = formats[0];
        }
    }

    void addPanels(GenericDialog gd) {
        Panel p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        if (this.virtualStack == null) {
            this.input = new Button("Input...");
            this.input.addActionListener(this);
            p.add(this.input);
            this.inputDir = new TextField(Prefs.get("batch.input", ""), 45);
            p.add(this.inputDir);
            gd.addPanel(p);
        }
        p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        this.output = new Button("Output...");
        this.output.addActionListener(this);
        p.add(this.output);
        this.outputDir = new TextField(Prefs.get("batch.output", ""), 45);
        p.add(this.outputDir);
        gd.addPanel(p);
    }

    void addButtons(GenericDialog gd) {
        Panel p = new Panel();
        p.setLayout(new FlowLayout(1, 5, 0));
        this.test = new Button("Test");
        this.test.addActionListener(this);
        p.add(this.test);
        this.open = new Button("Open...");
        this.open.addActionListener(this);
        p.add(this.open);
        this.save = new Button("Save...");
        this.save.addActionListener(this);
        p.add(this.save);
        gd.addPanel(p);
    }

    public void itemStateChanged(ItemEvent e) {
        Choice choice = (Choice)e.getSource();
        String item = choice.getSelectedItem();
        String code = null;
        if (item.equals("Convert to RGB")) {
            code = "run(\"RGB Color\");\n";
        } else if (item.equals("Measure")) {
            code = "run(\"Measure\");\n";
        } else if (item.equals("Resize")) {
            code = "run(\"Size...\", \"width=512 height=512 interpolation=Bicubic\");\n";
        } else if (item.equals("Scale")) {
            code = "scale=1.5;\nw=getWidth*scale; h=getHeight*scale;\nrun(\"Size...\", \"width=w height=h interpolation=Bilinear\");\n";
        } else if (item.equals("Label")) {
            code = "setFont(\"SansSerif\", 18, \"antialiased\");\nsetColor(\"red\");\ndrawString(\"Hello\", 20, 30);\n";
        } else if (item.equals("Timestamp")) {
            code = this.openMacroFromJar("TimeStamp.ijm");
        } else if (item.equals("Crop")) {
            code = "makeRectangle(getWidth/4, getHeight/4, getWidth/2, getHeight/2);\nrun(\"Crop\");\n";
        } else if (item.equals("Add Border")) {
            code = "border=25;\nw=getWidth+border*2; h=getHeight+border*2;\nrun(\"Canvas Size...\", \"width=w height=h position=Center zero\");\n";
        } else if (item.equals("Invert")) {
            code = "run(\"Invert\");\n";
        } else if (item.equals("Gaussian Blur")) {
            code = "run(\"Gaussian Blur...\", \"sigma=2\");\n";
        } else if (item.equals("Unsharp Mask")) {
            code = "run(\"Unsharp Mask...\", \"radius=1 mask=0.60\");\n";
        } else if (item.equals("Show File Info")) {
            code = "path=File.directory+File.name;\ndate=File.dateLastModified(path);\nsize=File.length(path);\nprint(i+\", \"+getTitle+\", \"+date+\", \"+size);\n";
        }
        if (code != null) {
            TextArea ta = this.gd.getTextArea1();
            ta.insert(code, ta.getCaretPosition());
            if (IJ.isMacOSX()) {
                ta.requestFocus();
            }
        }
    }

    String openMacroFromJar(String name) {
        ImageJ ij = IJ.getInstance();
        Class<?> c = ij != null ? ij.getClass() : new ImageStack().getClass();
        String macro = null;
        try {
            int n;
            InputStream is = c.getResourceAsStream("/macros/" + name);
            if (is == null) {
                return null;
            }
            InputStreamReader isr = new InputStreamReader(is);
            StringBuffer sb = new StringBuffer();
            char[] b = new char[8192];
            while ((n = isr.read(b)) > 0) {
                sb.append(b, 0, n);
            }
            macro = sb.toString();
        }
        catch (IOException e) {
            return null;
        }
        return macro;
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.input) {
            String path = IJ.getDirectory("Input Folder");
            if (path == null) {
                return;
            }
            this.inputDir.setText(path);
            if (IJ.isMacOSX()) {
                this.gd.setVisible(false);
                this.gd.setVisible(true);
            }
        } else if (source == this.output) {
            String path = IJ.getDirectory("Output Folder");
            if (path == null) {
                return;
            }
            this.outputDir.setText(path);
            if (IJ.isMacOSX()) {
                this.gd.setVisible(false);
                this.gd.setVisible(true);
            }
        } else if (source == this.test) {
            this.thread = new Thread((Runnable)this, "BatchTest");
            this.thread.setPriority(Math.max(this.thread.getPriority() - 2, 1));
            this.thread.start();
        } else if (source == this.open) {
            this.open();
        } else if (source == this.save) {
            this.save();
        }
    }

    void open() {
        String text = IJ.openAsString("");
        if (text == null) {
            return;
        }
        if (text.startsWith("Error: ")) {
            this.error(text.substring(7));
        } else if (text.length() > 30000) {
            this.error("File is too large");
        } else {
            this.gd.getTextArea1().setText(text);
        }
    }

    void save() {
        this.macro = this.gd.getTextArea1().getText();
        if (!this.macro.equals("")) {
            IJ.saveString(this.macro, "");
        }
    }

    void error(String msg) {
        IJ.error("Batch Processer", msg);
    }

    public void run() {
        ImagePlus imp2;
        TextArea ta = this.gd.getTextArea1();
        String macro = ta.getText();
        if (macro.equals("")) {
            this.error("There is no macro code in the text area");
            return;
        }
        ImagePlus imp = null;
        imp = this.virtualStack != null ? this.getVirtualStackImage() : this.getFolderImage();
        if (imp == null) {
            return;
        }
        WindowManager.setTempCurrentImage(imp);
        String str = IJ.runMacro("i=0;" + macro, "");
        Point loc = new Point(10, 30);
        if (this.testImage != 0 && (imp2 = WindowManager.getImage(this.testImage)) != null) {
            ImageWindow win = imp2.getWindow();
            if (win != null) {
                loc = win.getLocation();
            }
            imp2.changes = false;
            imp2.close();
        }
        imp.show();
        ImageWindow iw = imp.getWindow();
        if (iw != null) {
            iw.setLocation(loc);
        }
        this.testImage = imp.getID();
    }

    ImagePlus getVirtualStackImage() {
        ImagePlus imp = this.virtualStack.createImagePlus();
        imp.setProcessor("", this.virtualStack.getProcessor().duplicate());
        return imp;
    }

    ImagePlus getFolderImage() {
        String inputPath = this.inputDir.getText();
        File f1 = new File(inputPath = this.addSeparator(inputPath));
        if (!f1.exists() || !f1.isDirectory()) {
            this.error("Input does not exist or is not a folder\n \n" + inputPath);
            return null;
        }
        String[] list = new File(inputPath).list();
        String name = list[0];
        if (name.startsWith(".") && list.length > 1) {
            name = list[1];
        }
        String path = inputPath + name;
        this.setDirAndName(path);
        return IJ.openImage(path);
    }

    void setDirAndName(String path) {
        File f = new File(path);
        OpenDialog.setLastDirectory(f.getParent() + File.separator);
        OpenDialog.setLastName(f.getName());
    }
}

