/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.util.Tools;
import java.awt.Checkbox;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Duplicator
implements PlugIn,
TextListener {
    private static boolean duplicateStack;
    private boolean duplicateSubstack;
    private int first;
    private int last;
    private Checkbox checkbox;
    private TextField rangeField;
    private TextField[] rangeFields;
    private int firstC;
    private int lastC;
    private int firstZ;
    private int lastZ;
    private int firstT;
    private int lastT;

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        int stackSize = imp.getStackSize();
        String title = imp.getTitle();
        String newTitle = WindowManager.getUniqueName(title);
        if (!IJ.altKeyDown() || stackSize > 1) {
            if (imp.isHyperStack()) {
                this.duplicateHyperstack(imp, newTitle);
                return;
            }
            newTitle = this.showDialog(imp, "Duplicate...", "Title: ", newTitle);
        }
        if (newTitle == null) {
            return;
        }
        Roi roi = imp.getRoi();
        ImagePlus imp2 = this.duplicateSubstack && (this.first > 1 || this.last < stackSize) ? this.run(imp, this.first, this.last) : (duplicateStack || imp.getStackSize() == 1 ? this.run(imp) : this.duplicateImage(imp));
        imp2.setTitle(newTitle);
        imp2.show();
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            imp2.restoreRoi();
        }
    }

    public ImagePlus run(ImagePlus imp) {
        Overlay overlay;
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp);");
        }
        if (imp.getStackSize() == 1) {
            return this.duplicateImage(imp);
        }
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        int width = rect != null ? rect.width : imp.getWidth();
        int height = rect != null ? rect.height : imp.getHeight();
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height, imp.getProcessor().getColorModel());
        for (int i = 1; i <= stack.getSize(); ++i) {
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        int[] dim = imp.getDimensions();
        imp2.setDimensions(dim[2], dim[3], dim[4]);
        if (imp.isComposite()) {
            imp2 = new CompositeImage(imp2, 0);
            ((CompositeImage)imp2).copyLuts(imp);
        }
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(true);
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            overlay = overlay.duplicate();
            if (rect != null) {
                overlay.translate(-rect.x, -rect.y);
            }
            imp2.setOverlay(overlay);
        }
        return imp2;
    }

    ImagePlus duplicateImage(ImagePlus imp) {
        Overlay overlay;
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor ip2 = ip.crop();
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setProcessor("DUP_" + imp.getTitle(), ip2);
        String info = (String)imp.getProperty("Info");
        if (info != null) {
            imp2.setProperty("Info", info);
        }
        if (imp.getStackSize() > 1) {
            ImageStack stack = imp.getStack();
            String label = stack.getSliceLabel(imp.getCurrentSlice());
            if (label != null && label.indexOf(10) > 0) {
                imp2.setProperty("Info", label);
            }
            if (imp.isComposite()) {
                LUT lut = ((CompositeImage)imp).getChannelLut();
                imp2.getProcessor().setColorModel(lut);
            }
        }
        if ((overlay = imp.getOverlay()) != null && !imp.getHideOverlay()) {
            overlay = overlay.duplicate();
            Rectangle r = ip.getRoi();
            if (r.x > 0 || r.y > 0) {
                overlay.translate(-r.x, -r.y);
            }
            imp2.setOverlay(overlay);
        }
        return imp2;
    }

    public ImagePlus run(ImagePlus imp, int firstSlice, int lastSlice) {
        boolean tseries;
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        int width = rect != null ? rect.width : imp.getWidth();
        int height = rect != null ? rect.height : imp.getHeight();
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height, imp.getProcessor().getColorModel());
        for (int i = firstSlice; i <= lastSlice; ++i) {
            ImageProcessor ip2 = stack.getProcessor(i);
            ip2.setRoi(rect);
            ip2 = ip2.crop();
            stack2.addSlice(stack.getSliceLabel(i), ip2);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        int size = stack2.getSize();
        boolean bl = tseries = imp.getNFrames() == imp.getStackSize();
        if (tseries) {
            imp2.setDimensions(1, 1, size);
        } else {
            imp2.setDimensions(1, size, 1);
        }
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp, " + firstSlice + ", " + lastSlice + ");");
        }
        return imp2;
    }

    public ImagePlus run(ImagePlus imp, int firstC, int lastC, int firstZ, int lastZ, int firstT, int lastT) {
        Rectangle rect = null;
        Roi roi = imp.getRoi();
        if (roi != null && roi.isArea()) {
            rect = roi.getBounds();
        }
        int width = rect != null ? rect.width : imp.getWidth();
        int height = rect != null ? rect.height : imp.getHeight();
        ImageStack stack = imp.getStack();
        ImageStack stack2 = new ImageStack(width, height);
        for (int t = firstT; t <= lastT; ++t) {
            for (int z = firstZ; z <= lastZ; ++z) {
                for (int c = firstC; c <= lastC; ++c) {
                    int n1 = imp.getStackIndex(c, z, t);
                    ImageProcessor ip = stack.getProcessor(n1);
                    String label = stack.getSliceLabel(n1);
                    ip.setRoi(rect);
                    ip = ip.crop();
                    stack2.addSlice(label, ip);
                }
            }
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack("DUP_" + imp.getTitle(), stack2);
        imp2.setDimensions(lastC - firstC + 1, lastZ - firstZ + 1, lastT - firstT + 1);
        if (imp.isComposite()) {
            int mode = ((CompositeImage)imp).getMode();
            if (lastC > firstC) {
                imp2 = new CompositeImage(imp2, mode);
                int i2 = 1;
                for (int i = firstC; i <= lastC; ++i) {
                    LUT lut = ((CompositeImage)imp).getChannelLut(i);
                    ((CompositeImage)imp2).setChannelLut(lut, i2++);
                }
            } else if (firstC == lastC) {
                LUT lut = ((CompositeImage)imp).getChannelLut(firstC);
                imp2.getProcessor().setColorModel(lut);
            }
        }
        imp2.setOpenAsHyperStack(true);
        if (Recorder.record) {
            Recorder.recordCall("imp = new Duplicator().run(imp, " + firstC + ", " + lastC + ", " + firstZ + ", " + lastZ + ", " + firstT + ", " + lastT + ");");
        }
        return imp2;
    }

    String showDialog(ImagePlus imp, String title, String prompt, String defaultString) {
        int stackSize = imp.getStackSize();
        this.duplicateSubstack = stackSize > 1 && (stackSize == imp.getNSlices() || stackSize == imp.getNFrames());
        GenericDialog gd = new GenericDialog(title);
        gd.addStringField(prompt, defaultString, this.duplicateSubstack ? 15 : 20);
        if (stackSize > 1) {
            String msg = this.duplicateSubstack ? "Duplicate stack" : "Duplicate entire stack";
            gd.addCheckbox(msg, duplicateStack || imp.isComposite());
            if (this.duplicateSubstack) {
                gd.setInsets(2, 30, 3);
                gd.addStringField("Range:", "1-" + stackSize);
                Vector v = gd.getStringFields();
                this.rangeField = (TextField)v.elementAt(1);
                this.rangeField.addTextListener(this);
                this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
            }
        } else {
            duplicateStack = false;
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        title = gd.getNextString();
        if (stackSize > 1) {
            duplicateStack = gd.getNextBoolean();
            if (duplicateStack && this.duplicateSubstack) {
                String[] range = Tools.split(gd.getNextString(), " -");
                double d1 = Tools.parseDouble(range[0]);
                double d2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
                this.first = Double.isNaN(d1) ? 1 : (int)d1;
                int n = this.last = Double.isNaN(d2) ? stackSize : (int)d2;
                if (this.first < 1) {
                    this.first = 1;
                }
                if (this.last > stackSize) {
                    this.last = stackSize;
                }
                if (this.first > this.last) {
                    this.first = 1;
                    this.last = stackSize;
                }
            } else {
                this.first = 1;
                this.last = stackSize;
            }
        }
        return title;
    }

    void duplicateHyperstack(ImagePlus imp, String newTitle) {
        if ((newTitle = this.showHSDialog(imp, newTitle)) == null) {
            return;
        }
        ImagePlus imp2 = null;
        Roi roi = imp.getRoi();
        if (!duplicateStack) {
            int nChannels = imp.getNChannels();
            if (nChannels > 1 && imp.isComposite() && ((CompositeImage)imp).getMode() == 1) {
                this.firstC = 1;
                this.lastC = nChannels;
            } else {
                this.firstC = this.lastC = imp.getChannel();
            }
            this.firstZ = this.lastZ = imp.getSlice();
            this.firstT = this.lastT = imp.getFrame();
        }
        if ((imp2 = this.run(imp, this.firstC, this.lastC, this.firstZ, this.lastZ, this.firstT, this.lastT)) == null) {
            return;
        }
        imp2.setTitle(newTitle);
        imp2.show();
        if (roi != null && roi.isArea() && roi.getType() != 0) {
            imp2.restoreRoi();
        }
    }

    String showHSDialog(ImagePlus imp, String newTitle) {
        int nChannels = imp.getNChannels();
        int nSlices = imp.getNSlices();
        int nFrames = imp.getNFrames();
        GenericDialog gd = new GenericDialog("Duplicate");
        gd.addStringField("Title:", newTitle, 15);
        gd.setInsets(12, 20, 8);
        gd.addCheckbox("Duplicate hyperstack", duplicateStack);
        int nRangeFields = 0;
        if (nChannels > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Channels (c):", "1-" + nChannels);
            ++nRangeFields;
        }
        if (nSlices > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Slices (z):", "1-" + nSlices);
            ++nRangeFields;
        }
        if (nFrames > 1) {
            gd.setInsets(2, 30, 3);
            gd.addStringField("Frames (t):", "1-" + nFrames);
            ++nRangeFields;
        }
        Vector v = gd.getStringFields();
        this.rangeFields = new TextField[3];
        for (int i = 0; i < nRangeFields; ++i) {
            this.rangeFields[i] = (TextField)v.elementAt(i + 1);
            this.rangeFields[i].addTextListener(this);
        }
        this.checkbox = (Checkbox)gd.getCheckboxes().elementAt(0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        newTitle = gd.getNextString();
        duplicateStack = gd.getNextBoolean();
        if (nChannels > 1) {
            String[] range = Tools.split(gd.getNextString(), " -");
            double c1 = Tools.parseDouble(range[0]);
            double c2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
            this.firstC = Double.isNaN(c1) ? 1 : (int)c1;
            int n = this.lastC = Double.isNaN(c2) ? this.firstC : (int)c2;
            if (this.firstC < 1) {
                this.firstC = 1;
            }
            if (this.lastC > nChannels) {
                this.lastC = nChannels;
            }
            if (this.firstC > this.lastC) {
                this.firstC = 1;
                this.lastC = nChannels;
            }
        } else {
            this.lastC = 1;
            this.firstC = 1;
        }
        if (nSlices > 1) {
            String[] range = Tools.split(gd.getNextString(), " -");
            double z1 = Tools.parseDouble(range[0]);
            double z2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
            this.firstZ = Double.isNaN(z1) ? 1 : (int)z1;
            int n = this.lastZ = Double.isNaN(z2) ? this.firstZ : (int)z2;
            if (this.firstZ < 1) {
                this.firstZ = 1;
            }
            if (this.lastZ > nSlices) {
                this.lastZ = nSlices;
            }
            if (this.firstZ > this.lastZ) {
                this.firstZ = 1;
                this.lastZ = nSlices;
            }
        } else {
            this.lastZ = 1;
            this.firstZ = 1;
        }
        if (nFrames > 1) {
            String[] range = Tools.split(gd.getNextString(), " -");
            double t1 = Tools.parseDouble(range[0]);
            double t2 = range.length == 2 ? Tools.parseDouble(range[1]) : Double.NaN;
            this.firstT = Double.isNaN(t1) ? 1 : (int)t1;
            int n = this.lastT = Double.isNaN(t2) ? this.firstT : (int)t2;
            if (this.firstT < 1) {
                this.firstT = 1;
            }
            if (this.lastT > nFrames) {
                this.lastT = nFrames;
            }
            if (this.firstT > this.lastT) {
                this.firstT = 1;
                this.lastT = nFrames;
            }
        } else {
            this.lastT = 1;
            this.firstT = 1;
        }
        return newTitle;
    }

    public void textValueChanged(TextEvent e) {
        this.checkbox.setState(true);
    }
}

