/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.Plot;
import ij.io.OpenDialog;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Fitter
extends PlugInFrame
implements PlugIn,
ItemListener,
ActionListener {
    Choice fit;
    Button doIt;
    Button open;
    Button apply;
    Checkbox settings;
    String fitTypeStr = CurveFitter.fitList[0];
    TextArea textArea;
    double[] dx = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
    double[] dy = new double[]{0.0, 0.9, 4.5, 8.0, 18.0, 24.0};
    double[] x;
    double[] y;
    static CurveFitter cf;
    static int fitType;
    static String equation;
    static final int USER_DEFINED = 100;

    public Fitter() {
        super("Curve Fitter");
        WindowManager.addWindow(this);
        Panel panel = new Panel();
        this.fit = new Choice();
        for (int i = 0; i < CurveFitter.fitList.length; ++i) {
            this.fit.addItem(CurveFitter.fitList[i]);
        }
        this.fit.addItem("*User-defined*");
        this.fit.addItemListener(this);
        panel.add(this.fit);
        this.doIt = new Button(" Fit ");
        this.doIt.addActionListener(this);
        panel.add(this.doIt);
        this.open = new Button("Open");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.apply = new Button("Apply");
        this.apply.addActionListener(this);
        panel.add(this.apply);
        this.settings = new Checkbox("Show settings", false);
        panel.add(this.settings);
        this.add("North", panel);
        String text = "";
        for (int i = 0; i < this.dx.length; ++i) {
            text = text + IJ.d2s(this.dx[i], 2) + "  " + IJ.d2s(this.dy[i], 2) + "\n";
        }
        this.textArea = new TextArea("", 15, 30, 1);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        if (IJ.isLinux()) {
            this.textArea.setBackground(Color.white);
        }
        this.textArea.append(text);
        this.add("Center", this.textArea);
        this.pack();
        GUI.center(this);
        this.show();
        IJ.register(Fitter.class);
    }

    public void doFit(int fitType) {
        if (fitType >= CurveFitter.fitList.length) {
            fitType = 100;
        }
        Fitter.fitType = fitType;
        if (!this.getData()) {
            return;
        }
        cf = new CurveFitter(this.x, this.y);
        if (fitType == 100) {
            String eqn = this.getEquation();
            if (eqn == null) {
                return;
            }
            int params = cf.doCustomFit(eqn, null, this.settings.getState());
            if (params == 0) {
                return;
            }
        } else {
            cf.doFit(fitType, this.settings.getState());
        }
        IJ.log(cf.getResultString());
        Fitter.plot(cf);
    }

    String getEquation() {
        GenericDialog gd = new GenericDialog("Formula");
        gd.addStringField("Formula:", equation, 38);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        equation = gd.getNextString();
        return equation;
    }

    public static void plot(CurveFitter cf) {
        double[] x = cf.getXPoints();
        double[] y = cf.getYPoints();
        double[] a = Tools.getMinMax(x);
        double xmin = a[0];
        double xmax = a[1];
        a = Tools.getMinMax(y);
        double ymin = a[0];
        double ymax = a[1];
        float[] px = new float[100];
        float[] py = new float[100];
        double inc = (xmax - xmin) / 99.0;
        double tmp = xmin;
        for (int i = 0; i < 100; ++i) {
            px[i] = (float)tmp;
            tmp += inc;
        }
        double[] params = cf.getParams();
        for (int i = 0; i < 100; ++i) {
            py[i] = (float)cf.f(params, px[i]);
        }
        a = Tools.getMinMax(py);
        ymin = Math.min(ymin, a[0]);
        ymax = Math.max(ymax, a[1]);
        Plot plot = new Plot(cf.getFormula(), "X", "Y", px, py);
        plot.setLimits(xmin, xmax, ymin, ymax);
        plot.addPoints(x, y, 0);
        double yloc = 0.1;
        double yinc = 0.085;
        plot.addLabel(0.02, yloc, cf.getName());
        plot.addLabel(0.02, yloc += yinc, cf.getFormula());
        yloc += yinc;
        double[] p = cf.getParams();
        int n = cf.getNumParams();
        char pChar = 'a';
        for (int i = 0; i < n; ++i) {
            plot.addLabel(0.02, yloc, pChar + "=" + IJ.d2s(p[i], 4));
            yloc += yinc;
            pChar = (char)(pChar + '\u0001');
        }
        plot.addLabel(0.02, yloc, "R^2=" + IJ.d2s(cf.getRSquared(), 3));
        yloc += yinc;
        plot.show();
    }

    double sqr(double x) {
        return x * x;
    }

    boolean getData() {
        this.textArea.selectAll();
        String text = this.textArea.getText();
        text = this.zapGremlins(text);
        this.textArea.select(0, 0);
        StringTokenizer st = new StringTokenizer(text, " \t\n\r,");
        int nTokens = st.countTokens();
        if (nTokens < 4 || nTokens % 2 != 0) {
            return false;
        }
        int n = nTokens / 2;
        this.x = new double[n];
        this.y = new double[n];
        for (int i = 0; i < n; ++i) {
            this.x[i] = this.getNum(st);
            this.y[i] = this.getNum(st);
        }
        return true;
    }

    void applyFunction() {
        if (cf == null) {
            IJ.error("No function available");
            return;
        }
        ImagePlus img = WindowManager.getCurrentImage();
        if (img == null) {
            IJ.noImage();
            return;
        }
        if (img.getTitle().startsWith("y=")) {
            IJ.error("First select the image to be transformed");
            return;
        }
        double[] p = cf.getParams();
        int width = img.getWidth();
        int height = img.getHeight();
        int size = width * height;
        float[] data = new float[size];
        ImageProcessor ip = img.getProcessor();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float value = ip.getPixelValue(x, y);
                data[y * width + x] = (float)cf.f(p, value);
            }
        }
        FloatProcessor ip2 = new FloatProcessor(width, height, data, ip.getColorModel());
        new ImagePlus(img.getTitle() + "-transformed", ip2).show();
    }

    double getNum(StringTokenizer st) {
        Double d;
        String token = st.nextToken();
        try {
            d = new Double(token);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void open() {
        OpenDialog od = new OpenDialog("Open Text File...", "");
        String directory = od.getDirectory();
        String name = od.getFileName();
        if (name == null) {
            return;
        }
        String path = directory + name;
        this.textArea.selectAll();
        this.textArea.setText("");
        try {
            String s;
            BufferedReader r = new BufferedReader(new FileReader(directory + name));
            while ((s = r.readLine()) != null && s.length() <= 100) {
                this.textArea.append(s + "\n");
            }
        }
        catch (Exception e) {
            IJ.error(e.getMessage());
            return;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.fitTypeStr = this.fit.getSelectedItem();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.doIt) {
            this.doFit(this.fit.getSelectedIndex());
        } else if (e.getSource() == this.apply) {
            this.applyFunction();
        } else {
            this.open();
        }
    }

    String zapGremlins(String text) {
        char[] chars = new char[text.length()];
        chars = text.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n' || c == '\t' || c >= ' ' && c <= '\u007f') continue;
            ++count;
            chars[i] = 32;
        }
        if (count > 0) {
            return new String(chars);
        }
        return text;
    }

    static {
        equation = "y = a + b*x + c*x*x";
    }
}

