/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dcm4che2.data.DicomObject;
import org.nrg.dcm.DicomSessionVariable;
import org.nrg.dcm.edit.Value;
import org.nrg.dcm.edit.Variable;
import org.nrg.upload.data.SessionVariable;

public final class SessionVariableValue
implements Value {
    private final Set<?> tags;
    private final Set<?> variables;
    private SessionVariable variable;

    public SessionVariableValue(SessionVariable source) {
        if (source instanceof DicomSessionVariable) {
            DicomSessionVariable dsv = (DicomSessionVariable)source;
            this.tags = Collections.unmodifiableSet(dsv.getTags());
            this.variables = Collections.unmodifiableSet(dsv.getVariables());
        } else {
            this.tags = Collections.emptySet();
            this.variables = Collections.emptySet();
        }
        this.variable = source;
    }

    public SortedSet getTags() {
        return new TreeSet(this.tags);
    }

    public Set getVariables() {
        return this.variables;
    }

    public String on(DicomObject o) {
        return this.variable.getValue();
    }

    public String on(Map m) {
        return this.variable.getValue();
    }

    public void replace(Variable _) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("[").append(this.variable).append("]");
        return sb.toString();
    }
}

