/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.dcm;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ChoiceFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.dcm4che2.data.DicomObject;
import org.json.JSONException;
import org.json.JSONObject;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.nrg.dcm.DicomSessionVariable;
import org.nrg.dcm.Entity;
import org.nrg.dcm.MapEntity;
import org.nrg.dcm.Series;
import org.nrg.dcm.edit.DicomUtils;
import org.nrg.dcm.edit.ScriptApplicator;
import org.nrg.dcm.edit.Variable;
import org.nrg.io.HttpUploadException;
import org.nrg.io.UploadStatisticsReporter;
import org.nrg.io.dcm.ZipSeriesUploader;
import org.nrg.net.HttpException;
import org.nrg.net.JSONRequestConnectionProcessor;
import org.nrg.net.RestServer;
import org.nrg.upload.data.AssignedSessionVariable;
import org.nrg.upload.data.Project;
import org.nrg.upload.data.Session;
import org.nrg.upload.data.SessionVariable;
import org.nrg.upload.data.Subject;
import org.nrg.upload.data.UploadAbortedException;
import org.nrg.upload.data.UploadFailureHandler;
import org.nrg.upload.ui.UploadResultPanel;
import org.nrg.util.AutoArchive;
import org.nrg.util.MapRegistry;
import org.nrg.util.Registry;
import org.nrg.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Study
extends MapEntity
implements Entity,
Session {
    public static final int MAX_TAG = Collections.max(new ArrayList<Integer>(){
        {
            this.add(524368);
            this.add(524320);
            this.add(528432);
            this.add(0x200010);
            this.add(0x20000D);
            this.add(524336);
        }
    });
    public static final String PREVENT_ANON = "prevent_anon";
    public static final String PREVENT_AUTO_COMMIT = "prevent_auto_commit";
    public static final String SOURCE = "SOURCE";
    private final Logger logger = LoggerFactory.getLogger(Study.class);
    private final Registry<Series> series = new MapRegistry(new TreeMap());
    private final Date dateTime;

    public Study(String uid, Date dateTime, String id, String accessionNumber, String description) {
        this.put(0x20000D, (Object)uid);
        this.dateTime = dateTime;
        if (null != dateTime) {
            this.put(524320, (Object)new SimpleDateFormat("yyyyMMdd").format(dateTime));
            this.put(524336, (Object)new SimpleDateFormat("HHmmss").format(dateTime));
        }
        this.put(0x200010, (Object)id);
        this.put(524368, (Object)accessionNumber);
        this.put(528432, (Object)description);
    }

    public Study(DicomObject o) {
        this(o.getString(0x20000D), DicomUtils.getDateTime((DicomObject)o, (int)524320, (int)524336), o.getString(0x200010), o.getString(524368), o.getString(528432));
    }

    public boolean equals(Object o) {
        return o instanceof Study && Objects.equal((Object)this.get(0x20000D), (Object)((Study)o).get(0x20000D));
    }

    @Override
    public String getAccession() {
        return (String)this.get(524368);
    }

    @Override
    public Date getDateTime() {
        return this.dateTime;
    }

    @Override
    public TimeZone getTimeZone() {
        return null;
    }

    @Override
    public String getDescription() {
        return (String)this.get(528432);
    }

    @Override
    public int getFileCount() {
        int count = 0;
        for (Series s : this.series) {
            count += s.getFileCount();
        }
        return count;
    }

    @Override
    public String getFormat() {
        return "DICOM";
    }

    @Override
    public String getID() {
        return (String)this.get(0x200010);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.get(0x20000D)});
    }

    @Override
    public Set<String> getModalities() {
        LinkedHashSet modalities = Sets.newLinkedHashSet();
        for (Series s : this.series) {
            modalities.addAll(s.getModalities());
        }
        return modalities;
    }

    @Override
    public int getScanCount() {
        return this.series.size();
    }

    public Series getSeries(DicomObject o, File f) {
        Series s = this.series.get(new Series(this, o));
        s.addFile(f, o);
        return s;
    }

    @Override
    public Collection<Series> getSeries() {
        return this.series.getAll();
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (Series s : this.series) {
            size += s.getSize();
        }
        return size;
    }

    @Override
    public Collection<Study> getStudies() {
        return Collections.singleton(this);
    }

    public String toString() {
        Object description;
        StringBuilder builder = new StringBuilder("DICOM study ");
        Object studyId = this.get(0x200010);
        builder.append(studyId);
        Object accessionNumber = this.get(524368);
        if (null != accessionNumber) {
            builder.append(" (").append(accessionNumber).append(")");
        }
        if (null != (description = this.get(528432))) {
            builder.append(" ").append(description);
        }
        if (null == studyId && null == accessionNumber) {
            builder.append(" [").append(this.get(0x20000D)).append("]");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean uploadTo(Map<?, ?> params, UploadFailureHandler failureHandler, ResultProgressHandle progress) {
        long uploadStart = new Date().getTime();
        try {
            URL dataPostURL;
            Iterable<ScriptApplicator> applicators;
            int fileCount = this.getFileCount();
            progress.setProgress(0, fileCount);
            progress.setBusy("Building session manifest");
            ArrayList uploads = Lists.newArrayList((Iterable)Iterables.filter(this.series, (Predicate)new Predicate<Series>(){

                public boolean apply(Series s) {
                    return s.isUploadAllowed();
                }
            }));
            if (uploads.isEmpty()) {
                progress.failed("No files were selected for upload", true);
                boolean bl = false;
                return bl;
            }
            Project project = (Project)params.get("project");
            Subject subject = (Subject)params.get("subject");
            String session = ((SessionVariable)params.get("session")).getValue();
            String visit = null;
            if (params.get("*visit*") != null) {
                visit = ((SessionVariable)params.get("*visit*")).getValue();
            }
            String protocol = null;
            if (params.get("*protocol*") != null) {
                protocol = ((SessionVariable)params.get("*protocol*")).getValue();
            }
            try {
                applicators = project.getDicomScriptApplicators();
            }
            catch (RuntimeException exception) {
                this.logger.error("problem retrieving script applicator", (Throwable)exception);
                throw exception;
            }
            catch (Exception exception) {
                this.logger.error("problem retrieving script applicator", (Throwable)exception);
                throw new RuntimeException(exception);
            }
            String adminEmail = (String)params.get("*xnat-admin-email*");
            URL baseURL = (URL)params.get("*xnat-url*");
            try {
                StringBuilder buffer = new StringBuilder(baseURL.toString());
                buffer.append("/REST/services/import?import-handler=DICOM-zip");
                buffer.append("&PROJECT_ID=").append(project);
                buffer.append("&SUBJECT_ID=").append(subject);
                buffer.append("&EXPT_LABEL=").append(session);
                if (!Strings.isNullOrEmpty((String)visit)) {
                    buffer.append("&VISIT=").append(visit);
                }
                if (!Strings.isNullOrEmpty((String)protocol)) {
                    buffer.append("&PROTOCOL=").append(protocol);
                }
                buffer.append("&rename=true&prevent_anon=true&prevent_auto_commit=true&SOURCE=applet");
                if (params.containsKey("autoArchive")) {
                    AutoArchive autoArchive = (AutoArchive)((Object)params.get("autoArchive"));
                    buffer.append("&").append("autoArchive").append("=").append((Object)autoArchive);
                }
                dataPostURL = new URL(buffer.toString());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            boolean useFixedSize = (Boolean)params.get("*fixed-size-streaming*");
            int nThreads = (Integer)params.get("*n-upload-threads*");
            progress.setBusy("Preparing upload...");
            this.logger.trace("creating thread pool and executors");
            ExecutorService executor = Executors.newFixedThreadPool(nThreads);
            ExecutorCompletionService<Set<String>> completionService = new ExecutorCompletionService<Set<String>>(executor);
            HashMap uploaders = Maps.newHashMap();
            this.logger.trace("submitting uploaders for {}", (Object)uploads);
            UploadStatisticsReporter stats = new UploadStatisticsReporter(progress);
            for (Series s : uploads) {
                stats.addToSend(s.getSize());
                ZipSeriesUploader uploader = new ZipSeriesUploader(dataPostURL, useFixedSize, s, applicators, stats, (RestServer)params.get("*xnat-rest-server*"));
                uploaders.put(completionService.submit(uploader), uploader);
            }
            LinkedHashSet uris = Sets.newLinkedHashSet();
            LinkedHashMap failures = Maps.newLinkedHashMap();
            while (progress.isRunning() && !uploaders.isEmpty()) {
                Future future;
                try {
                    future = completionService.take();
                    this.logger.trace("retrieved completed future {}", future);
                }
                catch (InterruptedException e) {
                    this.logger.debug("upload completion poll interrupted", (Throwable)e);
                    continue;
                }
                try {
                    Set us = (Set)future.get();
                    this.logger.debug("{} completed -> {}", uploaders.get(future), (Object)us);
                    uris.addAll(us);
                    uploaders.remove(future);
                }
                catch (InterruptedException e) {
                    this.logger.info("upload interrupted or timed out, retrying");
                    completionService.submit((Callable)uploaders.get(future));
                }
                catch (ExecutionException exception) {
                    executor.shutdownNow();
                    Throwable cause = exception.getCause();
                    failures.put(((ZipSeriesUploader)uploaders.remove(future)).getSeries(), cause);
                    future.cancel(true);
                    UploadAbortedException aborted = cause instanceof UploadAbortedException ? (UploadAbortedException)cause : new UploadAbortedException(cause);
                    this.logger.info("upload aborted: shutting down executor", cause);
                    for (Map.Entry me : uploaders.entrySet()) {
                        ((Future)me.getKey()).cancel(true);
                        failures.put(((ZipSeriesUploader)me.getValue()).getSeries(), aborted);
                    }
                    String message = Study.buildFailureMessage(failures);
                    progress.failed(message, false);
                    boolean bl = false;
                    long duration = (new Date().getTime() - uploadStart) / 1000L;
                    this.logger.info("upload operation complete after {} sec", (Object)duration);
                    return bl;
                }
            }
            if (!uploaders.isEmpty()) {
                this.logger.error("progress failed before uploaders complete: {}", (Object)uploaders);
                boolean future = false;
                return future;
            }
            if (1 == uris.size()) {
                String uri = (String)uris.iterator().next();
                try {
                    URL url = new URL(baseURL.toString() + uri);
                    boolean bl = this.closeSession(url, params, progress, failures);
                    return bl;
                }
                catch (MalformedURLException e) {
                    progress.failed("<p>The XNAT server provided an invalid response</p><p>" + uri + "</p>" + "<p>Please contact the system manager (" + adminEmail + ") for help.</p>", false);
                    boolean bl = false;
                    long duration = (new Date().getTime() - uploadStart) / 1000L;
                    this.logger.info("upload operation complete after {} sec", (Object)duration);
                    return bl;
                }
            }
            this.logger.error("Server reports unexpected session count {}: {}", (Object)uris.size(), (Object)uris);
            progress.failed("<p>The XNAT server reported receiving an unexpected number of sessions: (" + uris.size() + ")</p>" + "<p>Please contact the system manager (" + adminEmail + ") for help.</p>", false);
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            long duration = (new Date().getTime() - uploadStart) / 1000L;
            this.logger.info("upload operation complete after {} sec", (Object)duration);
        }
    }

    private JSONObject buildCommitEntity(Map<?, ?> params) {
        JSONObject entity = new JSONObject();
        Collection vars = (Collection)params.get("*session-variables*");
        if (null == vars) {
            this.logger.error("session variables not assigned in {}", params);
        } else {
            for (Object o : vars) {
                SessionVariable v;
                String path;
                if (!(o instanceof SessionVariable) || Strings.isNullOrEmpty((String)(path = (v = (SessionVariable)o).getExportField()))) continue;
                try {
                    entity.put(path, (Object)v.getValue());
                }
                catch (JSONException exception) {
                    String message = "unable to assign session variable " + path;
                    this.logger.error(message, (Throwable)exception);
                }
            }
        }
        this.logger.trace("Built commit entity: {}", (Object)entity);
        return entity;
    }

    public static String getWebAppRelativePath(URL url, String path) {
        StringBuilder buffer = new StringBuilder(path);
        while ('/' == buffer.charAt(0)) {
            buffer.deleteCharAt(0);
        }
        String context = url.getPath();
        boolean pathHasContext = true;
        for (int i = 0; i < context.length(); ++i) {
            if (context.charAt(i) == path.charAt(i)) continue;
            pathHasContext = false;
            break;
        }
        if (pathHasContext) {
            buffer.delete(0, context.length());
        }
        while ('/' == buffer.charAt(0)) {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    public static URL buildSessionViewURL(URL url, String relativePath) {
        String[] components = relativePath.split("/");
        if (!"data".equals(components[0]) && !"REST".equals(components[0])) {
            LoggerFactory.getLogger(Study.class).warn("Strange session path {}: first component is neither \"data\" nor \"REST\"", (Object)relativePath);
        }
        if ("prearchive".equals(components[1])) {
            try {
                return new URL(url.toString() + "?screen=XDATScreen_uploaded_xnat_imageSessionData.vm");
            }
            catch (MalformedURLException e) {
                LoggerFactory.getLogger(Study.class).error("can't build prearchive session view url for " + url, (Throwable)e);
                return url;
            }
        }
        return url;
    }

    private boolean closeSession(URL url, Map<?, ?> params, ResultProgressHandle progress, Map<?, ?> failures) {
        String adminEmail = (String)params.get("*xnat-admin-email*");
        String session = ((SessionVariable)params.get("session")).getValue();
        try {
            if (failures.isEmpty()) {
                progress.setBusy("Committing session");
                this.logger.trace("committing session {}", (Object)url);
                RestServer xnat = (RestServer)params.get("*xnat-rest-server*");
                JSONRequestConnectionProcessor handler = new JSONRequestConnectionProcessor(this.buildCommitEntity(params));
                String queryParams = "?action=commit&SOURCE=applet";
                if (null != params.get("*visit*") && !Strings.isNullOrEmpty((String)((AssignedSessionVariable)params.get("*visit*")).getValue())) {
                    queryParams = queryParams + "&VISIT=" + ((AssignedSessionVariable)params.get("*visit*")).getValue();
                }
                if (null != params.get("*protocol*") && !Strings.isNullOrEmpty((String)((AssignedSessionVariable)params.get("*protocol*")).getValue())) {
                    queryParams = queryParams + "&PROTOCOL=" + ((AssignedSessionVariable)params.get("*protocol*")).getValue();
                }
                xnat.doPost(Study.getWebAppRelativePath(xnat.getURL(), url.getPath()) + queryParams, handler);
                String response = handler.getResponseEntity();
                String resultPath = Study.getWebAppRelativePath(xnat.getURL(), response);
                URL result = new URL(xnat.getURL() + "/" + resultPath);
                UploadResultPanel resultPanel = new UploadResultPanel(session, Study.buildSessionViewURL(result, resultPath));
                progress.finished((Object)Summary.create((Component)resultPanel, (Object)url));
                return true;
            }
            progress.failed(Study.buildFailureMessage(failures), false);
            return false;
        }
        catch (JSONException e) {
            this.logger.error("unable to write commit request entity", (Throwable)e);
            return false;
        }
        catch (HttpException e) {
            this.logger.error("session commit failed", (Throwable)e);
            switch (e.getResponseCode()) {
                case 404: {
                    StringBuilder sb = new StringBuilder("<h3>Resource not found (404)</h3>");
                    sb.append("<p>The server at ");
                    Study.appendServer(sb, url);
                    sb.append(" is accessible but reports that the session resource ");
                    sb.append(url.getPath());
                    sb.append(" does not exist.</p>");
                    sb.append("<p>Contact the administrator ");
                    sb.append("<").append(adminEmail).append(">");
                    sb.append(" for help.</p>");
                    progress.failed(sb.toString(), true);
                    return false;
                }
                case 500: {
                    StringBuilder sb = new StringBuilder("<h3>Internal Server Error (500)</h3>");
                    sb.append("<p>The server at ");
                    Study.appendServer(sb, url);
                    sb.append(" is accessible but was unable to commit the requested session");
                    sb.append(" due to an internal error.</p>");
                    sb.append("<p>Please contact the administrator ");
                    sb.append("<").append(adminEmail).append(">");
                    sb.append(" for help.");
                    sb.append(" A detailed description of the problem should be available");
                    sb.append(" in the DICOM receiver log or the XNAT logs.</p>");
                    progress.failed(sb.toString(), true);
                    return false;
                }
                case 409: {
                    StringBuilder sb = new StringBuilder("<h3>Session data conflict</h3>");
                    sb.append("<p>The server at ");
                    Study.appendServer(sb, url);
                    sb.append(" reports a conflict between the uploaded data and a session in the archive.</p>");
                    sb.append("<p>All or part of this session was previously uploaded. Go to the prearchive page ");
                    sb.append("to archive the data just uploaded as a new session, or to merge it into an existing session.");
                    progress.failed(sb.toString(), true);
                    return false;
                }
            }
            progress.failed("<h3>Unexpected error " + e.getResponseCode() + ": " + e.getMessage() + "</h3>" + "<p>Unable to commit uploaded session</p>" + "<p>Please contact your XNAT administrator " + "<" + adminEmail + ">" + " for help.</p>", true);
            return false;
        }
        catch (IOException e) {
            this.logger.error("Session commit failed", (Throwable)e);
            StringBuilder sb = new StringBuilder("<h3>Communications error</h3>");
            sb.append("<p>The server at ");
            Study.appendServer(sb, url);
            sb.append(" is inaccessible (");
            sb.append(e.getMessage());
            sb.append("). Please contact your XNAT administrator ");
            sb.append("<").append(adminEmail).append(">");
            sb.append(" for help.</p>");
            progress.failed(sb.toString(), false);
            return false;
        }
        catch (Throwable t) {
            this.logger.error("Session commit failed", t);
            progress.failed("<h3>Error in applet</h3><p>An error in the uploader (" + t + " prevented the session from being committed." + " Please contact your XNAT administrator " + "<" + adminEmail + ">" + " for help.</p>", false);
            return false;
        }
    }

    public static StringBuilder appendServer(StringBuilder sb, URL url) {
        sb.append(url.getProtocol()).append("://");
        sb.append(url.getHost());
        int httpPort = url.getPort();
        if (-1 != httpPort && httpPort != url.getDefaultPort()) {
            sb.append(":").append(httpPort);
        }
        return sb;
    }

    public static StringBuilder appendServer(StringBuilder sb, RestServer xnat) {
        return Study.appendServer(sb, xnat.getURL());
    }

    private static <T> StringBuilder buildHTMLFailureMessage(StringBuilder sb, Map<?, T> failures) {
        LinkedHashMultimap inverse = LinkedHashMultimap.create();
        Multimaps.invertFrom((Multimap)Multimaps.forMap(failures), (Multimap)inverse);
        Multimap causes = Utils.consolidateKeys(inverse, 4);
        MessageFormat format = new MessageFormat("{0} not uploaded: {1}");
        format.setFormatByArgumentIndex(0, new ChoiceFormat(new double[]{0.0, 1.0, 2.0}, new String[]{"No items", "One item", "{0,number} items"}));
        for (Object key : causes.keySet()) {
            Object message;
            Collection items = causes.get(key);
            if (key instanceof HttpUploadException) {
                HttpUploadException e = (HttpUploadException)key;
                StringBuilder m = new StringBuilder("HTTP error ");
                m.append(e.getStatusCode()).append(" - ");
                m.append(e.getMessage()).append("<br>");
                m.append(e.getEntity());
                message = m;
            } else {
                message = key;
            }
            sb.append("<p>").append(format.format(new Object[]{items.size(), message}));
            sb.append("</p><br>");
        }
        return sb;
    }

    public static <T> String buildFailureMessage(Map<?, T> failures) {
        StringBuilder sb = new StringBuilder("<html>");
        Study.buildHTMLFailureMessage(sb, failures);
        return sb.append("</html>").toString();
    }

    @Override
    public List<SessionVariable> getVariables(Map<?, ?> params) {
        Project project = (Project)params.get("project");
        LinkedHashSet dvs = Sets.newLinkedHashSet();
        try {
            Iterable<ScriptApplicator> applicators = project.getDicomScriptApplicators();
            for (ScriptApplicator a : applicators) {
                for (Variable v : dvs) {
                    a.unify(v);
                }
                dvs.addAll(a.getVariables().values());
            }
        }
        catch (Throwable t) {
            this.logger.warn("unable to load script", t);
            return Collections.emptyList();
        }
        DicomObject o = this.series.isEmpty() ? null : this.series.get(0).getSampleObject();
        ArrayList vs = Lists.newArrayList();
        for (Variable dv : dvs) {
            vs.add(DicomSessionVariable.getSessionVariable(dv, o));
        }
        return vs;
    }
}

