/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.ecat;

import java.util.Collections;
import java.util.Set;
import org.nrg.ecat.TextEcatVariable;
import org.nrg.ecat.edit.MultipleInitializationException;
import org.nrg.ecat.edit.Value;
import org.nrg.ecat.edit.Variable;
import org.nrg.upload.data.AbstractSessionVariable;
import org.nrg.upload.data.SessionVariable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EcatSessionVariable
extends AbstractSessionVariable
implements SessionVariable {
    private final Logger logger = LoggerFactory.getLogger(EcatSessionVariable.class);
    private final Variable variable;
    private String message = null;

    public EcatSessionVariable(Variable variable) {
        super(variable.getName());
        this.variable = variable;
    }

    public static SessionVariable getSessionVariable(Variable v) {
        return new TextEcatVariable(v);
    }

    @Override
    public String getExportField() {
        return this.variable.getExportField();
    }

    @Override
    public String getValue() {
        this.logger.trace("getting value for " + this);
        Object value = this.variable.getValue();
        if (null == value) {
            Value iv = this.variable.getInitialValue();
            this.logger.trace("no value set; evaluating initial value " + iv);
            if (null == iv) {
                return null;
            }
            try {
                Object ivo = iv.on(Collections.emptyMap());
                this.logger.trace("initial value = " + ivo);
                return null == ivo ? null : ivo.toString();
            }
            catch (Throwable t) {
                this.logger.warn("unable to evaluate initial value " + iv, t);
                return null;
            }
        }
        return value.toString();
    }

    @Override
    public String getValueMessage() {
        return this.message;
    }

    public boolean hasInitialValue() {
        return null != this.variable.getInitialValue();
    }

    @Override
    public boolean isHidden() {
        return this.variable.isHidden();
    }

    @Override
    public String setValue(String value) throws SessionVariable.InvalidValueException {
        Object old = this.variable.getValue();
        this.variable.setValue((Object)value);
        return null == old ? null : old.toString();
    }

    public void setInitialValue(Value value) throws MultipleInitializationException {
        this.variable.setInitialValue(value);
    }

    public void setIsHidden(boolean isHidden) {
        this.variable.setIsHidden(isHidden);
    }

    public Set<?> getVariables() {
        Value iv = this.variable.getInitialValue();
        return null == iv ? Collections.emptySet() : iv.getVariables();
    }

    protected void editTo(String value) {
        try {
            this.message = this.validate(value);
            this.variable.setValue((Object)value);
            this.fireHasChanged();
        }
        catch (SessionVariable.InvalidValueException e) {
            this.fireIsInvalid(this.variable, e.getMessage());
        }
    }

    public String toString() {
        return super.toString() + " (" + this.variable + ")";
    }
}

