/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.nrg.io.HttpUtils;

public final class HttpUploadException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final int statusCode;
    private final String entity;

    public HttpUploadException(int statusCode, String message, String entity) {
        super(message);
        this.statusCode = statusCode;
        this.entity = entity;
    }

    public HttpUploadException(HttpURLConnection connection) throws IOException {
        this(connection.getResponseCode(), connection.getResponseMessage(), HttpUtils.readEntity(connection));
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getEntity() {
        return this.entity;
    }

    @Override
    public String toString() {
        return super.toString() + "\nMessage entity:\n" + this.entity;
    }
}

