/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.io.dcm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.StopTagInputHandler;
import org.nrg.dcm.DicomUtils;
import org.nrg.dcm.Series;
import org.nrg.dcm.Study;
import org.nrg.io.Trawler;
import org.nrg.io.dcm.ZipSeriesUploader;
import org.nrg.net.xnat.SeriesImportFilterApplicatorRetriever;
import org.nrg.upload.data.Session;
import org.nrg.upload.ui.SessionReviewPanel;
import org.nrg.util.EditProgressMonitor;
import org.nrg.util.MapRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DicomTrawler
implements Trawler {
    public static final int MAX_TAG = Collections.max(new ArrayList<Integer>(){
        {
            this.add(0x200012);
            this.add(524310);
            this.add(528446);
        }
    });
    public static final int APP_MAX_TAG = Collections.max(new ArrayList<Integer>(){
        {
            this.add(MAX_TAG);
            this.add(Series.MAX_TAG);
            this.add(SessionReviewPanel.MAX_TAG);
            this.add(Study.MAX_TAG);
            this.add(ZipSeriesUploader.MAX_TAG);
        }
    });
    private SeriesImportFilterApplicatorRetriever _filters;
    private final Logger logger = LoggerFactory.getLogger(DicomTrawler.class);

    @Override
    public Collection<Session> trawl(Iterator<File> files, EditProgressMonitor pm) {
        return this.trawl(files, null, pm);
    }

    @Override
    public Collection<Session> trawl(Iterator<File> files, Collection<File> remaining, EditProgressMonitor pm) {
        MapRegistry<Study> studies = new MapRegistry<Study>();
        while (files.hasNext()) {
            DicomObject o;
            if (null != pm && pm.isCanceled()) {
                return new ArrayList<Session>();
            }
            File f = files.next();
            if (!f.isFile()) continue;
            try {
                o = DicomUtils.read((File)f, (DicomInputHandler)new StopTagInputHandler(APP_MAX_TAG + 1));
            }
            catch (IOException e) {
                remaining.add(f);
                continue;
            }
            catch (Exception e) {
                remaining.add(f);
                continue;
            }
            assert (null != o.getString(524310));
            if (this._filters != null) {
                this.logger.debug("Found series import filters, testing series for inclusion/exclusion.");
                String description = o.getString(528446);
                this.logger.debug("Found series description: {}", (Object)description);
                if (this._filters.checkSeries(description)) {
                    this.logger.info("Series description {} matched series import filter restrictions, including in session", (Object)description);
                    Study study = studies.get(new Study(o));
                    study.getSeries(o, f);
                    continue;
                }
                this.logger.info("Series description {} did not match series import filter restrictions, excluding from session", (Object)description);
                continue;
            }
            this.logger.info("Series import filters not found, including series in session");
            Study study = studies.get(new Study(o));
            study.getSeries(o, f);
        }
        return new ArrayList<Session>(studies.getAll());
    }

    public void setSeriesImportFilters(SeriesImportFilterApplicatorRetriever filters) {
        this._filters = filters;
    }
}

