/*
 * Decompiled with CFR 0.152.
 */
package org.nrg.net;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.nrg.IOUtils;
import org.nrg.net.ConflictHttpException;
import org.nrg.net.EmptyRequest;
import org.nrg.net.HttpException;
import org.nrg.net.HttpURLConnectionProcessor;
import org.nrg.net.JSESSIONIDCookie;
import org.nrg.net.JSONResultExtractor;
import org.nrg.net.StreamUploadProcessor;
import org.nrg.net.StringResponseProcessor;
import org.nrg.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServer {
    private static final Pattern userInfoPattern = Pattern.compile("([^:@/]*):([^:@]*)");
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    static final String TITLE;
    static final String VERSION;
    private static final Map<String, String> defaultHeaders;
    private final Logger logger = LoggerFactory.getLogger(RestServer.class);
    private final URL _base;
    private final JSESSIONIDCookie _jsessionidCookie;
    private String _siteWideAnonScript = null;
    private final Map<Service, PasswordAuthentication> passStore = Maps.newHashMap();
    private final Map<Service, String> descriptions = Maps.newHashMap();

    public RestServer(URL url, JSESSIONIDCookie jsessionidCookie) {
        Matcher m;
        StringBuilder sb = new StringBuilder(url.toString());
        int i = sb.length() - 1;
        while ('/' == sb.charAt(i)) {
            sb.deleteCharAt(i);
            --i;
        }
        try {
            this._base = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        String userInfo = url.getUserInfo();
        if (null != userInfo && (m = userInfoPattern.matcher(userInfo)).matches()) {
            Service service = new Service(url);
            PasswordAuthentication auth = new PasswordAuthentication(m.group(1), m.group(2).toCharArray());
            this.passStore.put(service, auth);
        }
        this._jsessionidCookie = jsessionidCookie;
    }

    public RestServer(String url, JSESSIONIDCookie jsessionidCookie) throws MalformedURLException {
        this(new URL(url), jsessionidCookie);
    }

    public Map<String, Object> getSeriesImportFilter(String path) throws IOException, JSONException {
        String query;
        if (!path.contains("format=json")) {
            try {
                URI uri = new URI(path);
                if (StringUtils.isBlank((String)uri.getQuery())) {
                    query = "?format=json";
                }
                query = "&format=json";
            }
            catch (URISyntaxException ignored) {
                throw new IOException("There was an error processing the series import filter path: " + path, ignored);
            }
        } else {
            query = "";
        }
        JSONConfigurationExtractor extractor = new JSONConfigurationExtractor();
        extractor.put("mode", "blacklist");
        extractor.put("list", "");
        this.doGet(path + query, extractor);
        return extractor;
    }

    public boolean isSiteWideAnonScriptEnabled() throws IOException, JSONException {
        JSONConfigurationExtractor extractor = new JSONConfigurationExtractor();
        extractor.put("status", "disabled");
        extractor.put("contents", "");
        this.doGet("/data/config/anon/script?format=json", extractor);
        boolean enabled = extractor.get("status").equals("enabled");
        if (enabled) {
            this._siteWideAnonScript = (String)extractor.get("contents");
        }
        return enabled;
    }

    public String getSiteWideAnonScript() {
        if (this._siteWideAnonScript == null) {
            return "";
        }
        return this._siteWideAnonScript;
    }

    public InputStream getSiteWideAnonScriptAsStream() {
        return new ByteArrayInputStream(this.getSiteWideAnonScript().getBytes());
    }

    public String getUserAuthMessage() throws IOException {
        StringResponseProcessor rp = new StringResponseProcessor();
        try {
            this.request("/data/auth", GET, rp);
            return rp.toString();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static boolean isNullOrEmpty(String s) {
        return null == s || "".equals(s);
    }

    static JSONObject extractJSONEntity(InputStream in) throws IOException, JSONException {
        return new JSONObject(new JSONTokener((Reader)new InputStreamReader(in)));
    }

    static JSONArray extractResultFromEntity(JSONObject entity) throws JSONException {
        return entity.getJSONObject("ResultSet").getJSONArray("Result");
    }

    private static String makeBasicAuthorization(PasswordAuthentication auth) {
        return "Basic " + Base64.encode((String)(auth.getUserName() + ":" + Arrays.toString(auth.getPassword())));
    }

    private static void addBasicAuthorizationToHeaderMap(Map<String, String> m, PasswordAuthentication auth) {
        m.put(AUTHORIZATION_HEADER, RestServer.makeBasicAuthorization(auth));
    }

    private static void addBasicAuthorization(URLConnection conn, PasswordAuthentication auth) {
        conn.addRequestProperty(AUTHORIZATION_HEADER, RestServer.makeBasicAuthorization(auth));
    }

    private void doGet(String path, JSONDecoder decoder) throws IOException, JSONException {
        try {
            this.doGet(path, new JSONResultExtractor(decoder));
        }
        catch (IOException e) {
            throw e;
        }
        catch (JSONException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void request(String path, String method, HttpURLConnectionProcessor processor) throws Exception {
        Object es;
        LinkedHashMap headers = Maps.newLinkedHashMap(defaultHeaders);
        StringBuilder sb = new StringBuilder(this._base.toString());
        if ('/' != path.charAt(0)) {
            sb.append('/');
        }
        sb.append(path);
        final URL url = new URL(sb.toString());
        this.logger.trace("{} preparing request {}", (Object)this, (Object)url);
        if (this.logger.isTraceEnabled()) {
            Callable<List<String>> callable = new Callable<List<String>>(){

                @Override
                public List<String> call() throws IOException, URISyntaxException {
                    CookieHandler ch = CookieHandler.getDefault();
                    Map<String, List<String>> h = ch.get(url.toURI(), new HashMap<String, List<String>>());
                    return h.get("Cookie");
                }
            };
            es = Executors.newSingleThreadExecutor();
            try {
                List cookies = (List)es.invokeAny(Collections.singleton(callable), 10L, TimeUnit.SECONDS);
                this.logger.trace("session cookies: {}", (Object)cookies);
            }
            catch (Exception e) {
                this.logger.error("Unable to query cookie store", (Throwable)e);
            }
        }
        Service service = new Service(url);
        es = this.passStore;
        synchronized (es) {
            if (this.passStore.containsKey(service)) {
                RestServer.addBasicAuthorizationToHeaderMap(headers, this.passStore.get(service));
            }
        }
        this.logger.trace("opening connection to {}", (Object)url);
        HttpURLConnection connection = null;
        int attempts = 0;
        block18: while (true) {
            try {
                connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(method);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                connection.setUseCaches(false);
                for (Map.Entry me : headers.entrySet()) {
                    if (connection.getRequestProperties().containsKey(me.getKey())) continue;
                    connection.setRequestProperty((String)me.getKey(), (String)me.getValue());
                }
                this.getJSESSIONIDCookie().setInRequestHeader((URLConnection)connection);
                processor.prepare(connection);
                int responseCode = connection.getResponseCode();
                switch (responseCode) {
                    case 202: 
                    case 203: 
                    case 204: 
                    case 205: 
                    case 206: 
                    case 301: {
                        this.logger.trace(connection.getRequestMethod() + " to {} returned " + responseCode + " ({})", (Object)url, (Object)connection.getResponseMessage());
                    }
                    case 200: 
                    case 201: {
                        processor.process(connection);
                        return;
                    }
                    case 302: 
                    case 401: {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Received status code " + (responseCode == 302 ? "302 (Redirect)" : "401 (Unauthorized)"));
                            for (Map.Entry<String, List<String>> me : connection.getHeaderFields().entrySet()) {
                                this.logger.trace("Header {} : {}", (Object)me.getKey(), me.getValue());
                            }
                            this.logger.debug("Will request credentials for {}", (Object)url);
                        }
                        RestServer.addBasicAuthorizationToHeaderMap(headers, this.getPasswordAuthentication(service, url));
                        if (attempts++ < 3) continue block18;
                        throw new HttpException(responseCode, "Unable to connect to " + url.toString(), "Ugh");
                    }
                    case 409: {
                        throw new ConflictHttpException(RestServer.getErrorEntity(connection));
                    }
                }
                StringBuilder message = new StringBuilder();
                message.append(connection.getRequestMethod());
                message.append(" to ").append(url).append(" failed ");
                try {
                    String entity = RestServer.getErrorEntity(connection);
                    if (null != entity) {
                        message.append(": ").append(entity);
                    }
                }
                catch (Throwable t) {
                    message.append(" - ").append(t.getMessage());
                }
                throw new HttpException(responseCode, connection.getResponseMessage(), message.toString());
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getErrorEntity(HttpURLConnection connection) throws IOException {
        InputStream errorStream = connection.getErrorStream();
        try {
            if (null != errorStream) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                IOUtils.copy((OutputStream)stream, (InputStream)errorStream);
                if (stream.size() > 0) {
                    String string = stream.toString();
                    return string;
                }
            }
            String string = null;
            return string;
        }
        finally {
            if (errorStream != null) {
                try {
                    errorStream.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private void request(String path, String method) throws IOException {
        try {
            this.request(path, method, new EmptyRequest());
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void request(String path, String method, InputStream in, String mimeMediaType, Integer contentLength, ResultProgressHandle progress) throws IOException {
        try {
            this.request(path, method, new StreamUploadProcessor(in, mimeMediaType, contentLength, progress));
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void request(String path, String method, File f, String mimeMediaType, ResultProgressHandle progress) throws IOException {
        this.request(path, method, new FileInputStream(f), mimeMediaType, Long.valueOf(f.length()).intValue(), progress);
    }

    public void doGet(String path, HttpURLConnectionProcessor processor) throws Exception {
        this.request(path, GET, processor);
    }

    public void doPost(String path, HttpURLConnectionProcessor processor) throws Exception {
        this.request(path, POST, processor);
    }

    public void doPut(String path, HttpURLConnectionProcessor processor) throws Exception {
        this.request(path, PUT, processor);
    }

    public void doPost(String path) throws IOException {
        this.request(path, POST);
    }

    public void doPut(String path) throws IOException {
        this.request(path, PUT);
    }

    public void doPut(String path, File f, String mimeMediaType, ResultProgressHandle progress) throws IOException {
        this.request(path, PUT, f, mimeMediaType, progress);
    }

    public Collection<Object> getValues(String path, String key) throws IOException, JSONException {
        JSONValuesExtractor extractor = new JSONValuesExtractor(new LinkedHashSet<Object>(), key);
        this.doGet(path, extractor);
        return extractor.getValues();
    }

    public Map<String, String> getAliases(String path, String aliasKey, String idKey) throws IOException, JSONException {
        JSONAliasesExtractor extractor = new JSONAliasesExtractor(new LinkedHashMap<String, String>(), aliasKey, idKey);
        this.doGet(path, extractor);
        return extractor.getAliases();
    }

    public URL getURL() {
        return this._base;
    }

    public void setDescription(URL url, String description) {
        this.descriptions.put(new Service(url), description);
    }

    public JSESSIONIDCookie getJSESSIONIDCookie() {
        return this._jsessionidCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordAuthentication getPasswordAuthentication(Service service, URL url) {
        Map<Service, PasswordAuthentication> map = this.passStore;
        synchronized (map) {
            PasswordAuthentication auth = this.passStore.get(service);
            if (null == auth) {
                String prompt = "Enter credentials for " + (this.descriptions.containsKey(service) ? this.descriptions.get(service) : service);
                auth = Authenticator.requestPasswordAuthentication(url.getHost(), null, url.getPort(), url.getProtocol(), prompt, url.getProtocol());
                this.passStore.put(service, auth);
            }
            return auth;
        }
    }

    private PasswordAuthentication getPasswordAuthentication(URL url) {
        return this.getPasswordAuthentication(new Service(url), url);
    }

    public URLConnection addAuthorization(URLConnection connection) {
        if ("".equals(this._jsessionidCookie.toString())) {
            RestServer.addBasicAuthorization(connection, this.getPasswordAuthentication(connection.getURL()));
        } else {
            this._jsessionidCookie.setInRequestHeader(connection);
        }
        return connection;
    }

    static {
        Properties props = new Properties();
        ClassLoader cl = RestServer.class.getClassLoader();
        try {
            props.load(cl.getResourceAsStream("META-INF/application.properties"));
        }
        catch (Throwable t) {
            LoggerFactory.getLogger(RestServer.class).error("Unable to load properties", t);
        }
        TITLE = props.getProperty("application.name");
        VERSION = props.getProperty("application.version");
        defaultHeaders = ImmutableMap.of((Object)"User-Agent", (Object)("XNATUploadAssistant/" + VERSION), (Object)"Accept", (Object)"*/*");
    }

    private static final class JSONAliasesExtractor
    implements JSONDecoder {
        private final Logger logger = LoggerFactory.getLogger(JSONAliasesExtractor.class);
        private final Map<String, String> m;
        private final String aliasKey;
        private final String idKey;

        JSONAliasesExtractor(Map<String, String> m, String aliasKey, String idKey) {
            this.m = m;
            this.aliasKey = aliasKey;
            this.idKey = idKey;
        }

        @Override
        public void decode(JSONObject o) throws JSONException {
            String id;
            this.logger.trace("decoding {} using {} -> {}", new Object[]{o, this.aliasKey, this.idKey});
            String alias = o.has(this.aliasKey) ? o.getString(this.aliasKey) : null;
            String string = id = o.has(this.idKey) ? o.getString(this.idKey) : null;
            if (!RestServer.isNullOrEmpty(alias)) {
                this.m.put(alias, RestServer.isNullOrEmpty(id) ? alias : id);
            } else if (!RestServer.isNullOrEmpty(id)) {
                this.m.put(id, id);
            }
        }

        public Map<String, String> getAliases() {
            return this.m;
        }
    }

    private static final class JSONConfigurationExtractor
    extends HashMap<String, Object>
    implements JSONDecoder {
        private JSONConfigurationExtractor() {
        }

        @Override
        public void decode(JSONObject json) throws JSONException {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.put(key, json.get(key));
            }
            if (this.containsKey("status") && !this.get("status").equals("enabled")) {
                this.put("status", "disabled");
                return;
            }
            if (this.containsKey("contents")) {
                String contents = (String)this.get("contents");
                try {
                    JSONObject translated = new JSONObject(new JSONTokener(contents));
                    HashMap<String, Object> decoded = new HashMap<String, Object>();
                    Iterator contentKeys = translated.keys();
                    while (contentKeys.hasNext()) {
                        String key;
                        decoded.put(key, translated.has(key = (String)contentKeys.next()) ? translated.get(key) : "");
                    }
                    this.put("contents", decoded);
                }
                catch (JSONException ignored) {
                    // empty catch block
                }
            }
        }
    }

    static interface JSONDecoder {
        public void decode(JSONObject var1) throws JSONException;
    }

    private static final class JSONValuesExtractor
    implements JSONDecoder {
        private final Logger logger = LoggerFactory.getLogger(JSONValuesExtractor.class);
        private final Collection<Object> c;
        private final String key;

        JSONValuesExtractor(Collection<Object> c, String key) {
            this.c = c;
            this.key = key;
        }

        @Override
        public void decode(JSONObject o) throws JSONException {
            this.logger.trace("decoding {} from {}", (Object)this.key, (Object)o);
            if (o.has(this.key)) {
                this.c.add(o.get(this.key));
            }
        }

        public Collection<Object> getValues() {
            return this.c;
        }
    }

    private static final class Service {
        private final String protocol;
        private final String host;
        private final int port;

        Service(String protocol, String host, int port) {
            this.protocol = protocol;
            this.host = host;
            this.port = port;
        }

        Service(URL url) {
            this(url.getProtocol(), url.getHost(), url.getPort());
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.protocol.hashCode();
            result = 37 * result + this.host.hashCode();
            result = 37 * result + this.port;
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Service)) {
                return false;
            }
            Service other = (Service)o;
            return this.protocol.equals(other.protocol) && this.host.equals(other.host) && this.port == other.port;
        }

        public String toString() {
            try {
                return new URL(this.protocol, this.host, this.port, "").toString();
            }
            catch (MalformedURLException e) {
                return MessageFormat.format("{0}://{1}:{2}", this.protocol, this.host, this.port);
            }
        }
    }
}

